package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class IntegrationStatusFluentImpl<A extends IntegrationStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationStatusFluent<A> {

    private List<String> capabilities;
    private List<IntegrationConditionBuilder> conditions;
    private List<ConfigurationSpecBuilder> configuration;
    private List<String> dependencies;
    private String digest;
    private FailureBuilder failure;
    private List<ResourceSpecBuilder> generatedResources;
    private List<SourceSpecBuilder> generatedSources;
    private String image;
    private String kit;
    private String lastInitTimestamp;
    private String phase;
    private String platform;
    private String profile;
    private Integer replicas;
    private String runtimeProvider;
    private String runtimeVersion;
    private String selector;
    private String version;

    public IntegrationStatusFluentImpl() {
    }

    public IntegrationStatusFluentImpl(IntegrationStatus instance) {
        this.withCapabilities(instance.getCapabilities()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withDependencies(instance.getDependencies()); 
        this.withDigest(instance.getDigest()); 
        this.withFailure(instance.getFailure()); 
        this.withGeneratedResources(instance.getGeneratedResources()); 
        this.withGeneratedSources(instance.getGeneratedSources()); 
        this.withImage(instance.getImage()); 
        this.withKit(instance.getKit()); 
        this.withLastInitTimestamp(instance.getLastInitTimestamp()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withProfile(instance.getProfile()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRuntimeProvider(instance.getRuntimeProvider()); 
        this.withRuntimeVersion(instance.getRuntimeVersion()); 
        this.withSelector(instance.getSelector()); 
        this.withVersion(instance.getVersion()); 
    }

    public A addToCapabilities(int index,String item) {
        if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
        this.capabilities.add(index, item);
        return (A)this;
    }

    public A setToCapabilities(int index,String item) {
        if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
        this.capabilities.set(index, item); return (A)this;
    }

    public A addToCapabilities(String... items) {
        if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
        for (String item : items) {this.capabilities.add(item);} return (A)this;
    }

    public A addAllToCapabilities(Collection<String> items) {
        if (this.capabilities == null) {this.capabilities = new ArrayList<String>();}
        for (String item : items) {this.capabilities.add(item);} return (A)this;
    }

    public A removeFromCapabilities(String... items) {
        for (String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromCapabilities(Collection<String> items) {
        for (String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public String getCapability(int index) {
        return this.capabilities.get(index);
    }

    public String getFirstCapability() {
        return this.capabilities.get(0);
    }

    public String getLastCapability() {
        return this.capabilities.get(capabilities.size() - 1);
    }

    public String getMatchingCapability(Predicate<String> predicate) {
        for (String item: capabilities) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCapability(Predicate<String> predicate) {
        for (String item: capabilities) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCapabilities(List<String> capabilities) {
        if (this.capabilities != null) { _visitables.get("capabilities").removeAll(this.capabilities);}
        if (capabilities != null) {this.capabilities = new ArrayList<String>(); for (String item : capabilities){this.addToCapabilities(item);}} else { this.capabilities = null;} return (A) this;
    }

    public A withCapabilities(String... capabilities) {
        if (this.capabilities != null) {this.capabilities.clear();}
        if (capabilities != null) {for (String item :capabilities){ this.addToCapabilities(item);}} return (A) this;
    }

    public Boolean hasCapabilities() {
        return capabilities != null && !capabilities.isEmpty();
    }

    public A addNewCapability(StringBuilder arg1) {
        return (A)addToCapabilities(new String(arg1));
    }

    public A addNewCapability(int[] arg1,int arg2,int arg3) {
        return (A)addToCapabilities(new String(arg1, arg2, arg3));
    }

    public A addNewCapability(char[] arg1) {
        return (A)addToCapabilities(new String(arg1));
    }

    public A addNewCapability(StringBuffer arg1) {
        return (A)addToCapabilities(new String(arg1));
    }

    public A addNewCapability(byte[] arg1,int arg2) {
        return (A)addToCapabilities(new String(arg1, arg2));
    }

    public A addNewCapability(byte[] arg1) {
        return (A)addToCapabilities(new String(arg1));
    }

    public A addNewCapability(char[] arg1,int arg2,int arg3) {
        return (A)addToCapabilities(new String(arg1, arg2, arg3));
    }

    public A addNewCapability(byte[] arg1,int arg2,int arg3) {
        return (A)addToCapabilities(new String(arg1, arg2, arg3));
    }

    public A addNewCapability(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToCapabilities(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewCapability(String arg1) {
        return (A)addToCapabilities(new String(arg1));
    }

    public A addToConditions(int index,IntegrationCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
        IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,IntegrationCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
        IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(IntegrationCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
        for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<IntegrationCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationConditionBuilder>();}
        for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(IntegrationCondition... items) {
        for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<IntegrationCondition> items) {
        for (IntegrationCondition item : items) {IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<IntegrationConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<IntegrationConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          IntegrationConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<IntegrationCondition> getConditions() {
        return build(conditions);
    }

    public List<IntegrationCondition> buildConditions() {
        return build(conditions);
    }

    public IntegrationCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public IntegrationCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public IntegrationCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public IntegrationCondition buildMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
        for (IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
        for (IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<IntegrationCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<IntegrationConditionBuilder>(); for (IntegrationCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(IntegrationCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (IntegrationCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(int index,IntegrationCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
    }

    public A setToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
        if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
         return (A)this;
    }

    public A addToConfiguration(ConfigurationSpec... items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A removeFromConfiguration(ConfigurationSpec... items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (configuration == null) return (A) this;
        final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
        final List visitables = _visitables.get("configuration");
        while (each.hasNext()) {
          ConfigurationSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration() {
        return build(configuration);
    }

    public List<ConfigurationSpec> buildConfiguration() {
        return build(configuration);
    }

    public ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(configuration.size() - 1).build();
    }

    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
        if (configuration != null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
    }

    public A withConfiguration(ConfigurationSpec... configuration) {
        if (this.configuration != null) {this.configuration.clear();}
        if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
    }

    public Boolean hasConfiguration() {
        return configuration != null && !configuration.isEmpty();
    }

    public A addNewConfiguration(String type,String value) {
        return (A)addToConfiguration(new ConfigurationSpec(type, value));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
        return setNewConfigurationLike(0, buildConfiguration(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = configuration.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<configuration.size();i++) { 
        if (predicate.test(configuration.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public A addToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.add(index, item);
        return (A)this;
    }

    public A setToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.set(index, item); return (A)this;
    }

    public A addToDependencies(String... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A removeFromDependencies(String... items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<String>(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(String... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(StringBuilder arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(int[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(char[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(StringBuffer arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(byte[] arg1,int arg2) {
        return (A)addToDependencies(new String(arg1, arg2));
    }

    public A addNewDependency(byte[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(char[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToDependencies(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewDependency(String arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public String getDigest() {
        return this.digest;
    }

    public A withDigest(String digest) {
        this.digest=digest; return (A) this;
    }

    public Boolean hasDigest() {
        return this.digest != null;
    }

    public A withNewDigest(StringBuilder arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(int[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(char[] arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(StringBuffer arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(byte[] arg1,int arg2) {
        return (A)withDigest(new String(arg1, arg2));
    }

    public A withNewDigest(byte[] arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(char[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(byte[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDigest(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDigest(String arg1) {
        return (A)withDigest(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFailure instead.
 * @return The buildable object.
 */
@Deprecated public Failure getFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public Failure buildFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public A withFailure(Failure failure) {
        _visitables.get("failure").remove(this.failure);
        if (failure!=null){ this.failure= new FailureBuilder(failure); _visitables.get("failure").add(this.failure);} return (A) this;
    }

    public Boolean hasFailure() {
        return this.failure != null;
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> withNewFailure() {
        return new FailureNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> withNewFailureLike(Failure item) {
        return new FailureNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> editFailure() {
        return withNewFailureLike(getFailure());
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> editOrNewFailure() {
        return withNewFailureLike(getFailure() != null ? getFailure(): new FailureBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item) {
        return withNewFailureLike(getFailure() != null ? getFailure(): item);
    }

    public A addToGeneratedResources(int index,ResourceSpec item) {
        if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").add(index >= 0 ? index : _visitables.get("generatedResources").size(), builder);this.generatedResources.add(index >= 0 ? index : generatedResources.size(), builder); return (A)this;
    }

    public A setToGeneratedResources(int index,ResourceSpec item) {
        if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("generatedResources").size()) { _visitables.get("generatedResources").add(builder); } else { _visitables.get("generatedResources").set(index, builder);}
        if (index < 0 || index >= generatedResources.size()) { generatedResources.add(builder); } else { generatedResources.set(index, builder);}
         return (A)this;
    }

    public A addToGeneratedResources(ResourceSpec... items) {
        if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
    }

    public A addAllToGeneratedResources(Collection<ResourceSpec> items) {
        if (this.generatedResources == null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>();}
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
    }

    public A removeFromGeneratedResources(ResourceSpec... items) {
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
    }

    public A removeAllFromGeneratedResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGeneratedResources(Predicate<ResourceSpecBuilder> predicate) {
        if (generatedResources == null) return (A) this;
        final Iterator<ResourceSpecBuilder> each = generatedResources.iterator();
        final List visitables = _visitables.get("generatedResources");
        while (each.hasNext()) {
          ResourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildGeneratedResources instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceSpec> getGeneratedResources() {
        return build(generatedResources);
    }

    public List<ResourceSpec> buildGeneratedResources() {
        return build(generatedResources);
    }

    public ResourceSpec buildGeneratedResource(int index) {
        return this.generatedResources.get(index).build();
    }

    public ResourceSpec buildFirstGeneratedResource() {
        return this.generatedResources.get(0).build();
    }

    public ResourceSpec buildLastGeneratedResource() {
        return this.generatedResources.get(generatedResources.size() - 1).build();
    }

    public ResourceSpec buildMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGeneratedResources(List<ResourceSpec> generatedResources) {
        if (this.generatedResources != null) { _visitables.get("generatedResources").removeAll(this.generatedResources);}
        if (generatedResources != null) {this.generatedResources = new ArrayList<ResourceSpecBuilder>(); for (ResourceSpec item : generatedResources){this.addToGeneratedResources(item);}} else { this.generatedResources = null;} return (A) this;
    }

    public A withGeneratedResources(ResourceSpec... generatedResources) {
        if (this.generatedResources != null) {this.generatedResources.clear();}
        if (generatedResources != null) {for (ResourceSpec item :generatedResources){ this.addToGeneratedResources(item);}} return (A) this;
    }

    public Boolean hasGeneratedResources() {
        return generatedResources != null && !generatedResources.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource() {
        return new GeneratedResourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(ResourceSpec item) {
        return new GeneratedResourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(int index,ResourceSpec item) {
        return new GeneratedResourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(int index) {
        if (generatedResources.size() <= index) throw new RuntimeException("Can't edit generatedResources. Index exceeds size.");
        return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource() {
        if (generatedResources.size() == 0) throw new RuntimeException("Can't edit first generatedResources. The list is empty.");
        return setNewGeneratedResourceLike(0, buildGeneratedResource(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource() {
        int index = generatedResources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last generatedResources. The list is empty.");
        return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<generatedResources.size();i++) { 
        if (predicate.test(generatedResources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching generatedResources. No match found.");
        return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
    }

    public A addToGeneratedSources(int index,SourceSpec item) {
        if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
        SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").add(index >= 0 ? index : _visitables.get("generatedSources").size(), builder);this.generatedSources.add(index >= 0 ? index : generatedSources.size(), builder); return (A)this;
    }

    public A setToGeneratedSources(int index,SourceSpec item) {
        if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("generatedSources").size()) { _visitables.get("generatedSources").add(builder); } else { _visitables.get("generatedSources").set(index, builder);}
        if (index < 0 || index >= generatedSources.size()) { generatedSources.add(builder); } else { generatedSources.set(index, builder);}
         return (A)this;
    }

    public A addToGeneratedSources(SourceSpec... items) {
        if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
    }

    public A addAllToGeneratedSources(Collection<SourceSpec> items) {
        if (this.generatedSources == null) {this.generatedSources = new ArrayList<SourceSpecBuilder>();}
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
    }

    public A removeFromGeneratedSources(SourceSpec... items) {
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
    }

    public A removeAllFromGeneratedSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGeneratedSources(Predicate<SourceSpecBuilder> predicate) {
        if (generatedSources == null) return (A) this;
        final Iterator<SourceSpecBuilder> each = generatedSources.iterator();
        final List visitables = _visitables.get("generatedSources");
        while (each.hasNext()) {
          SourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildGeneratedSources instead.
 * @return The buildable object.
 */
@Deprecated public List<SourceSpec> getGeneratedSources() {
        return build(generatedSources);
    }

    public List<SourceSpec> buildGeneratedSources() {
        return build(generatedSources);
    }

    public SourceSpec buildGeneratedSource(int index) {
        return this.generatedSources.get(index).build();
    }

    public SourceSpec buildFirstGeneratedSource() {
        return this.generatedSources.get(0).build();
    }

    public SourceSpec buildLastGeneratedSource() {
        return this.generatedSources.get(generatedSources.size() - 1).build();
    }

    public SourceSpec buildMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGeneratedSources(List<SourceSpec> generatedSources) {
        if (this.generatedSources != null) { _visitables.get("generatedSources").removeAll(this.generatedSources);}
        if (generatedSources != null) {this.generatedSources = new ArrayList<SourceSpecBuilder>(); for (SourceSpec item : generatedSources){this.addToGeneratedSources(item);}} else { this.generatedSources = null;} return (A) this;
    }

    public A withGeneratedSources(SourceSpec... generatedSources) {
        if (this.generatedSources != null) {this.generatedSources.clear();}
        if (generatedSources != null) {for (SourceSpec item :generatedSources){ this.addToGeneratedSources(item);}} return (A) this;
    }

    public Boolean hasGeneratedSources() {
        return generatedSources != null && !generatedSources.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource() {
        return new GeneratedSourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(SourceSpec item) {
        return new GeneratedSourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(int index,SourceSpec item) {
        return new GeneratedSourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(int index) {
        if (generatedSources.size() <= index) throw new RuntimeException("Can't edit generatedSources. Index exceeds size.");
        return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource() {
        if (generatedSources.size() == 0) throw new RuntimeException("Can't edit first generatedSources. The list is empty.");
        return setNewGeneratedSourceLike(0, buildGeneratedSource(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource() {
        int index = generatedSources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last generatedSources. The list is empty.");
        return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<generatedSources.size();i++) { 
        if (predicate.test(generatedSources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching generatedSources. No match found.");
        return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getKit() {
        return this.kit;
    }

    public A withKit(String kit) {
        this.kit=kit; return (A) this;
    }

    public Boolean hasKit() {
        return this.kit != null;
    }

    public A withNewKit(StringBuilder arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(int[] arg1,int arg2,int arg3) {
        return (A)withKit(new String(arg1, arg2, arg3));
    }

    public A withNewKit(char[] arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(StringBuffer arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(byte[] arg1,int arg2) {
        return (A)withKit(new String(arg1, arg2));
    }

    public A withNewKit(byte[] arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(char[] arg1,int arg2,int arg3) {
        return (A)withKit(new String(arg1, arg2, arg3));
    }

    public A withNewKit(byte[] arg1,int arg2,int arg3) {
        return (A)withKit(new String(arg1, arg2, arg3));
    }

    public A withNewKit(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKit(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKit(String arg1) {
        return (A)withKit(new String(arg1));
    }

    public String getLastInitTimestamp() {
        return this.lastInitTimestamp;
    }

    public A withLastInitTimestamp(String lastInitTimestamp) {
        this.lastInitTimestamp=lastInitTimestamp; return (A) this;
    }

    public Boolean hasLastInitTimestamp() {
        return this.lastInitTimestamp != null;
    }

    public A withNewLastInitTimestamp(StringBuilder arg1) {
        return (A)withLastInitTimestamp(new String(arg1));
    }

    public A withNewLastInitTimestamp(int[] arg1,int arg2,int arg3) {
        return (A)withLastInitTimestamp(new String(arg1, arg2, arg3));
    }

    public A withNewLastInitTimestamp(char[] arg1) {
        return (A)withLastInitTimestamp(new String(arg1));
    }

    public A withNewLastInitTimestamp(StringBuffer arg1) {
        return (A)withLastInitTimestamp(new String(arg1));
    }

    public A withNewLastInitTimestamp(byte[] arg1,int arg2) {
        return (A)withLastInitTimestamp(new String(arg1, arg2));
    }

    public A withNewLastInitTimestamp(byte[] arg1) {
        return (A)withLastInitTimestamp(new String(arg1));
    }

    public A withNewLastInitTimestamp(char[] arg1,int arg2,int arg3) {
        return (A)withLastInitTimestamp(new String(arg1, arg2, arg3));
    }

    public A withNewLastInitTimestamp(byte[] arg1,int arg2,int arg3) {
        return (A)withLastInitTimestamp(new String(arg1, arg2, arg3));
    }

    public A withNewLastInitTimestamp(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLastInitTimestamp(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLastInitTimestamp(String arg1) {
        return (A)withLastInitTimestamp(new String(arg1));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(int[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(char[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(byte[] arg1,int arg2) {
        return (A)withPhase(new String(arg1, arg2));
    }

    public A withNewPhase(byte[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(char[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPhase(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform=platform; return (A) this;
    }

    public Boolean hasPlatform() {
        return this.platform != null;
    }

    public A withNewPlatform(StringBuilder arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(int[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(char[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(StringBuffer arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(byte[] arg1,int arg2) {
        return (A)withPlatform(new String(arg1, arg2));
    }

    public A withNewPlatform(byte[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(char[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPlatform(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPlatform(String arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile=profile; return (A) this;
    }

    public Boolean hasProfile() {
        return this.profile != null;
    }

    public A withNewProfile(StringBuilder arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(int[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(char[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(StringBuffer arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(byte[] arg1,int arg2) {
        return (A)withProfile(new String(arg1, arg2));
    }

    public A withNewProfile(byte[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(char[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withProfile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewProfile(String arg1) {
        return (A)withProfile(new String(arg1));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public A withNewReplicas(int arg0) {
        return (A)withReplicas(new Integer(arg0));
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider=runtimeProvider; return (A) this;
    }

    public Boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public A withNewRuntimeProvider(StringBuilder arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(char[] arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(StringBuffer arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2) {
        return (A)withRuntimeProvider(new String(arg1, arg2));
    }

    public A withNewRuntimeProvider(byte[] arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeProvider(String arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion=runtimeVersion; return (A) this;
    }

    public Boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public A withNewRuntimeVersion(StringBuilder arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(char[] arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(StringBuffer arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2) {
        return (A)withRuntimeVersion(new String(arg1, arg2));
    }

    public A withNewRuntimeVersion(byte[] arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeVersion(String arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public String getSelector() {
        return this.selector;
    }

    public A withSelector(String selector) {
        this.selector=selector; return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public A withNewSelector(StringBuilder arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(int[] arg1,int arg2,int arg3) {
        return (A)withSelector(new String(arg1, arg2, arg3));
    }

    public A withNewSelector(char[] arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(StringBuffer arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(byte[] arg1,int arg2) {
        return (A)withSelector(new String(arg1, arg2));
    }

    public A withNewSelector(byte[] arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(char[] arg1,int arg2,int arg3) {
        return (A)withSelector(new String(arg1, arg2, arg3));
    }

    public A withNewSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withSelector(new String(arg1, arg2, arg3));
    }

    public A withNewSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSelector(String arg1) {
        return (A)withSelector(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationStatusFluentImpl that = (IntegrationStatusFluentImpl) o;
        if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
        if (failure != null ? !failure.equals(that.failure) :that.failure != null) return false;
        if (generatedResources != null ? !generatedResources.equals(that.generatedResources) :that.generatedResources != null) return false;
        if (generatedSources != null ? !generatedSources.equals(that.generatedSources) :that.generatedSources != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (kit != null ? !kit.equals(that.kit) :that.kit != null) return false;
        if (lastInitTimestamp != null ? !lastInitTimestamp.equals(that.lastInitTimestamp) :that.lastInitTimestamp != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
        if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(capabilities,  conditions,  configuration,  dependencies,  digest,  failure,  generatedResources,  generatedSources,  image,  kit,  lastInitTimestamp,  phase,  platform,  profile,  replicas,  runtimeProvider,  runtimeVersion,  selector,  version,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends IntegrationConditionFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,IntegrationCondition item) {
                this.index = index;
                this.builder = new IntegrationConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new IntegrationConditionBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigurationSpecBuilder builder;
        private final int index;

            ConfigurationNestedImpl(int index,ConfigurationSpec item) {
                this.index = index;
                this.builder = new ConfigurationSpecBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.index = -1;
                this.builder = new ConfigurationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToConfiguration(index,builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


    public class FailureNestedImpl<N> extends FailureFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FailureBuilder builder;

            FailureNestedImpl(Failure item) {
                this.builder = new FailureBuilder(this, item);
                        
            }

            FailureNestedImpl() {
                this.builder = new FailureBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.withFailure(builder.build());
            }

            public N endFailure() {
                return and();
            }
    }


    public class GeneratedResourcesNestedImpl<N> extends ResourceSpecFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceSpecBuilder builder;
        private final int index;

            GeneratedResourcesNestedImpl(int index,ResourceSpec item) {
                this.index = index;
                this.builder = new ResourceSpecBuilder(this, item);
                        
            }

            GeneratedResourcesNestedImpl() {
                this.index = -1;
                this.builder = new ResourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToGeneratedResources(index,builder.build());
            }

            public N endGeneratedResource() {
                return and();
            }
    }


    public class GeneratedSourcesNestedImpl<N> extends SourceSpecFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SourceSpecBuilder builder;
        private final int index;

            GeneratedSourcesNestedImpl(int index,SourceSpec item) {
                this.index = index;
                this.builder = new SourceSpecBuilder(this, item);
                        
            }

            GeneratedSourcesNestedImpl() {
                this.index = -1;
                this.builder = new SourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToGeneratedSources(index,builder.build());
            }

            public N endGeneratedSource() {
                return and();
            }
    }


}
