package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CamelLoaderFluentImpl<A extends CamelLoaderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CamelLoaderFluent<A> {

    private String artifactId;
    private List<MavenArtifactBuilder> dependencies;
    private String groupId;
    private List<String> languages;
    private String version;

    public CamelLoaderFluentImpl() {
    }

    public CamelLoaderFluentImpl(CamelLoader instance) {
        this.withArtifactId(instance.getArtifactId()); 
        this.withDependencies(instance.getDependencies()); 
        this.withGroupId(instance.getGroupId()); 
        this.withLanguages(instance.getLanguages()); 
        this.withVersion(instance.getVersion()); 
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public A withArtifactId(String artifactId) {
        this.artifactId=artifactId; return (A) this;
    }

    public Boolean hasArtifactId() {
        return this.artifactId != null;
    }

    public A withNewArtifactId(StringBuilder arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(int[] arg1,int arg2,int arg3) {
        return (A)withArtifactId(new String(arg1, arg2, arg3));
    }

    public A withNewArtifactId(char[] arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(StringBuffer arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(byte[] arg1,int arg2) {
        return (A)withArtifactId(new String(arg1, arg2));
    }

    public A withNewArtifactId(byte[] arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(char[] arg1,int arg2,int arg3) {
        return (A)withArtifactId(new String(arg1, arg2, arg3));
    }

    public A withNewArtifactId(byte[] arg1,int arg2,int arg3) {
        return (A)withArtifactId(new String(arg1, arg2, arg3));
    }

    public A withNewArtifactId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withArtifactId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewArtifactId(String arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A addToDependencies(int index,MavenArtifact item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
    }

    public A setToDependencies(int index,MavenArtifact item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
        if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
         return (A)this;
    }

    public A addToDependencies(MavenArtifact... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A addAllToDependencies(Collection<MavenArtifact> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A removeFromDependencies(MavenArtifact... items) {
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<MavenArtifact> items) {
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
        if (dependencies == null) return (A) this;
        final Iterator<MavenArtifactBuilder> each = dependencies.iterator();
        final List visitables = _visitables.get("dependencies");
        while (each.hasNext()) {
          MavenArtifactBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<MavenArtifact> getDependencies() {
        return build(dependencies);
    }

    public List<MavenArtifact> buildDependencies() {
        return build(dependencies);
    }

    public MavenArtifact buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public MavenArtifact buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public MavenArtifact buildLastDependency() {
        return this.dependencies.get(dependencies.size() - 1).build();
    }

    public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<MavenArtifact> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<MavenArtifactBuilder>(); for (MavenArtifact item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(MavenArtifact... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (MavenArtifact item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(String artifactId,String groupId,String version) {
        return (A)addToDependencies(new MavenArtifact(artifactId, groupId, version));
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
        return new DependenciesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item) {
        return new DependenciesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> editDependency(int index) {
        if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> editFirstDependency() {
        if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        return setNewDependencyLike(0, buildDependency(0));
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> editLastDependency() {
        int index = dependencies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        int index = -1;
        for (int i=0;i<dependencies.size();i++) { 
        if (predicate.test(dependencies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(String groupId) {
        this.groupId=groupId; return (A) this;
    }

    public Boolean hasGroupId() {
        return this.groupId != null;
    }

    public A withNewGroupId(StringBuilder arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(int[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(char[] arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(StringBuffer arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(byte[] arg1,int arg2) {
        return (A)withGroupId(new String(arg1, arg2));
    }

    public A withNewGroupId(byte[] arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(char[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(byte[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withGroupId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewGroupId(String arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A addToLanguages(int index,String item) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        this.languages.add(index, item);
        return (A)this;
    }

    public A setToLanguages(int index,String item) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        this.languages.set(index, item); return (A)this;
    }

    public A addToLanguages(String... items) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        for (String item : items) {this.languages.add(item);} return (A)this;
    }

    public A addAllToLanguages(Collection<String> items) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        for (String item : items) {this.languages.add(item);} return (A)this;
    }

    public A removeFromLanguages(String... items) {
        for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
    }

    public A removeAllFromLanguages(Collection<String> items) {
        for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getLanguage(int index) {
        return this.languages.get(index);
    }

    public String getFirstLanguage() {
        return this.languages.get(0);
    }

    public String getLastLanguage() {
        return this.languages.get(languages.size() - 1);
    }

    public String getMatchingLanguage(Predicate<String> predicate) {
        for (String item: languages) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLanguage(Predicate<String> predicate) {
        for (String item: languages) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLanguages(List<String> languages) {
        if (this.languages != null) { _visitables.get("languages").removeAll(this.languages);}
        if (languages != null) {this.languages = new ArrayList<String>(); for (String item : languages){this.addToLanguages(item);}} else { this.languages = null;} return (A) this;
    }

    public A withLanguages(String... languages) {
        if (this.languages != null) {this.languages.clear();}
        if (languages != null) {for (String item :languages){ this.addToLanguages(item);}} return (A) this;
    }

    public Boolean hasLanguages() {
        return languages != null && !languages.isEmpty();
    }

    public A addNewLanguage(StringBuilder arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(int[] arg1,int arg2,int arg3) {
        return (A)addToLanguages(new String(arg1, arg2, arg3));
    }

    public A addNewLanguage(char[] arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(StringBuffer arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(byte[] arg1,int arg2) {
        return (A)addToLanguages(new String(arg1, arg2));
    }

    public A addNewLanguage(byte[] arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(char[] arg1,int arg2,int arg3) {
        return (A)addToLanguages(new String(arg1, arg2, arg3));
    }

    public A addNewLanguage(byte[] arg1,int arg2,int arg3) {
        return (A)addToLanguages(new String(arg1, arg2, arg3));
    }

    public A addNewLanguage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToLanguages(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewLanguage(String arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CamelLoaderFluentImpl that = (CamelLoaderFluentImpl) o;
        if (artifactId != null ? !artifactId.equals(that.artifactId) :that.artifactId != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
        if (languages != null ? !languages.equals(that.languages) :that.languages != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifactId,  dependencies,  groupId,  languages,  version,  super.hashCode());
    }

    public class DependenciesNestedImpl<N> extends MavenArtifactFluentImpl<io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<N>> implements io.fabric8.camelk.v1.CamelLoaderFluent.DependenciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MavenArtifactBuilder builder;
        private final int index;

            DependenciesNestedImpl(int index,MavenArtifact item) {
                this.index = index;
                this.builder = new MavenArtifactBuilder(this, item);
                        
            }

            DependenciesNestedImpl() {
                this.index = -1;
                this.builder = new MavenArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) CamelLoaderFluentImpl.this.setToDependencies(index,builder.build());
            }

            public N endDependency() {
                return and();
            }
    }


}
