package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class CapabilityFluentImpl<A extends CapabilityFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CapabilityFluent<A> {

    private List<MavenArtifactBuilder> dependencies;
    private java.util.Map<String,String> metadata;

    public CapabilityFluentImpl() {
    }

    public CapabilityFluentImpl(Capability instance) {
        this.withDependencies(instance.getDependencies()); 
        this.withMetadata(instance.getMetadata()); 
    }

    public A addToDependencies(int index,MavenArtifact item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
    }

    public A setToDependencies(int index,MavenArtifact item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
        if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
         return (A)this;
    }

    public A addToDependencies(MavenArtifact... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A addAllToDependencies(Collection<MavenArtifact> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A removeFromDependencies(MavenArtifact... items) {
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<MavenArtifact> items) {
        for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
        if (dependencies == null) return (A) this;
        final Iterator<MavenArtifactBuilder> each = dependencies.iterator();
        final List visitables = _visitables.get("dependencies");
        while (each.hasNext()) {
          MavenArtifactBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<MavenArtifact> getDependencies() {
        return build(dependencies);
    }

    public List<MavenArtifact> buildDependencies() {
        return build(dependencies);
    }

    public MavenArtifact buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public MavenArtifact buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public MavenArtifact buildLastDependency() {
        return this.dependencies.get(dependencies.size() - 1).build();
    }

    public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<MavenArtifact> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<MavenArtifactBuilder>(); for (MavenArtifact item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(MavenArtifact... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (MavenArtifact item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(String artifactId,String groupId,String version) {
        return (A)addToDependencies(new MavenArtifact(artifactId, groupId, version));
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
        return new DependenciesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item) {
        return new DependenciesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editDependency(int index) {
        if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editFirstDependency() {
        if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        return setNewDependencyLike(0, buildDependency(0));
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editLastDependency() {
        int index = dependencies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        int index = -1;
        for (int i=0;i<dependencies.size();i++) { 
        if (predicate.test(dependencies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public A addToMetadata(String key,String value) {
        if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
    }

    public A addToMetadata(java.util.Map<String,String> map) {
        if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap<String,String>(); }
        if(map != null) { this.metadata.putAll(map);} return (A)this;
    }

    public A removeFromMetadata(String key) {
        if(this.metadata == null) { return (A) this; }
        if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
    }

    public A removeFromMetadata(java.util.Map<String,String> map) {
        if(this.metadata == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getMetadata() {
        return this.metadata;
    }

    public <K extends Object,V extends Object>A withMetadata(java.util.Map<String,String> metadata) {
        if (metadata == null) { this.metadata =  null;} else {this.metadata = new LinkedHashMap<String,String>(metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CapabilityFluentImpl that = (CapabilityFluentImpl) o;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(dependencies,  metadata,  super.hashCode());
    }

    public class DependenciesNestedImpl<N> extends MavenArtifactFluentImpl<io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<N>> implements io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MavenArtifactBuilder builder;
        private final int index;

            DependenciesNestedImpl(int index,MavenArtifact item) {
                this.index = index;
                this.builder = new MavenArtifactBuilder(this, item);
                        
            }

            DependenciesNestedImpl() {
                this.index = -1;
                this.builder = new MavenArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) CapabilityFluentImpl.this.setToDependencies(index,builder.build());
            }

            public N endDependency() {
                return and();
            }
    }


}
