package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.lang.Object;

public class ImageTaskFluentImpl<A extends ImageTaskFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageTaskFluent<A> {

    private Affinity affinity;
    private List<String> args;
    private String builtImage;
    private List<String> command;
    private List<EnvVarBuilder> env;
    private String image;
    private String name;
    private SecurityContext securityContext;
    private List<VolumeMountBuilder> volumeMounts;
    private List<VolumeBuilder> volumes;
    private String workingDir;

    public ImageTaskFluentImpl() {
    }

    public ImageTaskFluentImpl(ImageTask instance) {
        this.withAffinity(instance.getAffinity()); 
        this.withArgs(instance.getArgs()); 
        this.withBuiltImage(instance.getBuiltImage()); 
        this.withCommand(instance.getCommand()); 
        this.withEnv(instance.getEnv()); 
        this.withImage(instance.getImage()); 
        this.withName(instance.getName()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
        this.withWorkingDir(instance.getWorkingDir()); 
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public A addToArgs(int index,String item) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        this.args.add(index, item);
        return (A)this;
    }

    public A setToArgs(int index,String item) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        this.args.set(index, item); return (A)this;
    }

    public A addToArgs(String... items) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items) {
        for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getLastArg() {
        return this.args.get(args.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item: args) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item: args) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArgs(List<String> args) {
        if (this.args != null) { _visitables.get("args").removeAll(this.args);}
        if (args != null) {this.args = new ArrayList<String>(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
    }

    public A withArgs(String... args) {
        if (this.args != null) {this.args.clear();}
        if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public Boolean hasArgs() {
        return args != null && !args.isEmpty();
    }

    public A addNewArg(StringBuilder arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(int[] arg1,int arg2,int arg3) {
        return (A)addToArgs(new String(arg1, arg2, arg3));
    }

    public A addNewArg(char[] arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(StringBuffer arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(byte[] arg1,int arg2) {
        return (A)addToArgs(new String(arg1, arg2));
    }

    public A addNewArg(byte[] arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(char[] arg1,int arg2,int arg3) {
        return (A)addToArgs(new String(arg1, arg2, arg3));
    }

    public A addNewArg(byte[] arg1,int arg2,int arg3) {
        return (A)addToArgs(new String(arg1, arg2, arg3));
    }

    public A addNewArg(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToArgs(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewArg(String arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public String getBuiltImage() {
        return this.builtImage;
    }

    public A withBuiltImage(String builtImage) {
        this.builtImage=builtImage; return (A) this;
    }

    public Boolean hasBuiltImage() {
        return this.builtImage != null;
    }

    public A withNewBuiltImage(StringBuilder arg1) {
        return (A)withBuiltImage(new String(arg1));
    }

    public A withNewBuiltImage(int[] arg1,int arg2,int arg3) {
        return (A)withBuiltImage(new String(arg1, arg2, arg3));
    }

    public A withNewBuiltImage(char[] arg1) {
        return (A)withBuiltImage(new String(arg1));
    }

    public A withNewBuiltImage(StringBuffer arg1) {
        return (A)withBuiltImage(new String(arg1));
    }

    public A withNewBuiltImage(byte[] arg1,int arg2) {
        return (A)withBuiltImage(new String(arg1, arg2));
    }

    public A withNewBuiltImage(byte[] arg1) {
        return (A)withBuiltImage(new String(arg1));
    }

    public A withNewBuiltImage(char[] arg1,int arg2,int arg3) {
        return (A)withBuiltImage(new String(arg1, arg2, arg3));
    }

    public A withNewBuiltImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBuiltImage(new String(arg1, arg2, arg3));
    }

    public A withNewBuiltImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBuiltImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBuiltImage(String arg1) {
        return (A)withBuiltImage(new String(arg1));
    }

    public A addToCommand(int index,String item) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index,String item) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        this.command.set(index, item); return (A)this;
    }

    public A addToCommand(String... items) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items) {
        for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item: command) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item: command) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCommand(List<String> command) {
        if (this.command != null) { _visitables.get("command").removeAll(this.command);}
        if (command != null) {this.command = new ArrayList<String>(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
    }

    public A withCommand(String... command) {
        if (this.command != null) {this.command.clear();}
        if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public Boolean hasCommand() {
        return command != null && !command.isEmpty();
    }

    public A addNewCommand(StringBuilder arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(int[] arg1,int arg2,int arg3) {
        return (A)addToCommand(new String(arg1, arg2, arg3));
    }

    public A addNewCommand(char[] arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(StringBuffer arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(byte[] arg1,int arg2) {
        return (A)addToCommand(new String(arg1, arg2));
    }

    public A addNewCommand(byte[] arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(char[] arg1,int arg2,int arg3) {
        return (A)addToCommand(new String(arg1, arg2, arg3));
    }

    public A addNewCommand(byte[] arg1,int arg2,int arg3) {
        return (A)addToCommand(new String(arg1, arg2, arg3));
    }

    public A addNewCommand(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToCommand(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewCommand(String arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
        EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
        if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
         return (A)this;
    }

    public A addToEnv(EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
        for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
        for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items) {
        for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (env == null) return (A) this;
        final Iterator<EnvVarBuilder> each = env.iterator();
        final List visitables = _visitables.get("env");
        while (each.hasNext()) {
          EnvVarBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvVar> getEnv() {
        return build(env);
    }

    public List<EnvVar> buildEnv() {
        return build(env);
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(env.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<EnvVarBuilder>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> setNewEnvLike(int index,EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> editEnv(int index) {
        if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> editFirstEnv() {
        if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
        return setNewEnvLike(0, buildEnv(0));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> editLastEnv() {
        int index = env.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i=0;i<env.size();i++) { 
        if (predicate.test(env.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(SecurityContext securityContext) {
        this.securityContext=securityContext; return (A) this;
    }

    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public A addToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
    }

    public A setToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
        if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
         return (A)this;
    }

    public A addToVolumeMounts(VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items) {
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (volumeMounts == null) return (A) this;
        final Iterator<VolumeMountBuilder> each = volumeMounts.iterator();
        final List visitables = _visitables.get("volumeMounts");
        while (each.hasNext()) {
          VolumeMountBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeMount> getVolumeMounts() {
        return build(volumeMounts);
    }

    public List<VolumeMount> buildVolumeMounts() {
        return build(volumeMounts);
    }

    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1).build();
    }

    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        return setNewVolumeMountLike(0, buildVolumeMount(0));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = volumeMounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumeMounts.size();i++) { 
        if (predicate.test(volumeMounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<VolumeBuilder> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          VolumeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes() {
        return build(volumes);
    }

    public List<Volume> buildVolumes() {
        return build(volumes);
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<VolumeBuilder>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> editVolume(int index) {
        if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> editFirstVolume() {
        if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
        return setNewVolumeLike(0, buildVolume(0));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> editLastVolume() {
        int index = volumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumes.size();i++) { 
        if (predicate.test(volumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir=workingDir; return (A) this;
    }

    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public A withNewWorkingDir(StringBuilder arg1) {
        return (A)withWorkingDir(new String(arg1));
    }

    public A withNewWorkingDir(int[] arg1,int arg2,int arg3) {
        return (A)withWorkingDir(new String(arg1, arg2, arg3));
    }

    public A withNewWorkingDir(char[] arg1) {
        return (A)withWorkingDir(new String(arg1));
    }

    public A withNewWorkingDir(StringBuffer arg1) {
        return (A)withWorkingDir(new String(arg1));
    }

    public A withNewWorkingDir(byte[] arg1,int arg2) {
        return (A)withWorkingDir(new String(arg1, arg2));
    }

    public A withNewWorkingDir(byte[] arg1) {
        return (A)withWorkingDir(new String(arg1));
    }

    public A withNewWorkingDir(char[] arg1,int arg2,int arg3) {
        return (A)withWorkingDir(new String(arg1, arg2, arg3));
    }

    public A withNewWorkingDir(byte[] arg1,int arg2,int arg3) {
        return (A)withWorkingDir(new String(arg1, arg2, arg3));
    }

    public A withNewWorkingDir(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withWorkingDir(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewWorkingDir(String arg1) {
        return (A)withWorkingDir(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageTaskFluentImpl that = (ImageTaskFluentImpl) o;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (args != null ? !args.equals(that.args) :that.args != null) return false;
        if (builtImage != null ? !builtImage.equals(that.builtImage) :that.builtImage != null) return false;
        if (command != null ? !command.equals(that.command) :that.command != null) return false;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(affinity,  args,  builtImage,  command,  env,  image,  name,  securityContext,  volumeMounts,  volumes,  workingDir,  super.hashCode());
    }

    public class EnvNestedImpl<N> extends EnvVarFluentImpl<io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<N>> implements io.fabric8.camelk.v1.ImageTaskFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

            EnvNestedImpl(int index,EnvVar item) {
                this.index = index;
                this.builder = new EnvVarBuilder(this, item);
                        
            }

            EnvNestedImpl() {
                this.index = -1;
                this.builder = new EnvVarBuilder(this);
                        
            }

            public N and() {
                return (N) ImageTaskFluentImpl.this.setToEnv(index,builder.build());
            }

            public N endEnv() {
                return and();
            }
    }


    public class VolumeMountsNestedImpl<N> extends VolumeMountFluentImpl<io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<N>> implements io.fabric8.camelk.v1.ImageTaskFluent.VolumeMountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

            VolumeMountsNestedImpl(int index,VolumeMount item) {
                this.index = index;
                this.builder = new VolumeMountBuilder(this, item);
                        
            }

            VolumeMountsNestedImpl() {
                this.index = -1;
                this.builder = new VolumeMountBuilder(this);
                        
            }

            public N and() {
                return (N) ImageTaskFluentImpl.this.setToVolumeMounts(index,builder.build());
            }

            public N endVolumeMount() {
                return and();
            }
    }


    public class VolumesNestedImpl<N> extends VolumeFluentImpl<io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<N>> implements io.fabric8.camelk.v1.ImageTaskFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

            VolumesNestedImpl(int index,Volume item) {
                this.index = index;
                this.builder = new VolumeBuilder(this, item);
                        
            }

            VolumesNestedImpl() {
                this.index = -1;
                this.builder = new VolumeBuilder(this);
                        
            }

            public N and() {
                return (N) ImageTaskFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endVolume() {
                return and();
            }
    }


}
