package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationListBuilder extends IntegrationListFluentImpl<IntegrationListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationList,IntegrationListBuilder> {

    IntegrationListFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationListBuilder() {
        this(true);
    }

    public IntegrationListBuilder(Boolean validationEnabled) {
        this(new IntegrationList(), validationEnabled);
    }

    public IntegrationListBuilder(IntegrationListFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationListBuilder(IntegrationListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationList(), validationEnabled);
    }

    public IntegrationListBuilder(IntegrationListFluent<?> fluent,IntegrationList instance) {
        this(fluent, instance, true);
    }

    public IntegrationListBuilder(IntegrationListFluent<?> fluent,IntegrationList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationListBuilder(IntegrationList instance) {
        this(instance,true);
    }

    public IntegrationListBuilder(IntegrationList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationList build() {
        EditableIntegrationList buildable = new EditableIntegrationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationListBuilder that = (IntegrationListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
