package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public class IntegrationPlatformBuildSpecFluentImpl<A extends IntegrationPlatformBuildSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationPlatformBuildSpecFluent<A> {

    private String baseImage;
    private String buildStrategy;
    private String httpProxySecret;
    private Boolean kanikoBuildCache;
    private MavenSpecBuilder maven;
    private String persistentVolumeClaim;
    private java.util.Map<String,String> properties;
    private String publishStrategy;
    private IntegrationPlatformRegistrySpecBuilder registry;
    private String runtimeProvider;
    private String runtimeVersion;
    private Duration timeout;

    public IntegrationPlatformBuildSpecFluentImpl() {
    }

    public IntegrationPlatformBuildSpecFluentImpl(IntegrationPlatformBuildSpec instance) {
        this.withBaseImage(instance.getBaseImage()); 
        this.withBuildStrategy(instance.getBuildStrategy()); 
        this.withHttpProxySecret(instance.getHttpProxySecret()); 
        this.withKanikoBuildCache(instance.getKanikoBuildCache()); 
        this.withMaven(instance.getMaven()); 
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
        this.withProperties(instance.getProperties()); 
        this.withPublishStrategy(instance.getPublishStrategy()); 
        this.withRegistry(instance.getRegistry()); 
        this.withRuntimeProvider(instance.getRuntimeProvider()); 
        this.withRuntimeVersion(instance.getRuntimeVersion()); 
        this.withTimeout(instance.getTimeout()); 
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(int[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(char[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(byte[] arg1,int arg2) {
        return (A)withBaseImage(new String(arg1, arg2));
    }

    public A withNewBaseImage(byte[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(char[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBaseImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public String getBuildStrategy() {
        return this.buildStrategy;
    }

    public A withBuildStrategy(String buildStrategy) {
        this.buildStrategy=buildStrategy; return (A) this;
    }

    public Boolean hasBuildStrategy() {
        return this.buildStrategy != null;
    }

    public A withNewBuildStrategy(StringBuilder arg1) {
        return (A)withBuildStrategy(new String(arg1));
    }

    public A withNewBuildStrategy(int[] arg1,int arg2,int arg3) {
        return (A)withBuildStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewBuildStrategy(char[] arg1) {
        return (A)withBuildStrategy(new String(arg1));
    }

    public A withNewBuildStrategy(StringBuffer arg1) {
        return (A)withBuildStrategy(new String(arg1));
    }

    public A withNewBuildStrategy(byte[] arg1,int arg2) {
        return (A)withBuildStrategy(new String(arg1, arg2));
    }

    public A withNewBuildStrategy(byte[] arg1) {
        return (A)withBuildStrategy(new String(arg1));
    }

    public A withNewBuildStrategy(char[] arg1,int arg2,int arg3) {
        return (A)withBuildStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewBuildStrategy(byte[] arg1,int arg2,int arg3) {
        return (A)withBuildStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewBuildStrategy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBuildStrategy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBuildStrategy(String arg1) {
        return (A)withBuildStrategy(new String(arg1));
    }

    public String getHttpProxySecret() {
        return this.httpProxySecret;
    }

    public A withHttpProxySecret(String httpProxySecret) {
        this.httpProxySecret=httpProxySecret; return (A) this;
    }

    public Boolean hasHttpProxySecret() {
        return this.httpProxySecret != null;
    }

    public A withNewHttpProxySecret(StringBuilder arg1) {
        return (A)withHttpProxySecret(new String(arg1));
    }

    public A withNewHttpProxySecret(int[] arg1,int arg2,int arg3) {
        return (A)withHttpProxySecret(new String(arg1, arg2, arg3));
    }

    public A withNewHttpProxySecret(char[] arg1) {
        return (A)withHttpProxySecret(new String(arg1));
    }

    public A withNewHttpProxySecret(StringBuffer arg1) {
        return (A)withHttpProxySecret(new String(arg1));
    }

    public A withNewHttpProxySecret(byte[] arg1,int arg2) {
        return (A)withHttpProxySecret(new String(arg1, arg2));
    }

    public A withNewHttpProxySecret(byte[] arg1) {
        return (A)withHttpProxySecret(new String(arg1));
    }

    public A withNewHttpProxySecret(char[] arg1,int arg2,int arg3) {
        return (A)withHttpProxySecret(new String(arg1, arg2, arg3));
    }

    public A withNewHttpProxySecret(byte[] arg1,int arg2,int arg3) {
        return (A)withHttpProxySecret(new String(arg1, arg2, arg3));
    }

    public A withNewHttpProxySecret(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHttpProxySecret(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHttpProxySecret(String arg1) {
        return (A)withHttpProxySecret(new String(arg1));
    }

    public Boolean getKanikoBuildCache() {
        return this.kanikoBuildCache;
    }

    public A withKanikoBuildCache(Boolean kanikoBuildCache) {
        this.kanikoBuildCache=kanikoBuildCache; return (A) this;
    }

    public Boolean hasKanikoBuildCache() {
        return this.kanikoBuildCache != null;
    }

    public A withNewKanikoBuildCache(String arg1) {
        return (A)withKanikoBuildCache(new Boolean(arg1));
    }

    public A withNewKanikoBuildCache(boolean arg1) {
        return (A)withKanikoBuildCache(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMaven instead.
 * @return The buildable object.
 */
@Deprecated public MavenSpec getMaven() {
        return this.maven!=null?this.maven.build():null;
    }

    public MavenSpec buildMaven() {
        return this.maven!=null?this.maven.build():null;
    }

    public A withMaven(MavenSpec maven) {
        _visitables.get("maven").remove(this.maven);
        if (maven!=null){ this.maven= new MavenSpecBuilder(maven); _visitables.get("maven").add(this.maven);} return (A) this;
    }

    public Boolean hasMaven() {
        return this.maven != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> withNewMaven() {
        return new MavenNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> withNewMavenLike(MavenSpec item) {
        return new MavenNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> editMaven() {
        return withNewMavenLike(getMaven());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> editOrNewMaven() {
        return withNewMavenLike(getMaven() != null ? getMaven(): new MavenSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> editOrNewMavenLike(MavenSpec item) {
        return withNewMavenLike(getMaven() != null ? getMaven(): item);
    }

    public String getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public A withPersistentVolumeClaim(String persistentVolumeClaim) {
        this.persistentVolumeClaim=persistentVolumeClaim; return (A) this;
    }

    public Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public A withNewPersistentVolumeClaim(StringBuilder arg1) {
        return (A)withPersistentVolumeClaim(new String(arg1));
    }

    public A withNewPersistentVolumeClaim(int[] arg1,int arg2,int arg3) {
        return (A)withPersistentVolumeClaim(new String(arg1, arg2, arg3));
    }

    public A withNewPersistentVolumeClaim(char[] arg1) {
        return (A)withPersistentVolumeClaim(new String(arg1));
    }

    public A withNewPersistentVolumeClaim(StringBuffer arg1) {
        return (A)withPersistentVolumeClaim(new String(arg1));
    }

    public A withNewPersistentVolumeClaim(byte[] arg1,int arg2) {
        return (A)withPersistentVolumeClaim(new String(arg1, arg2));
    }

    public A withNewPersistentVolumeClaim(byte[] arg1) {
        return (A)withPersistentVolumeClaim(new String(arg1));
    }

    public A withNewPersistentVolumeClaim(char[] arg1,int arg2,int arg3) {
        return (A)withPersistentVolumeClaim(new String(arg1, arg2, arg3));
    }

    public A withNewPersistentVolumeClaim(byte[] arg1,int arg2,int arg3) {
        return (A)withPersistentVolumeClaim(new String(arg1, arg2, arg3));
    }

    public A withNewPersistentVolumeClaim(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPersistentVolumeClaim(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPersistentVolumeClaim(String arg1) {
        return (A)withPersistentVolumeClaim(new String(arg1));
    }

    public A addToProperties(String key,String value) {
        if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(java.util.Map<String,String> map) {
        if(this.properties == null && map != null) { this.properties = new LinkedHashMap<String,String>(); }
        if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(String key) {
        if(this.properties == null) { return (A) this; }
        if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(java.util.Map<String,String> map) {
        if(this.properties == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getProperties() {
        return this.properties;
    }

    public <K extends Object,V extends Object>A withProperties(java.util.Map<String,String> properties) {
        if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap<String,String>(properties);} return (A) this;
    }

    public Boolean hasProperties() {
        return this.properties != null;
    }

    public String getPublishStrategy() {
        return this.publishStrategy;
    }

    public A withPublishStrategy(String publishStrategy) {
        this.publishStrategy=publishStrategy; return (A) this;
    }

    public Boolean hasPublishStrategy() {
        return this.publishStrategy != null;
    }

    public A withNewPublishStrategy(StringBuilder arg1) {
        return (A)withPublishStrategy(new String(arg1));
    }

    public A withNewPublishStrategy(int[] arg1,int arg2,int arg3) {
        return (A)withPublishStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewPublishStrategy(char[] arg1) {
        return (A)withPublishStrategy(new String(arg1));
    }

    public A withNewPublishStrategy(StringBuffer arg1) {
        return (A)withPublishStrategy(new String(arg1));
    }

    public A withNewPublishStrategy(byte[] arg1,int arg2) {
        return (A)withPublishStrategy(new String(arg1, arg2));
    }

    public A withNewPublishStrategy(byte[] arg1) {
        return (A)withPublishStrategy(new String(arg1));
    }

    public A withNewPublishStrategy(char[] arg1,int arg2,int arg3) {
        return (A)withPublishStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewPublishStrategy(byte[] arg1,int arg2,int arg3) {
        return (A)withPublishStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewPublishStrategy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPublishStrategy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPublishStrategy(String arg1) {
        return (A)withPublishStrategy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRegistry instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformRegistrySpec getRegistry() {
        return this.registry!=null?this.registry.build():null;
    }

    public IntegrationPlatformRegistrySpec buildRegistry() {
        return this.registry!=null?this.registry.build():null;
    }

    public A withRegistry(IntegrationPlatformRegistrySpec registry) {
        _visitables.get("registry").remove(this.registry);
        if (registry!=null){ this.registry= new IntegrationPlatformRegistrySpecBuilder(registry); _visitables.get("registry").add(this.registry);} return (A) this;
    }

    public Boolean hasRegistry() {
        return this.registry != null;
    }

    public A withNewRegistry(String address,String ca,Boolean insecure,String organization,String secret) {
        return (A)withRegistry(new IntegrationPlatformRegistrySpec(address, ca, insecure, organization, secret));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> withNewRegistry() {
        return new RegistryNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> withNewRegistryLike(IntegrationPlatformRegistrySpec item) {
        return new RegistryNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> editRegistry() {
        return withNewRegistryLike(getRegistry());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> editOrNewRegistry() {
        return withNewRegistryLike(getRegistry() != null ? getRegistry(): new IntegrationPlatformRegistrySpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> editOrNewRegistryLike(IntegrationPlatformRegistrySpec item) {
        return withNewRegistryLike(getRegistry() != null ? getRegistry(): item);
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider=runtimeProvider; return (A) this;
    }

    public Boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public A withNewRuntimeProvider(StringBuilder arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(char[] arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(StringBuffer arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2) {
        return (A)withRuntimeProvider(new String(arg1, arg2));
    }

    public A withNewRuntimeProvider(byte[] arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeProvider(String arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion=runtimeVersion; return (A) this;
    }

    public Boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public A withNewRuntimeVersion(StringBuilder arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(char[] arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(StringBuffer arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2) {
        return (A)withRuntimeVersion(new String(arg1, arg2));
    }

    public A withNewRuntimeVersion(byte[] arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeVersion(String arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(Duration timeout) {
        this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationPlatformBuildSpecFluentImpl that = (IntegrationPlatformBuildSpecFluentImpl) o;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (buildStrategy != null ? !buildStrategy.equals(that.buildStrategy) :that.buildStrategy != null) return false;
        if (httpProxySecret != null ? !httpProxySecret.equals(that.httpProxySecret) :that.httpProxySecret != null) return false;
        if (kanikoBuildCache != null ? !kanikoBuildCache.equals(that.kanikoBuildCache) :that.kanikoBuildCache != null) return false;
        if (maven != null ? !maven.equals(that.maven) :that.maven != null) return false;
        if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
        if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
        if (publishStrategy != null ? !publishStrategy.equals(that.publishStrategy) :that.publishStrategy != null) return false;
        if (registry != null ? !registry.equals(that.registry) :that.registry != null) return false;
        if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
        if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
        if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(baseImage,  buildStrategy,  httpProxySecret,  kanikoBuildCache,  maven,  persistentVolumeClaim,  properties,  publishStrategy,  registry,  runtimeProvider,  runtimeVersion,  timeout,  super.hashCode());
    }

    public class MavenNestedImpl<N> extends MavenSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MavenSpecBuilder builder;

            MavenNestedImpl(MavenSpec item) {
                this.builder = new MavenSpecBuilder(this, item);
                        
            }

            MavenNestedImpl() {
                this.builder = new MavenSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformBuildSpecFluentImpl.this.withMaven(builder.build());
            }

            public N endMaven() {
                return and();
            }
    }


    public class RegistryNestedImpl<N> extends IntegrationPlatformRegistrySpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformRegistrySpecBuilder builder;

            RegistryNestedImpl(IntegrationPlatformRegistrySpec item) {
                this.builder = new IntegrationPlatformRegistrySpecBuilder(this, item);
                        
            }

            RegistryNestedImpl() {
                this.builder = new IntegrationPlatformRegistrySpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformBuildSpecFluentImpl.this.withRegistry(builder.build());
            }

            public N endRegistry() {
                return and();
            }
    }


}
