package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformKameletRepositorySpecBuilder extends IntegrationPlatformKameletRepositorySpecFluentImpl<IntegrationPlatformKameletRepositorySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationPlatformKameletRepositorySpec,IntegrationPlatformKameletRepositorySpecBuilder> {

    IntegrationPlatformKameletRepositorySpecFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformKameletRepositorySpecBuilder() {
        this(true);
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformKameletRepositorySpec(), validationEnabled);
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(IntegrationPlatformKameletRepositorySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(IntegrationPlatformKameletRepositorySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformKameletRepositorySpec(), validationEnabled);
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(IntegrationPlatformKameletRepositorySpecFluent<?> fluent,IntegrationPlatformKameletRepositorySpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(IntegrationPlatformKameletRepositorySpecFluent<?> fluent,IntegrationPlatformKameletRepositorySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(IntegrationPlatformKameletRepositorySpec instance) {
        this(instance,true);
    }

    public IntegrationPlatformKameletRepositorySpecBuilder(IntegrationPlatformKameletRepositorySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformKameletRepositorySpec build() {
        EditableIntegrationPlatformKameletRepositorySpec buildable = new EditableIntegrationPlatformKameletRepositorySpec(fluent.getUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformKameletRepositorySpecBuilder that = (IntegrationPlatformKameletRepositorySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
