package io.fabric8.camelk.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IntegrationPlatformRegistrySpecFluentImpl<A extends IntegrationPlatformRegistrySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationPlatformRegistrySpecFluent<A> {

    private String address;
    private String ca;
    private Boolean insecure;
    private String organization;
    private String secret;

    public IntegrationPlatformRegistrySpecFluentImpl() {
    }

    public IntegrationPlatformRegistrySpecFluentImpl(IntegrationPlatformRegistrySpec instance) {
        this.withAddress(instance.getAddress()); 
        this.withCa(instance.getCa()); 
        this.withInsecure(instance.getInsecure()); 
        this.withOrganization(instance.getOrganization()); 
        this.withSecret(instance.getSecret()); 
    }

    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address=address; return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(StringBuilder arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(int[] arg1,int arg2,int arg3) {
        return (A)withAddress(new String(arg1, arg2, arg3));
    }

    public A withNewAddress(char[] arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(byte[] arg1,int arg2) {
        return (A)withAddress(new String(arg1, arg2));
    }

    public A withNewAddress(byte[] arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(char[] arg1,int arg2,int arg3) {
        return (A)withAddress(new String(arg1, arg2, arg3));
    }

    public A withNewAddress(byte[] arg1,int arg2,int arg3) {
        return (A)withAddress(new String(arg1, arg2, arg3));
    }

    public A withNewAddress(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAddress(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAddress(String arg1) {
        return (A)withAddress(new String(arg1));
    }

    public String getCa() {
        return this.ca;
    }

    public A withCa(String ca) {
        this.ca=ca; return (A) this;
    }

    public Boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(StringBuilder arg1) {
        return (A)withCa(new String(arg1));
    }

    public A withNewCa(int[] arg1,int arg2,int arg3) {
        return (A)withCa(new String(arg1, arg2, arg3));
    }

    public A withNewCa(char[] arg1) {
        return (A)withCa(new String(arg1));
    }

    public A withNewCa(StringBuffer arg1) {
        return (A)withCa(new String(arg1));
    }

    public A withNewCa(byte[] arg1,int arg2) {
        return (A)withCa(new String(arg1, arg2));
    }

    public A withNewCa(byte[] arg1) {
        return (A)withCa(new String(arg1));
    }

    public A withNewCa(char[] arg1,int arg2,int arg3) {
        return (A)withCa(new String(arg1, arg2, arg3));
    }

    public A withNewCa(byte[] arg1,int arg2,int arg3) {
        return (A)withCa(new String(arg1, arg2, arg3));
    }

    public A withNewCa(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCa(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCa(String arg1) {
        return (A)withCa(new String(arg1));
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public A withInsecure(Boolean insecure) {
        this.insecure=insecure; return (A) this;
    }

    public Boolean hasInsecure() {
        return this.insecure != null;
    }

    public A withNewInsecure(String arg1) {
        return (A)withInsecure(new Boolean(arg1));
    }

    public A withNewInsecure(boolean arg1) {
        return (A)withInsecure(new Boolean(arg1));
    }

    public String getOrganization() {
        return this.organization;
    }

    public A withOrganization(String organization) {
        this.organization=organization; return (A) this;
    }

    public Boolean hasOrganization() {
        return this.organization != null;
    }

    public A withNewOrganization(StringBuilder arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(int[] arg1,int arg2,int arg3) {
        return (A)withOrganization(new String(arg1, arg2, arg3));
    }

    public A withNewOrganization(char[] arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(StringBuffer arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(byte[] arg1,int arg2) {
        return (A)withOrganization(new String(arg1, arg2));
    }

    public A withNewOrganization(byte[] arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(char[] arg1,int arg2,int arg3) {
        return (A)withOrganization(new String(arg1, arg2, arg3));
    }

    public A withNewOrganization(byte[] arg1,int arg2,int arg3) {
        return (A)withOrganization(new String(arg1, arg2, arg3));
    }

    public A withNewOrganization(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOrganization(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOrganization(String arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public String getSecret() {
        return this.secret;
    }

    public A withSecret(String secret) {
        this.secret=secret; return (A) this;
    }

    public Boolean hasSecret() {
        return this.secret != null;
    }

    public A withNewSecret(StringBuilder arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(int[] arg1,int arg2,int arg3) {
        return (A)withSecret(new String(arg1, arg2, arg3));
    }

    public A withNewSecret(char[] arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(StringBuffer arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(byte[] arg1,int arg2) {
        return (A)withSecret(new String(arg1, arg2));
    }

    public A withNewSecret(byte[] arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(char[] arg1,int arg2,int arg3) {
        return (A)withSecret(new String(arg1, arg2, arg3));
    }

    public A withNewSecret(byte[] arg1,int arg2,int arg3) {
        return (A)withSecret(new String(arg1, arg2, arg3));
    }

    public A withNewSecret(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSecret(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSecret(String arg1) {
        return (A)withSecret(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationPlatformRegistrySpecFluentImpl that = (IntegrationPlatformRegistrySpecFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (insecure != null ? !insecure.equals(that.insecure) :that.insecure != null) return false;
        if (organization != null ? !organization.equals(that.organization) :that.organization != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  ca,  insecure,  organization,  secret,  super.hashCode());
    }

}
