package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface IntegrationSpecFluent<A extends IntegrationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConfiguration(int index,ConfigurationSpec item);
    public A setToConfiguration(int index,ConfigurationSpec item);
    public A addToConfiguration(ConfigurationSpec... items);
    public A addAllToConfiguration(Collection<ConfigurationSpec> items);
    public A removeFromConfiguration(ConfigurationSpec... items);
    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items);
    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration();
    public List<ConfigurationSpec> buildConfiguration();
    public ConfigurationSpec buildConfiguration(int index);
    public ConfigurationSpec buildFirstConfiguration();
    public ConfigurationSpec buildLastConfiguration();
    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public A withConfiguration(List<ConfigurationSpec> configuration);
    public A withConfiguration(ConfigurationSpec... configuration);
    public Boolean hasConfiguration();
    public A addNewConfiguration(String type,String value);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> addNewConfiguration();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editConfiguration(int index);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editFirstConfiguration();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editLastConfiguration();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public A addToDependencies(int index,String item);
    public A setToDependencies(int index,String item);
    public A addToDependencies(String... items);
    public A addAllToDependencies(Collection<String> items);
    public A removeFromDependencies(String... items);
    public A removeAllFromDependencies(Collection<String> items);
    public List<String> getDependencies();
    public String getDependency(int index);
    public String getFirstDependency();
    public String getLastDependency();
    public String getMatchingDependency(Predicate<String> predicate);
    public Boolean hasMatchingDependency(Predicate<String> predicate);
    public A withDependencies(List<String> dependencies);
    public A withDependencies(String... dependencies);
    public Boolean hasDependencies();
    public A addNewDependency(StringBuilder arg1);
    public A addNewDependency(int[] arg1,int arg2,int arg3);
    public A addNewDependency(char[] arg1);
    public A addNewDependency(StringBuffer arg1);
    public A addNewDependency(byte[] arg1,int arg2);
    public A addNewDependency(byte[] arg1);
    public A addNewDependency(char[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewDependency(String arg1);
    public A addToFlows(int index,JsonNode item);
    public A setToFlows(int index,JsonNode item);
    public A addToFlows(JsonNode... items);
    public A addAllToFlows(Collection<JsonNode> items);
    public A removeFromFlows(JsonNode... items);
    public A removeAllFromFlows(Collection<JsonNode> items);
    public List<JsonNode> getFlows();
    public JsonNode getFlow(int index);
    public JsonNode getFirstFlow();
    public JsonNode getLastFlow();
    public JsonNode getMatchingFlow(Predicate<JsonNode> predicate);
    public Boolean hasMatchingFlow(Predicate<JsonNode> predicate);
    public A withFlows(List<JsonNode> flows);
    public A withFlows(JsonNode... flows);
    public Boolean hasFlows();
    public String getKit();
    public A withKit(String kit);
    public Boolean hasKit();
    public A withNewKit(StringBuilder arg1);
    public A withNewKit(int[] arg1,int arg2,int arg3);
    public A withNewKit(char[] arg1);
    public A withNewKit(StringBuffer arg1);
    public A withNewKit(byte[] arg1,int arg2);
    public A withNewKit(byte[] arg1);
    public A withNewKit(char[] arg1,int arg2,int arg3);
    public A withNewKit(byte[] arg1,int arg2,int arg3);
    public A withNewKit(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKit(String arg1);
    public String getProfile();
    public A withProfile(String profile);
    public Boolean hasProfile();
    public A withNewProfile(StringBuilder arg1);
    public A withNewProfile(int[] arg1,int arg2,int arg3);
    public A withNewProfile(char[] arg1);
    public A withNewProfile(StringBuffer arg1);
    public A withNewProfile(byte[] arg1,int arg2);
    public A withNewProfile(byte[] arg1);
    public A withNewProfile(char[] arg1,int arg2,int arg3);
    public A withNewProfile(byte[] arg1,int arg2,int arg3);
    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewProfile(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public A addToRepositories(int index,String item);
    public A setToRepositories(int index,String item);
    public A addToRepositories(String... items);
    public A addAllToRepositories(Collection<String> items);
    public A removeFromRepositories(String... items);
    public A removeAllFromRepositories(Collection<String> items);
    public List<String> getRepositories();
    public String getRepository(int index);
    public String getFirstRepository();
    public String getLastRepository();
    public String getMatchingRepository(Predicate<String> predicate);
    public Boolean hasMatchingRepository(Predicate<String> predicate);
    public A withRepositories(List<String> repositories);
    public A withRepositories(String... repositories);
    public Boolean hasRepositories();
    public A addNewRepository(StringBuilder arg1);
    public A addNewRepository(int[] arg1,int arg2,int arg3);
    public A addNewRepository(char[] arg1);
    public A addNewRepository(StringBuffer arg1);
    public A addNewRepository(byte[] arg1,int arg2);
    public A addNewRepository(byte[] arg1);
    public A addNewRepository(char[] arg1,int arg2,int arg3);
    public A addNewRepository(byte[] arg1,int arg2,int arg3);
    public A addNewRepository(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewRepository(String arg1);
    public A addToResources(int index,ResourceSpec item);
    public A setToResources(int index,ResourceSpec item);
    public A addToResources(ResourceSpec... items);
    public A addAllToResources(Collection<ResourceSpec> items);
    public A removeFromResources(ResourceSpec... items);
    public A removeAllFromResources(Collection<ResourceSpec> items);
    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceSpec> getResources();
    public List<ResourceSpec> buildResources();
    public ResourceSpec buildResource(int index);
    public ResourceSpec buildFirstResource();
    public ResourceSpec buildLastResource();
    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate);
    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate);
    public A withResources(List<ResourceSpec> resources);
    public A withResources(ResourceSpec... resources);
    public Boolean hasResources();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> addNewResource();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> setNewResourceLike(int index,ResourceSpec item);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editResource(int index);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editFirstResource();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editLastResource();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(char[] arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public A withNewServiceAccountName(byte[] arg1,int arg2);
    public A withNewServiceAccountName(byte[] arg1);
    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccountName(String arg1);
    public A addToSources(int index,SourceSpec item);
    public A setToSources(int index,SourceSpec item);
    public A addToSources(SourceSpec... items);
    public A addAllToSources(Collection<SourceSpec> items);
    public A removeFromSources(SourceSpec... items);
    public A removeAllFromSources(Collection<SourceSpec> items);
    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<SourceSpec> getSources();
    public List<SourceSpec> buildSources();
    public SourceSpec buildSource(int index);
    public SourceSpec buildFirstSource();
    public SourceSpec buildLastSource();
    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate);
    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate);
    public A withSources(List<SourceSpec> sources);
    public A withSources(SourceSpec... sources);
    public Boolean hasSources();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> addNewSource();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> addNewSourceLike(SourceSpec item);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> setNewSourceLike(int index,SourceSpec item);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editSource(int index);
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editFirstSource();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editLastSource();
    public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate);
    public A addToTraits(String key,TraitSpec value);
    public A addToTraits(java.util.Map<String,TraitSpec> map);
    public A removeFromTraits(String key);
    public A removeFromTraits(java.util.Map<String,TraitSpec> map);
    public java.util.Map<String,TraitSpec> getTraits();
    public <K extends Object,V extends Object>A withTraits(java.util.Map<String,TraitSpec> traits);
    public Boolean hasTraits();
    public interface ConfigurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigurationSpecFluent<io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<N>> {

            public N and();
            public N endConfiguration();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceSpecFluent<io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<N>> {

            public N and();
            public N endResource();    }


    public interface SourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceSpecFluent<io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<N>> {

            public N and();
            public N endSource();    }


}
