package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MavenSpecBuilder extends MavenSpecFluentImpl<MavenSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<MavenSpec,MavenSpecBuilder> {

    MavenSpecFluent<?> fluent;
    Boolean validationEnabled;

    public MavenSpecBuilder() {
        this(true);
    }

    public MavenSpecBuilder(Boolean validationEnabled) {
        this(new MavenSpec(), validationEnabled);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MavenSpec(), validationEnabled);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent,MavenSpec instance) {
        this(fluent, instance, true);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent,MavenSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLocalRepository(instance.getLocalRepository()); 
        fluent.withSettings(instance.getSettings()); 
        fluent.withTimeout(instance.getTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public MavenSpecBuilder(MavenSpec instance) {
        this(instance,true);
    }

    public MavenSpecBuilder(MavenSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLocalRepository(instance.getLocalRepository()); 
        this.withSettings(instance.getSettings()); 
        this.withTimeout(instance.getTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableMavenSpec build() {
        EditableMavenSpec buildable = new EditableMavenSpec(fluent.getLocalRepository(),fluent.getSettings(),fluent.getTimeout());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MavenSpecBuilder that = (MavenSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
