package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Boolean;

public class TraitSpecFluentImpl<A extends TraitSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TraitSpecFluent<A> {

    private JsonNode configuration;

    public TraitSpecFluentImpl() {
    }

    public TraitSpecFluentImpl(TraitSpec instance) {
        this.withConfiguration(instance.getConfiguration()); 
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public A withConfiguration(JsonNode configuration) {
        this.configuration=configuration; return (A) this;
    }

    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TraitSpecFluentImpl that = (TraitSpecFluentImpl) o;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(configuration,  super.hashCode());
    }

}
