package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ValueSourceBuilder extends ValueSourceFluentImpl<ValueSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ValueSource,ValueSourceBuilder> {

    ValueSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ValueSourceBuilder() {
        this(true);
    }

    public ValueSourceBuilder(Boolean validationEnabled) {
        this(new ValueSource(), validationEnabled);
    }

    public ValueSourceBuilder(ValueSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ValueSourceBuilder(ValueSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ValueSource(), validationEnabled);
    }

    public ValueSourceBuilder(ValueSourceFluent<?> fluent,ValueSource instance) {
        this(fluent, instance, true);
    }

    public ValueSourceBuilder(ValueSourceFluent<?> fluent,ValueSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
        fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public ValueSourceBuilder(ValueSource instance) {
        this(instance,true);
    }

    public ValueSourceBuilder(ValueSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
        this.withSecretKeyRef(instance.getSecretKeyRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableValueSource build() {
        EditableValueSource buildable = new EditableValueSource(fluent.getConfigMapKeyRef(),fluent.getSecretKeyRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ValueSourceBuilder that = (ValueSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
