/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.BuildSpec;
import io.fabric8.camelk.v1.BuildSpecFluent;
import io.fabric8.camelk.v1.Task;
import io.fabric8.camelk.v1.TaskBuilder;
import io.fabric8.camelk.v1.TaskFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildSpecFluentImpl<A extends BuildSpecFluent<A>>
extends BaseFluent<A>
implements BuildSpecFluent<A> {
    private String strategy;
    private List<TaskBuilder> tasks;
    private Duration timeout;

    public BuildSpecFluentImpl() {
    }

    public BuildSpecFluentImpl(BuildSpec instance) {
        this.withStrategy(instance.getStrategy());
        this.withTasks(instance.getTasks());
        this.withTimeout(instance.getTimeout());
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    @Deprecated
    public A withNewStrategy(String arg0) {
        return this.withStrategy(new String(arg0));
    }

    @Override
    public A addToTasks(Integer index, Task item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<TaskBuilder>();
        }
        TaskBuilder builder = new TaskBuilder(item);
        this._visitables.get((Object)"tasks").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"tasks").size(), builder);
        this.tasks.add(index >= 0 ? index.intValue() : this.tasks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTasks(Integer index, Task item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<TaskBuilder>();
        }
        TaskBuilder builder = new TaskBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"tasks").size()) {
            this._visitables.get((Object)"tasks").add(builder);
        } else {
            this._visitables.get((Object)"tasks").set(index, builder);
        }
        if (index < 0 || index >= this.tasks.size()) {
            this.tasks.add(builder);
        } else {
            this.tasks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTasks(Task ... items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<TaskBuilder>();
        }
        for (Task item : items) {
            TaskBuilder builder = new TaskBuilder(item);
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTasks(Collection<Task> items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<TaskBuilder>();
        }
        for (Task item : items) {
            TaskBuilder builder = new TaskBuilder(item);
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTasks(Task ... items) {
        for (Task item : items) {
            TaskBuilder builder = new TaskBuilder(item);
            this._visitables.get((Object)"tasks").remove(builder);
            if (this.tasks == null) continue;
            this.tasks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTasks(Collection<Task> items) {
        for (Task item : items) {
            TaskBuilder builder = new TaskBuilder(item);
            this._visitables.get((Object)"tasks").remove(builder);
            if (this.tasks == null) continue;
            this.tasks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTasks(Predicate<TaskBuilder> predicate) {
        if (this.tasks == null) {
            return (A)this;
        }
        Iterator<TaskBuilder> each = this.tasks.iterator();
        List visitables = this._visitables.get((Object)"tasks");
        while (each.hasNext()) {
            TaskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Task> getTasks() {
        return BuildSpecFluentImpl.build(this.tasks);
    }

    @Override
    public List<Task> buildTasks() {
        return BuildSpecFluentImpl.build(this.tasks);
    }

    @Override
    public Task buildTask(Integer index) {
        return this.tasks.get(index).build();
    }

    @Override
    public Task buildFirstTask() {
        return this.tasks.get(0).build();
    }

    @Override
    public Task buildLastTask() {
        return this.tasks.get(this.tasks.size() - 1).build();
    }

    @Override
    public Task buildMatchingTask(Predicate<TaskBuilder> predicate) {
        for (TaskBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTask(Predicate<TaskBuilder> predicate) {
        for (TaskBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTasks(List<Task> tasks) {
        if (this.tasks != null) {
            this._visitables.get((Object)"tasks").removeAll(this.tasks);
        }
        if (tasks != null) {
            this.tasks = new ArrayList<TaskBuilder>();
            for (Task item : tasks) {
                this.addToTasks(item);
            }
        } else {
            this.tasks = null;
        }
        return (A)this;
    }

    @Override
    public A withTasks(Task ... tasks) {
        if (this.tasks != null) {
            this.tasks.clear();
        }
        if (tasks != null) {
            for (Task item : tasks) {
                this.addToTasks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTasks() {
        return this.tasks != null && !this.tasks.isEmpty();
    }

    @Override
    public BuildSpecFluent.TasksNested<A> addNewTask() {
        return new TasksNestedImpl();
    }

    @Override
    public BuildSpecFluent.TasksNested<A> addNewTaskLike(Task item) {
        return new TasksNestedImpl(-1, item);
    }

    @Override
    public BuildSpecFluent.TasksNested<A> setNewTaskLike(Integer index, Task item) {
        return new TasksNestedImpl(index, item);
    }

    @Override
    public BuildSpecFluent.TasksNested<A> editTask(Integer index) {
        if (this.tasks.size() <= index) {
            throw new RuntimeException("Can't edit tasks. Index exceeds size.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    @Override
    public BuildSpecFluent.TasksNested<A> editFirstTask() {
        if (this.tasks.size() == 0) {
            throw new RuntimeException("Can't edit first tasks. The list is empty.");
        }
        return this.setNewTaskLike(0, this.buildTask(0));
    }

    @Override
    public BuildSpecFluent.TasksNested<A> editLastTask() {
        int index = this.tasks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tasks. The list is empty.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    @Override
    public BuildSpecFluent.TasksNested<A> editMatchingTask(Predicate<TaskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (!predicate.test(this.tasks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tasks. No match found.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)this;
    }

    @Override
    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSpecFluentImpl that = (BuildSpecFluentImpl)o;
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.tasks != null ? !this.tasks.equals(that.tasks) : that.tasks != null) {
            return false;
        }
        return !(this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null);
    }

    public int hashCode() {
        return Objects.hash(this.strategy, this.tasks, this.timeout, super.hashCode());
    }

    public class TasksNestedImpl<N>
    extends TaskFluentImpl<BuildSpecFluent.TasksNested<N>>
    implements BuildSpecFluent.TasksNested<N>,
    Nested<N> {
        TaskBuilder builder;
        Integer index;

        TasksNestedImpl(Integer index, Task item) {
            this.index = index;
            this.builder = new TaskBuilder(this, item);
        }

        TasksNestedImpl() {
            this.index = -1;
            this.builder = new TaskBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.setToTasks(this.index, this.builder.build());
        }

        @Override
        public N endTask() {
            return this.and();
        }
    }
}

