/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.BuilderTask;
import io.fabric8.camelk.v1.BuilderTaskFluent;
import io.fabric8.camelk.v1.MavenSpec;
import io.fabric8.camelk.v1.MavenSpecBuilder;
import io.fabric8.camelk.v1.MavenSpecFluentImpl;
import io.fabric8.camelk.v1.ResourceSpec;
import io.fabric8.camelk.v1.ResourceSpecBuilder;
import io.fabric8.camelk.v1.ResourceSpecFluentImpl;
import io.fabric8.camelk.v1.RuntimeSpec;
import io.fabric8.camelk.v1.RuntimeSpecBuilder;
import io.fabric8.camelk.v1.RuntimeSpecFluentImpl;
import io.fabric8.camelk.v1.SourceSpec;
import io.fabric8.camelk.v1.SourceSpecBuilder;
import io.fabric8.camelk.v1.SourceSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuilderTaskFluentImpl<A extends BuilderTaskFluent<A>>
extends BaseFluent<A>
implements BuilderTaskFluent<A> {
    private Affinity affinity;
    private String baseImage;
    private String buildDir;
    private List<String> dependencies;
    private String image;
    private MavenSpecBuilder maven;
    private ObjectMetaBuilder meta;
    private String name;
    private Map<String, String> properties;
    private List<ResourceSpecBuilder> resources;
    private RuntimeSpecBuilder runtime;
    private List<SourceSpecBuilder> sources;
    private List<String> steps;
    private Duration timeout;
    private List<VolumeMountBuilder> volumeMounts;
    private List<VolumeBuilder> volumes;

    public BuilderTaskFluentImpl() {
    }

    public BuilderTaskFluentImpl(BuilderTask instance) {
        this.withAffinity(instance.getAffinity());
        this.withBaseImage(instance.getBaseImage());
        this.withBuildDir(instance.getBuildDir());
        this.withDependencies(instance.getDependencies());
        this.withImage(instance.getImage());
        this.withMaven(instance.getMaven());
        this.withMeta(instance.getMeta());
        this.withName(instance.getName());
        this.withProperties(instance.getProperties());
        this.withResources(instance.getResources());
        this.withRuntime(instance.getRuntime());
        this.withSources(instance.getSources());
        this.withSteps(instance.getSteps());
        this.withTimeout(instance.getTimeout());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    @Deprecated
    public A withNewBaseImage(String arg0) {
        return this.withBaseImage(new String(arg0));
    }

    @Override
    public String getBuildDir() {
        return this.buildDir;
    }

    @Override
    public A withBuildDir(String buildDir) {
        this.buildDir = buildDir;
        return (A)this;
    }

    @Override
    public Boolean hasBuildDir() {
        return this.buildDir != null;
    }

    @Override
    @Deprecated
    public A withNewBuildDir(String arg0) {
        return this.withBuildDir(new String(arg0));
    }

    @Override
    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(String ... items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    @Override
    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    @Override
    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    @Override
    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<String> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").removeAll(this.dependencies);
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public A addNewDependency(String arg0) {
        return this.addToDependencies(new String(arg0));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String arg0) {
        return this.withImage(new String(arg0));
    }

    @Override
    @Deprecated
    public MavenSpec getMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    @Override
    public MavenSpec buildMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    @Override
    public A withMaven(MavenSpec maven) {
        this._visitables.get((Object)"maven").remove(this.maven);
        if (maven != null) {
            this.maven = new MavenSpecBuilder(maven);
            this._visitables.get((Object)"maven").add(this.maven);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMaven() {
        return this.maven != null;
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> withNewMaven() {
        return new MavenNestedImpl();
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> withNewMavenLike(MavenSpec item) {
        return new MavenNestedImpl(item);
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> editMaven() {
        return this.withNewMavenLike(this.getMaven());
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> editOrNewMaven() {
        return this.withNewMavenLike(this.getMaven() != null ? this.getMaven() : new MavenSpecBuilder().build());
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(MavenSpec item) {
        return this.withNewMavenLike(this.getMaven() != null ? this.getMaven() : item);
    }

    @Override
    @Deprecated
    public ObjectMeta getMeta() {
        return this.meta != null ? this.meta.build() : null;
    }

    @Override
    public ObjectMeta buildMeta() {
        return this.meta != null ? this.meta.build() : null;
    }

    @Override
    public A withMeta(ObjectMeta meta) {
        this._visitables.get((Object)"meta").remove(this.meta);
        if (meta != null) {
            this.meta = new ObjectMetaBuilder(meta);
            this._visitables.get((Object)"meta").add(this.meta);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMeta() {
        return this.meta != null;
    }

    @Override
    public BuilderTaskFluent.MetaNested<A> withNewMeta() {
        return new MetaNestedImpl();
    }

    @Override
    public BuilderTaskFluent.MetaNested<A> withNewMetaLike(ObjectMeta item) {
        return new MetaNestedImpl(item);
    }

    @Override
    public BuilderTaskFluent.MetaNested<A> editMeta() {
        return this.withNewMetaLike(this.getMeta());
    }

    @Override
    public BuilderTaskFluent.MetaNested<A> editOrNewMeta() {
        return this.withNewMetaLike(this.getMeta() != null ? this.getMeta() : new ObjectMetaBuilder().build());
    }

    @Override
    public BuilderTaskFluent.MetaNested<A> editOrNewMetaLike(ObjectMeta item) {
        return this.withNewMetaLike(this.getMeta() != null ? this.getMeta() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public A addToProperties(String key, String value) {
        if (this.properties == null && key != null && value != null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.properties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToProperties(Map<String, String> map) {
        if (this.properties == null && map != null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.properties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperties(String key) {
        if (this.properties == null) {
            return (A)this;
        }
        if (key != null && this.properties != null) {
            this.properties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperties(Map<String, String> map) {
        if (this.properties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.properties == null) continue;
                this.properties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public <K, V> A withProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new LinkedHashMap<String, String>(properties);
        return (A)this;
    }

    @Override
    public Boolean hasProperties() {
        return this.properties != null;
    }

    @Override
    public A addToResources(int index, ResourceSpec item) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceSpecBuilder>();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        this._visitables.get((Object)"resources").add(index >= 0 ? index : this._visitables.get((Object)"resources").size(), builder);
        this.resources.add(index >= 0 ? index : this.resources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResources(int index, ResourceSpec item) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceSpecBuilder>();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"resources").size()) {
            this._visitables.get((Object)"resources").add(builder);
        } else {
            this._visitables.get((Object)"resources").set(index, builder);
        }
        if (index < 0 || index >= this.resources.size()) {
            this.resources.add(builder);
        } else {
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(ResourceSpec ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceSpecBuilder>();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<ResourceSpec> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceSpecBuilder>();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(ResourceSpec ... items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<ResourceSpecBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            ResourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceSpec> getResources() {
        return BuilderTaskFluentImpl.build(this.resources);
    }

    @Override
    public List<ResourceSpec> buildResources() {
        return BuilderTaskFluentImpl.build(this.resources);
    }

    @Override
    public ResourceSpec buildResource(int index) {
        return this.resources.get(index).build();
    }

    @Override
    public ResourceSpec buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public ResourceSpec buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<ResourceSpec> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList<ResourceSpecBuilder>();
            for (ResourceSpec item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(ResourceSpec ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (ResourceSpec item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(int index, ResourceSpec item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    @Deprecated
    public RuntimeSpec getRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    @Override
    public RuntimeSpec buildRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    @Override
    public A withRuntime(RuntimeSpec runtime) {
        this._visitables.get((Object)"runtime").remove(this.runtime);
        if (runtime != null) {
            this.runtime = new RuntimeSpecBuilder(runtime);
            this._visitables.get((Object)"runtime").add(this.runtime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> withNewRuntime() {
        return new RuntimeNestedImpl();
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
        return new RuntimeNestedImpl(item);
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> editRuntime() {
        return this.withNewRuntimeLike(this.getRuntime());
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime() {
        return this.withNewRuntimeLike(this.getRuntime() != null ? this.getRuntime() : new RuntimeSpecBuilder().build());
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
        return this.withNewRuntimeLike(this.getRuntime() != null ? this.getRuntime() : item);
    }

    @Override
    public A addToSources(int index, SourceSpec item) {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSpecBuilder>();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        this._visitables.get((Object)"sources").add(index >= 0 ? index : this._visitables.get((Object)"sources").size(), builder);
        this.sources.add(index >= 0 ? index : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(int index, SourceSpec item) {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSpecBuilder>();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"sources").size()) {
            this._visitables.get((Object)"sources").add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(SourceSpec ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSpecBuilder>();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<SourceSpec> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSpecBuilder>();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(SourceSpec ... items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<SourceSpecBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            SourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SourceSpec> getSources() {
        return BuilderTaskFluentImpl.build(this.sources);
    }

    @Override
    public List<SourceSpec> buildSources() {
        return BuilderTaskFluentImpl.build(this.sources);
    }

    @Override
    public SourceSpec buildSource(int index) {
        return this.sources.get(index).build();
    }

    @Override
    public SourceSpec buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public SourceSpec buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<SourceSpec> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList<SourceSpecBuilder>();
            for (SourceSpec item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(SourceSpec ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (SourceSpec item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> addNewSourceLike(SourceSpec item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> setNewSourceLike(int index, SourceSpec item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public A addToSteps(int index, String item) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        this.steps.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSteps(int index, String item) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        this.steps.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSteps(String ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        for (String item : items) {
            this.steps.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<String> items) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        for (String item : items) {
            this.steps.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(String ... items) {
        for (String item : items) {
            if (this.steps == null) continue;
            this.steps.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<String> items) {
        for (String item : items) {
            if (this.steps == null) continue;
            this.steps.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSteps() {
        return this.steps;
    }

    @Override
    public String getStep(int index) {
        return this.steps.get(index);
    }

    @Override
    public String getFirstStep() {
        return this.steps.get(0);
    }

    @Override
    public String getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    @Override
    public String getMatchingStep(Predicate<String> predicate) {
        for (String item : this.steps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<String> predicate) {
        for (String item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<String> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").removeAll(this.steps);
        }
        if (steps != null) {
            this.steps = new ArrayList<String>();
            for (String item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    @Override
    public A withSteps(String ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (String item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public A addNewStep(String arg0) {
        return this.addToSteps(new String(arg0));
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)this;
    }

    @Override
    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        this._visitables.get((Object)"volumeMounts").add(index >= 0 ? index : this._visitables.get((Object)"volumeMounts").size(), builder);
        this.volumeMounts.add(index >= 0 ? index : this.volumeMounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumeMounts").size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").set(index, builder);
        }
        if (index < 0 || index >= this.volumeMounts.size()) {
            this.volumeMounts.add(builder);
        } else {
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        Iterator<VolumeMountBuilder> each = this.volumeMounts.iterator();
        List visitables = this._visitables.get((Object)"volumeMounts");
        while (each.hasNext()) {
            VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeMount> getVolumeMounts() {
        return BuilderTaskFluentImpl.build(this.volumeMounts);
    }

    @Override
    public List<VolumeMount> buildVolumeMounts() {
        return BuilderTaskFluentImpl.build(this.volumeMounts);
    }

    @Override
    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    @Override
    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    @Override
    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    @Override
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get((Object)"volumeMounts").removeAll(this.volumeMounts);
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public BuilderTaskFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return BuilderTaskFluentImpl.build(this.volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return BuilderTaskFluentImpl.build(this.volumes);
    }

    @Override
    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<VolumeBuilder>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public BuilderTaskFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuilderTaskFluentImpl that = (BuilderTaskFluentImpl)o;
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.baseImage != null ? !this.baseImage.equals(that.baseImage) : that.baseImage != null) {
            return false;
        }
        if (this.buildDir != null ? !this.buildDir.equals(that.buildDir) : that.buildDir != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.maven != null ? !this.maven.equals(that.maven) : that.maven != null) {
            return false;
        }
        if (this.meta != null ? !this.meta.equals((Object)that.meta) : that.meta != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) {
            return false;
        }
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.affinity, this.baseImage, this.buildDir, this.dependencies, this.image, this.maven, this.meta, this.name, this.properties, this.resources, this.runtime, this.sources, this.steps, this.timeout, this.volumeMounts, this.volumes, super.hashCode());
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<BuilderTaskFluent.VolumesNested<N>>
    implements BuilderTaskFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder((VolumeFluent)this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class VolumeMountsNestedImpl<N>
    extends VolumeMountFluentImpl<BuilderTaskFluent.VolumeMountsNested<N>>
    implements BuilderTaskFluent.VolumeMountsNested<N>,
    Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

        VolumeMountsNestedImpl(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder((VolumeMountFluent)this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new VolumeMountBuilder((VolumeMountFluent)this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.setToVolumeMounts(this.index, this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    public class SourcesNestedImpl<N>
    extends SourceSpecFluentImpl<BuilderTaskFluent.SourcesNested<N>>
    implements BuilderTaskFluent.SourcesNested<N>,
    Nested<N> {
        private final SourceSpecBuilder builder;
        private final int index;

        SourcesNestedImpl(int index, SourceSpec item) {
            this.index = index;
            this.builder = new SourceSpecBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new SourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RuntimeNestedImpl<N>
    extends RuntimeSpecFluentImpl<BuilderTaskFluent.RuntimeNested<N>>
    implements BuilderTaskFluent.RuntimeNested<N>,
    Nested<N> {
        private final RuntimeSpecBuilder builder;

        RuntimeNestedImpl(RuntimeSpec item) {
            this.builder = new RuntimeSpecBuilder(this, item);
        }

        RuntimeNestedImpl() {
            this.builder = new RuntimeSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.withRuntime(this.builder.build());
        }

        @Override
        public N endRuntime() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceSpecFluentImpl<BuilderTaskFluent.ResourcesNested<N>>
    implements BuilderTaskFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceSpecBuilder builder;
        private final int index;

        ResourcesNestedImpl(int index, ResourceSpec item) {
            this.index = index;
            this.builder = new ResourceSpecBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new ResourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }

    public class MetaNestedImpl<N>
    extends ObjectMetaFluentImpl<BuilderTaskFluent.MetaNested<N>>
    implements BuilderTaskFluent.MetaNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetaNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetaNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.withMeta(this.builder.build());
        }

        @Override
        public N endMeta() {
            return this.and();
        }
    }

    public class MavenNestedImpl<N>
    extends MavenSpecFluentImpl<BuilderTaskFluent.MavenNested<N>>
    implements BuilderTaskFluent.MavenNested<N>,
    Nested<N> {
        private final MavenSpecBuilder builder;

        MavenNestedImpl(MavenSpec item) {
            this.builder = new MavenSpecBuilder(this, item);
        }

        MavenNestedImpl() {
            this.builder = new MavenSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.withMaven(this.builder.build());
        }

        @Override
        public N endMaven() {
            return this.and();
        }
    }
}

