/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.CamelArtifactDependency;
import io.fabric8.camelk.v1.CamelArtifactDependencyFluent;
import io.fabric8.camelk.v1.CamelArtifactExclusion;
import io.fabric8.camelk.v1.CamelArtifactExclusionBuilder;
import io.fabric8.camelk.v1.CamelArtifactExclusionFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CamelArtifactDependencyFluentImpl<A extends CamelArtifactDependencyFluent<A>>
extends BaseFluent<A>
implements CamelArtifactDependencyFluent<A> {
    private String artifactId;
    private List<CamelArtifactExclusionBuilder> exclusions;
    private String groupId;
    private String version;

    public CamelArtifactDependencyFluentImpl() {
    }

    public CamelArtifactDependencyFluentImpl(CamelArtifactDependency instance) {
        this.withArtifactId(instance.getArtifactId());
        this.withExclusions(instance.getExclusions());
        this.withGroupId(instance.getGroupId());
        this.withVersion(instance.getVersion());
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public A withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (A)this;
    }

    @Override
    public Boolean hasArtifactId() {
        return this.artifactId != null;
    }

    @Override
    @Deprecated
    public A withNewArtifactId(String arg0) {
        return this.withArtifactId(new String(arg0));
    }

    @Override
    public A addToExclusions(int index, CamelArtifactExclusion item) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
        }
        CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
        this._visitables.get((Object)"exclusions").add(index >= 0 ? index : this._visitables.get((Object)"exclusions").size(), builder);
        this.exclusions.add(index >= 0 ? index : this.exclusions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExclusions(int index, CamelArtifactExclusion item) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
        }
        CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"exclusions").size()) {
            this._visitables.get((Object)"exclusions").add(builder);
        } else {
            this._visitables.get((Object)"exclusions").set(index, builder);
        }
        if (index < 0 || index >= this.exclusions.size()) {
            this.exclusions.add(builder);
        } else {
            this.exclusions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExclusions(CamelArtifactExclusion ... items) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
        }
        for (CamelArtifactExclusion item : items) {
            CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExclusions(Collection<CamelArtifactExclusion> items) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
        }
        for (CamelArtifactExclusion item : items) {
            CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExclusions(CamelArtifactExclusion ... items) {
        for (CamelArtifactExclusion item : items) {
            CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
            this._visitables.get((Object)"exclusions").remove(builder);
            if (this.exclusions == null) continue;
            this.exclusions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items) {
        for (CamelArtifactExclusion item : items) {
            CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
            this._visitables.get((Object)"exclusions").remove(builder);
            if (this.exclusions == null) continue;
            this.exclusions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate) {
        if (this.exclusions == null) {
            return (A)this;
        }
        Iterator<CamelArtifactExclusionBuilder> each = this.exclusions.iterator();
        List visitables = this._visitables.get((Object)"exclusions");
        while (each.hasNext()) {
            CamelArtifactExclusionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CamelArtifactExclusion> getExclusions() {
        return CamelArtifactDependencyFluentImpl.build(this.exclusions);
    }

    @Override
    public List<CamelArtifactExclusion> buildExclusions() {
        return CamelArtifactDependencyFluentImpl.build(this.exclusions);
    }

    @Override
    public CamelArtifactExclusion buildExclusion(int index) {
        return this.exclusions.get(index).build();
    }

    @Override
    public CamelArtifactExclusion buildFirstExclusion() {
        return this.exclusions.get(0).build();
    }

    @Override
    public CamelArtifactExclusion buildLastExclusion() {
        return this.exclusions.get(this.exclusions.size() - 1).build();
    }

    @Override
    public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
        for (CamelArtifactExclusionBuilder item : this.exclusions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
        for (CamelArtifactExclusionBuilder item : this.exclusions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExclusions(List<CamelArtifactExclusion> exclusions) {
        if (this.exclusions != null) {
            this._visitables.get((Object)"exclusions").removeAll(this.exclusions);
        }
        if (exclusions != null) {
            this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
            for (CamelArtifactExclusion item : exclusions) {
                this.addToExclusions(item);
            }
        } else {
            this.exclusions = null;
        }
        return (A)this;
    }

    @Override
    public A withExclusions(CamelArtifactExclusion ... exclusions) {
        if (this.exclusions != null) {
            this.exclusions.clear();
        }
        if (exclusions != null) {
            for (CamelArtifactExclusion item : exclusions) {
                this.addToExclusions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExclusions() {
        return this.exclusions != null && !this.exclusions.isEmpty();
    }

    @Override
    public A addNewExclusion(String artifactId, String groupId) {
        return this.addToExclusions(new CamelArtifactExclusion(artifactId, groupId));
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusion() {
        return new ExclusionsNestedImpl();
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item) {
        return new ExclusionsNestedImpl(-1, item);
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> setNewExclusionLike(int index, CamelArtifactExclusion item) {
        return new ExclusionsNestedImpl(index, item);
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editExclusion(int index) {
        if (this.exclusions.size() <= index) {
            throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editFirstExclusion() {
        if (this.exclusions.size() == 0) {
            throw new RuntimeException("Can't edit first exclusions. The list is empty.");
        }
        return this.setNewExclusionLike(0, this.buildExclusion(0));
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editLastExclusion() {
        int index = this.exclusions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last exclusions. The list is empty.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    @Override
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!predicate.test(this.exclusions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching exclusions. No match found.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public A withGroupId(String groupId) {
        this.groupId = groupId;
        return (A)this;
    }

    @Override
    public Boolean hasGroupId() {
        return this.groupId != null;
    }

    @Override
    @Deprecated
    public A withNewGroupId(String arg0) {
        return this.withGroupId(new String(arg0));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamelArtifactDependencyFluentImpl that = (CamelArtifactDependencyFluentImpl)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.exclusions, this.groupId, this.version, super.hashCode());
    }

    public class ExclusionsNestedImpl<N>
    extends CamelArtifactExclusionFluentImpl<CamelArtifactDependencyFluent.ExclusionsNested<N>>
    implements CamelArtifactDependencyFluent.ExclusionsNested<N>,
    Nested<N> {
        private final CamelArtifactExclusionBuilder builder;
        private final int index;

        ExclusionsNestedImpl(int index, CamelArtifactExclusion item) {
            this.index = index;
            this.builder = new CamelArtifactExclusionBuilder(this, item);
        }

        ExclusionsNestedImpl() {
            this.index = -1;
            this.builder = new CamelArtifactExclusionBuilder(this);
        }

        @Override
        public N and() {
            return (N)CamelArtifactDependencyFluentImpl.this.setToExclusions(this.index, this.builder.build());
        }

        @Override
        public N endExclusion() {
            return this.and();
        }
    }
}

