package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletBuilder extends KameletFluentImpl<KameletBuilder> implements VisitableBuilder<Kamelet,KameletBuilder>{
  public KameletBuilder() {
    this(false);
  }
  public KameletBuilder(Boolean validationEnabled) {
    this(new Kamelet(), validationEnabled);
  }
  public KameletBuilder(KameletFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletBuilder(KameletFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Kamelet(), validationEnabled);
  }
  public KameletBuilder(KameletFluent<?> fluent,Kamelet instance) {
    this(fluent, instance, false);
  }
  public KameletBuilder(KameletFluent<?> fluent,Kamelet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public KameletBuilder(Kamelet instance) {
    this(instance,false);
  }
  public KameletBuilder(Kamelet instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  KameletFluent<?> fluent;
  Boolean validationEnabled;
  public Kamelet build() {
    Kamelet buildable = new Kamelet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}