/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.Server;
import io.fabric8.camelk.v1.ServerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ServerFluentImpl<A extends ServerFluent<A>>
extends BaseFluent<A>
implements ServerFluent<A> {
    private Map<String, String> configuration;
    private String id;
    private String password;
    private String username;

    public ServerFluentImpl() {
    }

    public ServerFluentImpl(Server instance) {
        this.withConfiguration(instance.getConfiguration());
        this.withId(instance.getId());
        this.withPassword(instance.getPassword());
        this.withUsername(instance.getUsername());
    }

    @Override
    public A addToConfiguration(String key, String value) {
        if (this.configuration == null && key != null && value != null) {
            this.configuration = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.configuration.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfiguration(Map<String, String> map) {
        if (this.configuration == null && map != null) {
            this.configuration = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.configuration.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfiguration(String key) {
        if (this.configuration == null) {
            return (A)this;
        }
        if (key != null && this.configuration != null) {
            this.configuration.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfiguration(Map<String, String> map) {
        if (this.configuration == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.configuration == null) continue;
                this.configuration.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public <K, V> A withConfiguration(Map<String, String> configuration) {
        this.configuration = configuration == null ? null : new LinkedHashMap<String, String>(configuration);
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.id != null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public Boolean hasPassword() {
        return this.password != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerFluentImpl that = (ServerFluentImpl)o;
        if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.id, this.password, this.username, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null && !this.configuration.isEmpty()) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
        }
        sb.append("}");
        return sb.toString();
    }
}

