/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.KanikoTask;
import io.fabric8.camelk.v1.KanikoTaskFluent;
import io.fabric8.camelk.v1.KanikoTaskFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class KanikoTaskBuilder
extends KanikoTaskFluentImpl<KanikoTaskBuilder>
implements VisitableBuilder<KanikoTask, KanikoTaskBuilder> {
    KanikoTaskFluent<?> fluent;
    Boolean validationEnabled;

    public KanikoTaskBuilder() {
        this(false);
    }

    public KanikoTaskBuilder(Boolean validationEnabled) {
        this(new KanikoTask(), validationEnabled);
    }

    public KanikoTaskBuilder(KanikoTaskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KanikoTaskBuilder(KanikoTaskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KanikoTask(), validationEnabled);
    }

    public KanikoTaskBuilder(KanikoTaskFluent<?> fluent, KanikoTask instance) {
        this(fluent, instance, false);
    }

    public KanikoTaskBuilder(KanikoTaskFluent<?> fluent, KanikoTask instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBaseImage(instance.getBaseImage());
        fluent.withCache(instance.getCache());
        fluent.withContextDir(instance.getContextDir());
        fluent.withImage(instance.getImage());
        fluent.withName(instance.getName());
        fluent.withRegistry(instance.getRegistry());
        fluent.withVerbose(instance.getVerbose());
        this.validationEnabled = validationEnabled;
    }

    public KanikoTaskBuilder(KanikoTask instance) {
        this(instance, (Boolean)false);
    }

    public KanikoTaskBuilder(KanikoTask instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBaseImage(instance.getBaseImage());
        this.withCache(instance.getCache());
        this.withContextDir(instance.getContextDir());
        this.withImage(instance.getImage());
        this.withName(instance.getName());
        this.withRegistry(instance.getRegistry());
        this.withVerbose(instance.getVerbose());
        this.validationEnabled = validationEnabled;
    }

    public KanikoTask build() {
        KanikoTask buildable = new KanikoTask(this.fluent.getBaseImage(), this.fluent.getCache(), this.fluent.getContextDir(), this.fluent.getImage(), this.fluent.getName(), this.fluent.getRegistry(), this.fluent.getVerbose());
        return buildable;
    }
}

