package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletBindingListBuilder extends KameletBindingListFluentImpl<KameletBindingListBuilder> implements VisitableBuilder<KameletBindingList,KameletBindingListBuilder>{
  public KameletBindingListBuilder() {
    this(false);
  }
  public KameletBindingListBuilder(Boolean validationEnabled) {
    this(new KameletBindingList(), validationEnabled);
  }
  public KameletBindingListBuilder(KameletBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletBindingListBuilder(KameletBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletBindingList(), validationEnabled);
  }
  public KameletBindingListBuilder(KameletBindingListFluent<?> fluent,KameletBindingList instance) {
    this(fluent, instance, false);
  }
  public KameletBindingListBuilder(KameletBindingListFluent<?> fluent,KameletBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KameletBindingListBuilder(KameletBindingList instance) {
    this(instance,false);
  }
  public KameletBindingListBuilder(KameletBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KameletBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public KameletBindingList build() {
    KameletBindingList buildable = new KameletBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}