package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletBindingStatusBuilder extends KameletBindingStatusFluentImpl<KameletBindingStatusBuilder> implements VisitableBuilder<KameletBindingStatus,KameletBindingStatusBuilder>{
  public KameletBindingStatusBuilder() {
    this(false);
  }
  public KameletBindingStatusBuilder(Boolean validationEnabled) {
    this(new KameletBindingStatus(), validationEnabled);
  }
  public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletBindingStatus(), validationEnabled);
  }
  public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent,KameletBindingStatus instance) {
    this(fluent, instance, false);
  }
  public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent,KameletBindingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withPhase(instance.getPhase());
      fluent.withReplicas(instance.getReplicas());
      fluent.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KameletBindingStatusBuilder(KameletBindingStatus instance) {
    this(instance,false);
  }
  public KameletBindingStatusBuilder(KameletBindingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withPhase(instance.getPhase());
      this.withReplicas(instance.getReplicas());
      this.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  KameletBindingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KameletBindingStatus build() {
    KameletBindingStatus buildable = new KameletBindingStatus(fluent.getConditions(),fluent.getPhase(),fluent.getReplicas(),fluent.getSelector());
    return buildable;
  }
  
}