package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KameletBindingStatusFluentImpl<A extends KameletBindingStatusFluent<A>> extends BaseFluent<A> implements KameletBindingStatusFluent<A>{
  public KameletBindingStatusFluentImpl() {
  }
  public KameletBindingStatusFluentImpl(KameletBindingStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withPhase(instance.getPhase());
      this.withReplicas(instance.getReplicas());
      this.withSelector(instance.getSelector());
    }
  }
  private ArrayList<KameletBindingConditionBuilder> conditions = new ArrayList<KameletBindingConditionBuilder>();
  private String phase;
  private Integer replicas;
  private String selector;
  public A addToConditions(int index,KameletBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<KameletBindingConditionBuilder>();}
    KameletBindingConditionBuilder builder = new KameletBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,KameletBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<KameletBindingConditionBuilder>();}
    KameletBindingConditionBuilder builder = new KameletBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.camelk.v1alpha1.KameletBindingCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<KameletBindingConditionBuilder>();}
    for (KameletBindingCondition item : items) {KameletBindingConditionBuilder builder = new KameletBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<KameletBindingCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<KameletBindingConditionBuilder>();}
    for (KameletBindingCondition item : items) {KameletBindingConditionBuilder builder = new KameletBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.camelk.v1alpha1.KameletBindingCondition... items) {
    for (KameletBindingCondition item : items) {KameletBindingConditionBuilder builder = new KameletBindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<KameletBindingCondition> items) {
    for (KameletBindingCondition item : items) {KameletBindingConditionBuilder builder = new KameletBindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<KameletBindingConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<KameletBindingConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      KameletBindingConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KameletBindingCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<KameletBindingCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public KameletBindingCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public KameletBindingCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public KameletBindingCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public KameletBindingCondition buildMatchingCondition(Predicate<KameletBindingConditionBuilder> predicate) {
    for (KameletBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<KameletBindingConditionBuilder> predicate) {
    for (KameletBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<KameletBindingCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (KameletBindingCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.camelk.v1alpha1.KameletBindingCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (KameletBindingCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new KameletBindingStatusFluentImpl.ConditionsNestedImpl();
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> addNewConditionLike(KameletBindingCondition item) {
    return new KameletBindingStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,KameletBindingCondition item) {
    return new KameletBindingStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public KameletBindingStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<KameletBindingConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public String getSelector() {
    return this.selector;
  }
  public A withSelector(String selector) {
    this.selector=selector; return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KameletBindingStatusFluentImpl that = (KameletBindingStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(phase, that.phase)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  phase,  replicas,  selector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends KameletBindingConditionFluentImpl<KameletBindingStatusFluentImpl.ConditionsNested<N>> implements KameletBindingStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,KameletBindingCondition item) {
      this.index = index;
      this.builder = new KameletBindingConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new KameletBindingConditionBuilder(this);
    }
    KameletBindingConditionBuilder builder;
    int index;
    public N and() {
      return (N) KameletBindingStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}