package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletPropertyBuilder extends KameletPropertyFluentImpl<KameletPropertyBuilder> implements VisitableBuilder<KameletProperty,KameletPropertyBuilder>{
  public KameletPropertyBuilder() {
    this(false);
  }
  public KameletPropertyBuilder(Boolean validationEnabled) {
    this(new KameletProperty(), validationEnabled);
  }
  public KameletPropertyBuilder(KameletPropertyFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletPropertyBuilder(KameletPropertyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletProperty(), validationEnabled);
  }
  public KameletPropertyBuilder(KameletPropertyFluent<?> fluent,KameletProperty instance) {
    this(fluent, instance, false);
  }
  public KameletPropertyBuilder(KameletPropertyFluent<?> fluent,KameletProperty instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDefault(instance.getDefault());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KameletPropertyBuilder(KameletProperty instance) {
    this(instance,false);
  }
  public KameletPropertyBuilder(KameletProperty instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDefault(instance.getDefault());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  KameletPropertyFluent<?> fluent;
  Boolean validationEnabled;
  public KameletProperty build() {
    KameletProperty buildable = new KameletProperty(fluent.getDefault(),fluent.getName());
    return buildable;
  }
  
}