/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.IntegrationPlatform;
import io.fabric8.camelk.v1.IntegrationPlatformFluent;
import io.fabric8.camelk.v1.IntegrationPlatformSpec;
import io.fabric8.camelk.v1.IntegrationPlatformSpecBuilder;
import io.fabric8.camelk.v1.IntegrationPlatformSpecFluentImpl;
import io.fabric8.camelk.v1.IntegrationPlatformStatus;
import io.fabric8.camelk.v1.IntegrationPlatformStatusBuilder;
import io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.Objects;

public class IntegrationPlatformFluentImpl<A extends IntegrationPlatformFluent<A>>
extends BaseFluent<A>
implements IntegrationPlatformFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private IntegrationPlatformSpecBuilder spec;
    private IntegrationPlatformStatusBuilder status;

    public IntegrationPlatformFluentImpl() {
    }

    public IntegrationPlatformFluentImpl(IntegrationPlatform instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public IntegrationPlatformFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public IntegrationPlatformFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public IntegrationPlatformFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public IntegrationPlatformFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public IntegrationPlatformFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public IntegrationPlatformSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public IntegrationPlatformSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(IntegrationPlatformSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new IntegrationPlatformSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public IntegrationPlatformFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public IntegrationPlatformFluent.SpecNested<A> withNewSpecLike(IntegrationPlatformSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public IntegrationPlatformFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public IntegrationPlatformFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new IntegrationPlatformSpecBuilder().build());
    }

    @Override
    public IntegrationPlatformFluent.SpecNested<A> editOrNewSpecLike(IntegrationPlatformSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public IntegrationPlatformStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public IntegrationPlatformStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(IntegrationPlatformStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new IntegrationPlatformStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public IntegrationPlatformFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public IntegrationPlatformFluent.StatusNested<A> withNewStatusLike(IntegrationPlatformStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public IntegrationPlatformFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public IntegrationPlatformFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new IntegrationPlatformStatusBuilder().build());
    }

    @Override
    public IntegrationPlatformFluent.StatusNested<A> editOrNewStatusLike(IntegrationPlatformStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationPlatformFluentImpl that = (IntegrationPlatformFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends IntegrationPlatformStatusFluentImpl<IntegrationPlatformFluent.StatusNested<N>>
    implements IntegrationPlatformFluent.StatusNested<N>,
    Nested<N> {
        IntegrationPlatformStatusBuilder builder;

        StatusNestedImpl(IntegrationPlatformStatus item) {
            this.builder = new IntegrationPlatformStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new IntegrationPlatformStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationPlatformFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends IntegrationPlatformSpecFluentImpl<IntegrationPlatformFluent.SpecNested<N>>
    implements IntegrationPlatformFluent.SpecNested<N>,
    Nested<N> {
        IntegrationPlatformSpecBuilder builder;

        SpecNestedImpl(IntegrationPlatformSpec item) {
            this.builder = new IntegrationPlatformSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new IntegrationPlatformSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationPlatformFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<IntegrationPlatformFluent.MetadataNested<N>>
    implements IntegrationPlatformFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)IntegrationPlatformFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

