/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.camelk.v1.ConfigurationSpec;
import io.fabric8.camelk.v1.ConfigurationSpecBuilder;
import io.fabric8.camelk.v1.ConfigurationSpecFluentImpl;
import io.fabric8.camelk.v1.IntegrationSpec;
import io.fabric8.camelk.v1.IntegrationSpecFluent;
import io.fabric8.camelk.v1.PodSpecTemplate;
import io.fabric8.camelk.v1.PodSpecTemplateBuilder;
import io.fabric8.camelk.v1.PodSpecTemplateFluentImpl;
import io.fabric8.camelk.v1.ResourceSpec;
import io.fabric8.camelk.v1.ResourceSpecBuilder;
import io.fabric8.camelk.v1.ResourceSpecFluentImpl;
import io.fabric8.camelk.v1.SourceSpec;
import io.fabric8.camelk.v1.SourceSpecBuilder;
import io.fabric8.camelk.v1.SourceSpecFluentImpl;
import io.fabric8.camelk.v1.TraitSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IntegrationSpecFluentImpl<A extends IntegrationSpecFluent<A>>
extends BaseFluent<A>
implements IntegrationSpecFluent<A> {
    private ArrayList<ConfigurationSpecBuilder> configuration = new ArrayList();
    private List<String> dependencies = new ArrayList<String>();
    private List<JsonNode> flows = new ArrayList<JsonNode>();
    private ObjectReferenceBuilder integrationKit;
    private String profile;
    private Integer replicas;
    private List<String> repositories = new ArrayList<String>();
    private ArrayList<ResourceSpecBuilder> resources = new ArrayList();
    private String serviceAccountName;
    private ArrayList<SourceSpecBuilder> sources = new ArrayList();
    private PodSpecTemplateBuilder template;
    private Map<String, TraitSpec> traits;

    public IntegrationSpecFluentImpl() {
    }

    public IntegrationSpecFluentImpl(IntegrationSpec instance) {
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withDependencies(instance.getDependencies());
            this.withFlows(instance.getFlows());
            this.withIntegrationKit(instance.getIntegrationKit());
            this.withProfile(instance.getProfile());
            this.withReplicas(instance.getReplicas());
            this.withRepositories(instance.getRepositories());
            this.withResources(instance.getResources());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSources(instance.getSources());
            this.withTemplate(instance.getTemplate());
            this.withTraits(instance.getTraits());
        }
    }

    @Override
    public A addToConfiguration(int index, ConfigurationSpec item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").add(index, builder);
            this.configuration.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConfiguration(int index, ConfigurationSpec item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
            this.configuration.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfiguration(ConfigurationSpec ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfiguration(ConfigurationSpec ... items) {
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").remove(builder);
            if (this.configuration == null) continue;
            this.configuration.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").remove(builder);
            if (this.configuration == null) continue;
            this.configuration.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (this.configuration == null) {
            return (A)this;
        }
        Iterator<ConfigurationSpecBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConfigurationSpec> getConfiguration() {
        return this.configuration != null ? IntegrationSpecFluentImpl.build(this.configuration) : null;
    }

    @Override
    public List<ConfigurationSpec> buildConfiguration() {
        return this.configuration != null ? IntegrationSpecFluentImpl.build(this.configuration) : null;
    }

    @Override
    public ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    @Override
    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    @Override
    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    @Override
    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").clear();
        }
        if (configuration != null) {
            this.configuration = new ArrayList();
            for (ConfigurationSpec item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)this;
    }

    @Override
    public A withConfiguration(ConfigurationSpec ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
            this._visitables.remove((Object)"configuration");
        }
        if (configuration != null) {
            for (ConfigurationSpec item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    @Override
    public A addNewConfiguration(String resourceKey, String resourceMountPoint, String resourceType, String type, String value) {
        return this.addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> setNewConfigurationLike(int index, ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public IntegrationSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(String ... items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    @Override
    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    @Override
    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    @Override
    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public A addToFlows(int index, JsonNode item) {
        if (this.flows == null) {
            this.flows = new ArrayList<JsonNode>();
        }
        this.flows.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFlows(int index, JsonNode item) {
        if (this.flows == null) {
            this.flows = new ArrayList<JsonNode>();
        }
        this.flows.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFlows(JsonNode ... items) {
        if (this.flows == null) {
            this.flows = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.flows.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFlows(Collection<JsonNode> items) {
        if (this.flows == null) {
            this.flows = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.flows.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFlows(JsonNode ... items) {
        for (JsonNode item : items) {
            if (this.flows == null) continue;
            this.flows.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFlows(Collection<JsonNode> items) {
        for (JsonNode item : items) {
            if (this.flows == null) continue;
            this.flows.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<JsonNode> getFlows() {
        return this.flows;
    }

    @Override
    public JsonNode getFlow(int index) {
        return this.flows.get(index);
    }

    @Override
    public JsonNode getFirstFlow() {
        return this.flows.get(0);
    }

    @Override
    public JsonNode getLastFlow() {
        return this.flows.get(this.flows.size() - 1);
    }

    @Override
    public JsonNode getMatchingFlow(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.flows) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFlow(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.flows) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFlows(List<JsonNode> flows) {
        if (flows != null) {
            this.flows = new ArrayList<JsonNode>();
            for (JsonNode item : flows) {
                this.addToFlows(item);
            }
        } else {
            this.flows = null;
        }
        return (A)this;
    }

    @Override
    public A withFlows(JsonNode ... flows) {
        if (this.flows != null) {
            this.flows.clear();
            this._visitables.remove((Object)"flows");
        }
        if (flows != null) {
            for (JsonNode item : flows) {
                this.addToFlows(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFlows() {
        return this.flows != null && !this.flows.isEmpty();
    }

    @Override
    @Deprecated
    public ObjectReference getIntegrationKit() {
        return this.integrationKit != null ? this.integrationKit.build() : null;
    }

    @Override
    public ObjectReference buildIntegrationKit() {
        return this.integrationKit != null ? this.integrationKit.build() : null;
    }

    @Override
    public A withIntegrationKit(ObjectReference integrationKit) {
        this._visitables.get((Object)"integrationKit").remove(this.integrationKit);
        if (integrationKit != null) {
            this.integrationKit = new ObjectReferenceBuilder(integrationKit);
            this._visitables.get((Object)"integrationKit").add(this.integrationKit);
        } else {
            this.integrationKit = null;
            this._visitables.get((Object)"integrationKit").remove(this.integrationKit);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIntegrationKit() {
        return this.integrationKit != null;
    }

    @Override
    public IntegrationSpecFluent.IntegrationKitNested<A> withNewIntegrationKit() {
        return new IntegrationKitNestedImpl();
    }

    @Override
    public IntegrationSpecFluent.IntegrationKitNested<A> withNewIntegrationKitLike(ObjectReference item) {
        return new IntegrationKitNestedImpl(item);
    }

    @Override
    public IntegrationSpecFluent.IntegrationKitNested<A> editIntegrationKit() {
        return this.withNewIntegrationKitLike(this.getIntegrationKit());
    }

    @Override
    public IntegrationSpecFluent.IntegrationKitNested<A> editOrNewIntegrationKit() {
        return this.withNewIntegrationKitLike(this.getIntegrationKit() != null ? this.getIntegrationKit() : new ObjectReferenceBuilder().build());
    }

    @Override
    public IntegrationSpecFluent.IntegrationKitNested<A> editOrNewIntegrationKitLike(ObjectReference item) {
        return this.withNewIntegrationKitLike(this.getIntegrationKit() != null ? this.getIntegrationKit() : item);
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToRepositories(int index, String item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRepositories(int index, String item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRepositories(String ... items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        for (String item : items) {
            this.repositories.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRepositories(Collection<String> items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        for (String item : items) {
            this.repositories.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRepositories(String ... items) {
        for (String item : items) {
            if (this.repositories == null) continue;
            this.repositories.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRepositories(Collection<String> items) {
        for (String item : items) {
            if (this.repositories == null) continue;
            this.repositories.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRepositories() {
        return this.repositories;
    }

    @Override
    public String getRepository(int index) {
        return this.repositories.get(index);
    }

    @Override
    public String getFirstRepository() {
        return this.repositories.get(0);
    }

    @Override
    public String getLastRepository() {
        return this.repositories.get(this.repositories.size() - 1);
    }

    @Override
    public String getMatchingRepository(Predicate<String> predicate) {
        for (String item : this.repositories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRepository(Predicate<String> predicate) {
        for (String item : this.repositories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRepositories(List<String> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<String>();
            for (String item : repositories) {
                this.addToRepositories(item);
            }
        } else {
            this.repositories = null;
        }
        return (A)this;
    }

    @Override
    public A withRepositories(String ... repositories) {
        if (this.repositories != null) {
            this.repositories.clear();
            this._visitables.remove((Object)"repositories");
        }
        if (repositories != null) {
            for (String item : repositories) {
                this.addToRepositories(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepositories() {
        return this.repositories != null && !this.repositories.isEmpty();
    }

    @Override
    public A addToResources(int index, ResourceSpec item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(index, builder);
            this.resources.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToResources(int index, ResourceSpec item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").set(index, builder);
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(ResourceSpec ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<ResourceSpec> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(ResourceSpec ... items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<ResourceSpecBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            ResourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceSpec> getResources() {
        return this.resources != null ? IntegrationSpecFluentImpl.build(this.resources) : null;
    }

    @Override
    public List<ResourceSpec> buildResources() {
        return this.resources != null ? IntegrationSpecFluentImpl.build(this.resources) : null;
    }

    @Override
    public ResourceSpec buildResource(int index) {
        return this.resources.get(index).build();
    }

    @Override
    public ResourceSpec buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public ResourceSpec buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<ResourceSpec> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (ResourceSpec item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(ResourceSpec ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (ResourceSpec item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> setNewResourceLike(int index, ResourceSpec item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public IntegrationSpecFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public A addToSources(int index, SourceSpec item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").add(index, builder);
            this.sources.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSources(int index, SourceSpec item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(SourceSpec ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<SourceSpec> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(SourceSpec ... items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<SourceSpecBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            SourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SourceSpec> getSources() {
        return this.sources != null ? IntegrationSpecFluentImpl.build(this.sources) : null;
    }

    @Override
    public List<SourceSpec> buildSources() {
        return this.sources != null ? IntegrationSpecFluentImpl.build(this.sources) : null;
    }

    @Override
    public SourceSpec buildSource(int index) {
        return this.sources.get(index).build();
    }

    @Override
    public SourceSpec buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public SourceSpec buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<SourceSpec> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (SourceSpec item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(SourceSpec ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove((Object)"sources");
        }
        if (sources != null) {
            for (SourceSpec item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> addNewSourceLike(SourceSpec item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> setNewSourceLike(int index, SourceSpec item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public IntegrationSpecFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    @Deprecated
    public PodSpecTemplate getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodSpecTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodSpecTemplate template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new PodSpecTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public IntegrationSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public IntegrationSpecFluent.TemplateNested<A> withNewTemplateLike(PodSpecTemplate item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public IntegrationSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public IntegrationSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodSpecTemplateBuilder().build());
    }

    @Override
    public IntegrationSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodSpecTemplate item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public A addToTraits(String key, TraitSpec value) {
        if (this.traits == null && key != null && value != null) {
            this.traits = new LinkedHashMap<String, TraitSpec>();
        }
        if (key != null && value != null) {
            this.traits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTraits(Map<String, TraitSpec> map) {
        if (this.traits == null && map != null) {
            this.traits = new LinkedHashMap<String, TraitSpec>();
        }
        if (map != null) {
            this.traits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraits(String key) {
        if (this.traits == null) {
            return (A)this;
        }
        if (key != null && this.traits != null) {
            this.traits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraits(Map<String, TraitSpec> map) {
        if (this.traits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.traits == null) continue;
                this.traits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, TraitSpec> getTraits() {
        return this.traits;
    }

    @Override
    public <K, V> A withTraits(Map<String, TraitSpec> traits) {
        this.traits = traits == null ? null : new LinkedHashMap<String, TraitSpec>(traits);
        return (A)this;
    }

    @Override
    public Boolean hasTraits() {
        return this.traits != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationSpecFluentImpl that = (IntegrationSpecFluentImpl)o;
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.flows, that.flows)) {
            return false;
        }
        if (!Objects.equals(this.integrationKit, that.integrationKit)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.repositories, that.repositories)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.traits, that.traits);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.dependencies, this.flows, this.integrationKit, this.profile, this.replicas, this.repositories, this.resources, this.serviceAccountName, this.sources, this.template, this.traits, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.flows != null && !this.flows.isEmpty()) {
            sb.append("flows:");
            sb.append(this.flows + ",");
        }
        if (this.integrationKit != null) {
            sb.append("integrationKit:");
            sb.append(this.integrationKit + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.repositories != null && !this.repositories.isEmpty()) {
            sb.append("repositories:");
            sb.append(this.repositories + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sources != null) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.traits != null && !this.traits.isEmpty()) {
            sb.append("traits:");
            sb.append(this.traits);
        }
        sb.append("}");
        return sb.toString();
    }

    class TemplateNestedImpl<N>
    extends PodSpecTemplateFluentImpl<IntegrationSpecFluent.TemplateNested<N>>
    implements IntegrationSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodSpecTemplateBuilder builder;

        TemplateNestedImpl(PodSpecTemplate item) {
            this.builder = new PodSpecTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodSpecTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class SourcesNestedImpl<N>
    extends SourceSpecFluentImpl<IntegrationSpecFluent.SourcesNested<N>>
    implements IntegrationSpecFluent.SourcesNested<N>,
    Nested<N> {
        SourceSpecBuilder builder;
        int index;

        SourcesNestedImpl(int index, SourceSpec item) {
            this.index = index;
            this.builder = new SourceSpecBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new SourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationSpecFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    class ResourcesNestedImpl<N>
    extends ResourceSpecFluentImpl<IntegrationSpecFluent.ResourcesNested<N>>
    implements IntegrationSpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceSpecBuilder builder;
        int index;

        ResourcesNestedImpl(int index, ResourceSpec item) {
            this.index = index;
            this.builder = new ResourceSpecBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new ResourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationSpecFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }

    class IntegrationKitNestedImpl<N>
    extends ObjectReferenceFluentImpl<IntegrationSpecFluent.IntegrationKitNested<N>>
    implements IntegrationSpecFluent.IntegrationKitNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        IntegrationKitNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        IntegrationKitNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)IntegrationSpecFluentImpl.this.withIntegrationKit(this.builder.build());
        }

        @Override
        public N endIntegrationKit() {
            return this.and();
        }
    }

    class ConfigurationNestedImpl<N>
    extends ConfigurationSpecFluentImpl<IntegrationSpecFluent.ConfigurationNested<N>>
    implements IntegrationSpecFluent.ConfigurationNested<N>,
    Nested<N> {
        ConfigurationSpecBuilder builder;
        int index;

        ConfigurationNestedImpl(int index, ConfigurationSpec item) {
            this.index = index;
            this.builder = new ConfigurationSpecBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.index = -1;
            this.builder = new ConfigurationSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationSpecFluentImpl.this.setToConfiguration(this.index, this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }
}

