/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatus;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatusBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatusFluentImpl;
import io.fabric8.certmanager.api.model.v1.IssuerCondition;
import io.fabric8.certmanager.api.model.v1.IssuerConditionBuilder;
import io.fabric8.certmanager.api.model.v1.IssuerConditionFluentImpl;
import io.fabric8.certmanager.api.model.v1.IssuerStatus;
import io.fabric8.certmanager.api.model.v1.IssuerStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IssuerStatusFluentImpl<A extends IssuerStatusFluent<A>>
extends BaseFluent<A>
implements IssuerStatusFluent<A> {
    private ACMEIssuerStatusBuilder acme;
    private List<IssuerConditionBuilder> conditions;

    public IssuerStatusFluentImpl() {
    }

    public IssuerStatusFluentImpl(IssuerStatus instance) {
        this.withAcme(instance.getAcme());
        this.withConditions(instance.getConditions());
    }

    @Override
    @Deprecated
    public ACMEIssuerStatus getAcme() {
        return this.acme != null ? this.acme.build() : null;
    }

    @Override
    public ACMEIssuerStatus buildAcme() {
        return this.acme != null ? this.acme.build() : null;
    }

    @Override
    public A withAcme(ACMEIssuerStatus acme) {
        this._visitables.get((Object)"acme").remove(this.acme);
        if (acme != null) {
            this.acme = new ACMEIssuerStatusBuilder(acme);
            this._visitables.get((Object)"acme").add(this.acme);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAcme() {
        return this.acme != null;
    }

    @Override
    public A withNewAcme(String lastRegisteredEmail, String uri) {
        return this.withAcme(new ACMEIssuerStatus(lastRegisteredEmail, uri));
    }

    @Override
    public IssuerStatusFluent.AcmeNested<A> withNewAcme() {
        return new AcmeNestedImpl();
    }

    @Override
    public IssuerStatusFluent.AcmeNested<A> withNewAcmeLike(ACMEIssuerStatus item) {
        return new AcmeNestedImpl(item);
    }

    @Override
    public IssuerStatusFluent.AcmeNested<A> editAcme() {
        return this.withNewAcmeLike(this.getAcme());
    }

    @Override
    public IssuerStatusFluent.AcmeNested<A> editOrNewAcme() {
        return this.withNewAcmeLike(this.getAcme() != null ? this.getAcme() : new ACMEIssuerStatusBuilder().build());
    }

    @Override
    public IssuerStatusFluent.AcmeNested<A> editOrNewAcmeLike(ACMEIssuerStatus item) {
        return this.withNewAcmeLike(this.getAcme() != null ? this.getAcme() : item);
    }

    @Override
    public A addToConditions(Integer index, IssuerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IssuerConditionBuilder>();
        }
        IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, IssuerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IssuerConditionBuilder>();
        }
        IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(IssuerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IssuerConditionBuilder>();
        }
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<IssuerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IssuerConditionBuilder>();
        }
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(IssuerCondition ... items) {
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<IssuerCondition> items) {
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<IssuerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<IssuerConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            IssuerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IssuerCondition> getConditions() {
        return IssuerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<IssuerCondition> buildConditions() {
        return IssuerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public IssuerCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public IssuerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public IssuerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public IssuerCondition buildMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
        for (IssuerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
        for (IssuerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<IssuerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<IssuerConditionBuilder>();
            for (IssuerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(IssuerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (IssuerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new IssuerCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> addNewConditionLike(IssuerCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, IssuerCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IssuerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssuerStatusFluentImpl that = (IssuerStatusFluentImpl)o;
        if (this.acme != null ? !this.acme.equals(that.acme) : that.acme != null) {
            return false;
        }
        return !(this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null);
    }

    public int hashCode() {
        return Objects.hash(this.acme, this.conditions, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends IssuerConditionFluentImpl<IssuerStatusFluent.ConditionsNested<N>>
    implements IssuerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        IssuerConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, IssuerCondition item) {
            this.index = index;
            this.builder = new IssuerConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new IssuerConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)IssuerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class AcmeNestedImpl<N>
    extends ACMEIssuerStatusFluentImpl<IssuerStatusFluent.AcmeNested<N>>
    implements IssuerStatusFluent.AcmeNested<N>,
    Nested<N> {
        ACMEIssuerStatusBuilder builder;

        AcmeNestedImpl(ACMEIssuerStatus item) {
            this.builder = new ACMEIssuerStatusBuilder(this, item);
        }

        AcmeNestedImpl() {
            this.builder = new ACMEIssuerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)IssuerStatusFluentImpl.this.withAcme(this.builder.build());
        }

        @Override
        public N endAcme() {
            return this.and();
        }
    }
}

