/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.v1.IssuerStatus;
import io.fabric8.certmanager.api.model.v1.IssuerStatusFluent;
import io.fabric8.certmanager.api.model.v1.IssuerStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class IssuerStatusBuilder
extends IssuerStatusFluentImpl<IssuerStatusBuilder>
implements VisitableBuilder<IssuerStatus, IssuerStatusBuilder> {
    IssuerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IssuerStatusBuilder() {
        this(false);
    }

    public IssuerStatusBuilder(Boolean validationEnabled) {
        this(new IssuerStatus(), validationEnabled);
    }

    public IssuerStatusBuilder(IssuerStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IssuerStatusBuilder(IssuerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IssuerStatus(), validationEnabled);
    }

    public IssuerStatusBuilder(IssuerStatusFluent<?> fluent, IssuerStatus instance) {
        this(fluent, instance, false);
    }

    public IssuerStatusBuilder(IssuerStatusFluent<?> fluent, IssuerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAcme(instance.getAcme());
        fluent.withConditions(instance.getConditions());
        this.validationEnabled = validationEnabled;
    }

    public IssuerStatusBuilder(IssuerStatus instance) {
        this(instance, (Boolean)false);
    }

    public IssuerStatusBuilder(IssuerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAcme(instance.getAcme());
        this.withConditions(instance.getConditions());
        this.validationEnabled = validationEnabled;
    }

    public IssuerStatus build() {
        IssuerStatus buildable = new IssuerStatus(this.fluent.getAcme(), this.fluent.getConditions());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IssuerStatusBuilder that = (IssuerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

