/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatus;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatusBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatusFluent;
import io.fabric8.certmanager.api.model.v1.IssuerCondition;
import io.fabric8.certmanager.api.model.v1.IssuerConditionBuilder;
import io.fabric8.certmanager.api.model.v1.IssuerConditionFluent;
import io.fabric8.certmanager.api.model.v1.IssuerStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IssuerStatusFluent<A extends IssuerStatusFluent<A>>
extends BaseFluent<A> {
    private ACMEIssuerStatusBuilder acme;
    private ArrayList<IssuerConditionBuilder> conditions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public IssuerStatusFluent() {
    }

    public IssuerStatusFluent(IssuerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IssuerStatus instance) {
        IssuerStatus issuerStatus = instance = instance != null ? instance : new IssuerStatus();
        if (instance != null) {
            this.withAcme(instance.getAcme());
            this.withConditions(instance.getConditions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ACMEIssuerStatus buildAcme() {
        return this.acme != null ? this.acme.build() : null;
    }

    public A withAcme(ACMEIssuerStatus acme) {
        this._visitables.remove((Object)"acme");
        if (acme != null) {
            this.acme = new ACMEIssuerStatusBuilder(acme);
            this._visitables.get((Object)"acme").add(this.acme);
        } else {
            this.acme = null;
            this._visitables.get((Object)"acme").remove((Object)this.acme);
        }
        return (A)((Object)this);
    }

    public boolean hasAcme() {
        return this.acme != null;
    }

    public A withNewAcme(String lastPrivateKeyHash, String lastRegisteredEmail, String uri) {
        return this.withAcme(new ACMEIssuerStatus(lastPrivateKeyHash, lastRegisteredEmail, uri));
    }

    public AcmeNested<A> withNewAcme() {
        return new AcmeNested(null);
    }

    public AcmeNested<A> withNewAcmeLike(ACMEIssuerStatus item) {
        return new AcmeNested(item);
    }

    public AcmeNested<A> editAcme() {
        return this.withNewAcmeLike(Optional.ofNullable(this.buildAcme()).orElse(null));
    }

    public AcmeNested<A> editOrNewAcme() {
        return this.withNewAcmeLike(Optional.ofNullable(this.buildAcme()).orElse(new ACMEIssuerStatusBuilder().build()));
    }

    public AcmeNested<A> editOrNewAcmeLike(ACMEIssuerStatus item) {
        return this.withNewAcmeLike(Optional.ofNullable(this.buildAcme()).orElse(item));
    }

    public A addToConditions(int index, IssuerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, IssuerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(IssuerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<IssuerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(IssuerCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<IssuerCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (IssuerCondition item : items) {
            IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<IssuerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<IssuerConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            IssuerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IssuerCondition> buildConditions() {
        return this.conditions != null ? IssuerStatusFluent.build(this.conditions) : null;
    }

    public IssuerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public IssuerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public IssuerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public IssuerCondition buildMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
        for (IssuerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
        for (IssuerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<IssuerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (IssuerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(IssuerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (IssuerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(IssuerCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, IssuerCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IssuerStatusFluent that = (IssuerStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.acme, (Object)that.acme)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acme, this.conditions, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acme != null) {
            sb.append("acme:");
            sb.append((Object)((Object)this.acme) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends IssuerConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        IssuerConditionBuilder builder;
        int index;

        ConditionsNested(int index, IssuerCondition item) {
            this.index = index;
            this.builder = new IssuerConditionBuilder(this, item);
        }

        public N and() {
            return (N)IssuerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AcmeNested<N>
    extends ACMEIssuerStatusFluent<AcmeNested<N>>
    implements Nested<N> {
        ACMEIssuerStatusBuilder builder;

        AcmeNested(ACMEIssuerStatus item) {
            this.builder = new ACMEIssuerStatusBuilder(this, item);
        }

        public N and() {
            return (N)IssuerStatusFluent.this.withAcme(this.builder.build());
        }

        public N endAcme() {
            return this.and();
        }
    }
}

