/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1.VaultAuth;
import io.fabric8.certmanager.api.model.v1.VaultAuthBuilder;
import io.fabric8.certmanager.api.model.v1.VaultAuthFluent;
import io.fabric8.certmanager.api.model.v1.VaultIssuer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VaultIssuerFluent<A extends VaultIssuerFluent<A>>
extends BaseFluent<A> {
    private VaultAuthBuilder auth;
    private String caBundle;
    private SecretKeySelectorBuilder caBundleSecretRef;
    private String namespace;
    private String path;
    private String server;
    private Map<String, Object> additionalProperties;

    public VaultIssuerFluent() {
    }

    public VaultIssuerFluent(VaultIssuer instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VaultIssuer instance) {
        VaultIssuer vaultIssuer = instance = instance != null ? instance : new VaultIssuer();
        if (instance != null) {
            this.withAuth(instance.getAuth());
            this.withCaBundle(instance.getCaBundle());
            this.withCaBundleSecretRef(instance.getCaBundleSecretRef());
            this.withNamespace(instance.getNamespace());
            this.withPath(instance.getPath());
            this.withServer(instance.getServer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public VaultAuth buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public A withAuth(VaultAuth auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new VaultAuthBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(VaultAuth item) {
        return new AuthNested(item);
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new VaultAuthBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(VaultAuth item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)((Object)this);
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public SecretKeySelector buildCaBundleSecretRef() {
        return this.caBundleSecretRef != null ? this.caBundleSecretRef.build() : null;
    }

    public A withCaBundleSecretRef(SecretKeySelector caBundleSecretRef) {
        this._visitables.remove((Object)"caBundleSecretRef");
        if (caBundleSecretRef != null) {
            this.caBundleSecretRef = new SecretKeySelectorBuilder(caBundleSecretRef);
            this._visitables.get((Object)"caBundleSecretRef").add(this.caBundleSecretRef);
        } else {
            this.caBundleSecretRef = null;
            this._visitables.get((Object)"caBundleSecretRef").remove((Object)this.caBundleSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasCaBundleSecretRef() {
        return this.caBundleSecretRef != null;
    }

    public A withNewCaBundleSecretRef(String key, String name) {
        return this.withCaBundleSecretRef(new SecretKeySelector(key, name));
    }

    public CaBundleSecretRefNested<A> withNewCaBundleSecretRef() {
        return new CaBundleSecretRefNested(null);
    }

    public CaBundleSecretRefNested<A> withNewCaBundleSecretRefLike(SecretKeySelector item) {
        return new CaBundleSecretRefNested(item);
    }

    public CaBundleSecretRefNested<A> editCaBundleSecretRef() {
        return this.withNewCaBundleSecretRefLike(Optional.ofNullable(this.buildCaBundleSecretRef()).orElse(null));
    }

    public CaBundleSecretRefNested<A> editOrNewCaBundleSecretRef() {
        return this.withNewCaBundleSecretRefLike(Optional.ofNullable(this.buildCaBundleSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public CaBundleSecretRefNested<A> editOrNewCaBundleSecretRefLike(SecretKeySelector item) {
        return this.withNewCaBundleSecretRefLike(Optional.ofNullable(this.buildCaBundleSecretRef()).orElse(item));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)((Object)this);
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultIssuerFluent that = (VaultIssuerFluent)((Object)o);
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals((Object)this.caBundleSecretRef, (Object)that.caBundleSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth, this.caBundle, this.caBundleSecretRef, this.namespace, this.path, this.server, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auth != null) {
            sb.append("auth:");
            sb.append((Object)((Object)this.auth) + ",");
        }
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle + ",");
        }
        if (this.caBundleSecretRef != null) {
            sb.append("caBundleSecretRef:");
            sb.append((Object)((Object)this.caBundleSecretRef) + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CaBundleSecretRefNested<N>
    extends SecretKeySelectorFluent<CaBundleSecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        CaBundleSecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)VaultIssuerFluent.this.withCaBundleSecretRef(this.builder.build());
        }

        public N endCaBundleSecretRef() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends VaultAuthFluent<AuthNested<N>>
    implements Nested<N> {
        VaultAuthBuilder builder;

        AuthNested(VaultAuth item) {
            this.builder = new VaultAuthBuilder(this, item);
        }

        public N and() {
            return (N)VaultIssuerFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }
}

