package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEAuthorizationFluentImpl<A extends ACMEAuthorizationFluent<A>> extends BaseFluent<A> implements ACMEAuthorizationFluent<A>{
  public ACMEAuthorizationFluentImpl() {
  }
  public ACMEAuthorizationFluentImpl(ACMEAuthorization instance) {
    this.withChallenges(instance.getChallenges()); 
    this.withIdentifier(instance.getIdentifier()); 
    this.withInitialState(instance.getInitialState()); 
    this.withUrl(instance.getUrl()); 
    this.withWildcard(instance.getWildcard()); 
  }
  private ArrayList<ACMEChallengeBuilder> challenges = new ArrayList<ACMEChallengeBuilder>();
  private String identifier;
  private String initialState;
  private String url;
  private Boolean wildcard;
  public A addToChallenges(Integer index,ACMEChallenge item) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").add(index >= 0 ? index : _visitables.get("challenges").size(), builder);this.challenges.add(index >= 0 ? index : challenges.size(), builder); return (A)this;
  }
  public A setToChallenges(Integer index,ACMEChallenge item) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
    if (index < 0 || index >= _visitables.get("challenges").size()) { _visitables.get("challenges").add(builder); } else { _visitables.get("challenges").set(index, builder);}
    if (index < 0 || index >= challenges.size()) { challenges.add(builder); } else { challenges.set(index, builder);}
     return (A)this;
  }
  public A addToChallenges(io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge... items) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").add(builder);this.challenges.add(builder);} return (A)this;
  }
  public A addAllToChallenges(Collection<ACMEChallenge> items) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").add(builder);this.challenges.add(builder);} return (A)this;
  }
  public A removeFromChallenges(io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge... items) {
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").remove(builder);if (this.challenges != null) {this.challenges.remove(builder);}} return (A)this;
  }
  public A removeAllFromChallenges(Collection<ACMEChallenge> items) {
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").remove(builder);if (this.challenges != null) {this.challenges.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromChallenges(Predicate<ACMEChallengeBuilder> predicate) {
    if (challenges == null) return (A) this;
    final Iterator<ACMEChallengeBuilder> each = challenges.iterator();
    final List visitables = _visitables.get("challenges");
    while (each.hasNext()) {
      ACMEChallengeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildChallenges instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ACMEChallenge> getChallenges() {
    return challenges != null ? build(challenges) : null;
  }
  public List<ACMEChallenge> buildChallenges() {
    return challenges != null ? build(challenges) : null;
  }
  public ACMEChallenge buildChallenge(Integer index) {
    return this.challenges.get(index).build();
  }
  public ACMEChallenge buildFirstChallenge() {
    return this.challenges.get(0).build();
  }
  public ACMEChallenge buildLastChallenge() {
    return this.challenges.get(challenges.size() - 1).build();
  }
  public ACMEChallenge buildMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
    for (ACMEChallengeBuilder item: challenges) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
    for (ACMEChallengeBuilder item: challenges) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withChallenges(List<ACMEChallenge> challenges) {
    if (this.challenges != null) { _visitables.get("challenges").removeAll(this.challenges);}
    if (challenges != null) {this.challenges = new ArrayList(); for (ACMEChallenge item : challenges){this.addToChallenges(item);}} else { this.challenges = null;} return (A) this;
  }
  public A withChallenges(io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge... challenges) {
    if (this.challenges != null) {this.challenges.clear();}
    if (challenges != null) {for (ACMEChallenge item :challenges){ this.addToChallenges(item);}} return (A) this;
  }
  public Boolean hasChallenges() {
    return challenges != null && !challenges.isEmpty();
  }
  public A addNewChallenge(String token,String type,String url) {
    return (A)addToChallenges(new ACMEChallenge(token, type, url));
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> addNewChallenge() {
    return new ACMEAuthorizationFluentImpl.ChallengesNestedImpl();
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> addNewChallengeLike(ACMEChallenge item) {
    return new ACMEAuthorizationFluentImpl.ChallengesNestedImpl(-1, item);
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> setNewChallengeLike(Integer index,ACMEChallenge item) {
    return new ACMEAuthorizationFluentImpl.ChallengesNestedImpl(index, item);
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> editChallenge(Integer index) {
    if (challenges.size() <= index) throw new RuntimeException("Can't edit challenges. Index exceeds size.");
    return setNewChallengeLike(index, buildChallenge(index));
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> editFirstChallenge() {
    if (challenges.size() == 0) throw new RuntimeException("Can't edit first challenges. The list is empty.");
    return setNewChallengeLike(0, buildChallenge(0));
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> editLastChallenge() {
    int index = challenges.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last challenges. The list is empty.");
    return setNewChallengeLike(index, buildChallenge(index));
  }
  public ACMEAuthorizationFluent.ChallengesNested<A> editMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<challenges.size();i++) { 
    if (predicate.test(challenges.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching challenges. No match found.");
    return setNewChallengeLike(index, buildChallenge(index));
  }
  public String getIdentifier() {
    return this.identifier;
  }
  public A withIdentifier(String identifier) {
    this.identifier=identifier; return (A) this;
  }
  public Boolean hasIdentifier() {
    return this.identifier != null;
  }
  public String getInitialState() {
    return this.initialState;
  }
  public A withInitialState(String initialState) {
    this.initialState=initialState; return (A) this;
  }
  public Boolean hasInitialState() {
    return this.initialState != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public Boolean getWildcard() {
    return this.wildcard;
  }
  public A withWildcard(Boolean wildcard) {
    this.wildcard=wildcard; return (A) this;
  }
  public Boolean hasWildcard() {
    return this.wildcard != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEAuthorizationFluentImpl that = (ACMEAuthorizationFluentImpl) o;
    if (challenges != null ? !challenges.equals(that.challenges) :that.challenges != null) return false;
    if (identifier != null ? !identifier.equals(that.identifier) :that.identifier != null) return false;
    if (initialState != null ? !initialState.equals(that.initialState) :that.initialState != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (wildcard != null ? !wildcard.equals(that.wildcard) :that.wildcard != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(challenges,  identifier,  initialState,  url,  wildcard,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (challenges != null && !challenges.isEmpty()) { sb.append("challenges:"); sb.append(challenges + ","); }
    if (identifier != null) { sb.append("identifier:"); sb.append(identifier + ","); }
    if (initialState != null) { sb.append("initialState:"); sb.append(initialState + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (wildcard != null) { sb.append("wildcard:"); sb.append(wildcard); }
    sb.append("}");
    return sb.toString();
  }
  public A withWildcard() {
    return withWildcard(true);
  }
  class ChallengesNestedImpl<N> extends ACMEChallengeFluentImpl<ACMEAuthorizationFluent.ChallengesNested<N>> implements ACMEAuthorizationFluent.ChallengesNested<N>,Nested<N>{
    ChallengesNestedImpl(Integer index,ACMEChallenge item) {
      this.index = index;
      this.builder = new ACMEChallengeBuilder(this, item);
    }
    ChallengesNestedImpl() {
      this.index = -1;
      this.builder = new ACMEChallengeBuilder(this);
    }
    ACMEChallengeBuilder builder;
    Integer index;
    public N and() {
      return (N) ACMEAuthorizationFluentImpl.this.setToChallenges(index,builder.build());
    }
    public N endChallenge() {
      return and();
    }
    
  }
  
}