package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.ParentReference;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEChallengeSolverHTTP01GatewayHTTPRouteFluentImpl<A extends ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent<A>> extends BaseFluent<A> implements ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent<A>{
  public ACMEChallengeSolverHTTP01GatewayHTTPRouteFluentImpl() {
  }
  public ACMEChallengeSolverHTTP01GatewayHTTPRouteFluentImpl(ACMEChallengeSolverHTTP01GatewayHTTPRoute instance) {
    this.withLabels(instance.getLabels()); 
    this.withParentRefs(instance.getParentRefs()); 
    this.withServiceType(instance.getServiceType()); 
  }
  private Map<String,String> labels;
  private List<ParentReference> parentRefs = new ArrayList<ParentReference>();
  private String serviceType;
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public A addToParentRefs(Integer index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    this.parentRefs.add(index, item);
    return (A)this;
  }
  public A setToParentRefs(Integer index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    this.parentRefs.set(index, item); return (A)this;
  }
  public A addToParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.ParentReference... items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    for (ParentReference item : items) {this.parentRefs.add(item);} return (A)this;
  }
  public A addAllToParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    for (ParentReference item : items) {this.parentRefs.add(item);} return (A)this;
  }
  public A removeFromParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.ParentReference... items) {
    for (ParentReference item : items) {if (this.parentRefs!= null){ this.parentRefs.remove(item);}} return (A)this;
  }
  public A removeAllFromParentRefs(Collection<ParentReference> items) {
    for (ParentReference item : items) {if (this.parentRefs!= null){ this.parentRefs.remove(item);}} return (A)this;
  }
  public List<ParentReference> getParentRefs() {
    return this.parentRefs;
  }
  public ParentReference getParentRef(Integer index) {
    return this.parentRefs.get(index);
  }
  public ParentReference getFirstParentRef() {
    return this.parentRefs.get(0);
  }
  public ParentReference getLastParentRef() {
    return this.parentRefs.get(parentRefs.size() - 1);
  }
  public ParentReference getMatchingParentRef(Predicate<ParentReference> predicate) {
    for (ParentReference item: parentRefs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingParentRef(Predicate<ParentReference> predicate) {
    for (ParentReference item: parentRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParentRefs(List<ParentReference> parentRefs) {
    if (parentRefs != null) {this.parentRefs = new ArrayList(); for (ParentReference item : parentRefs){this.addToParentRefs(item);}} else { this.parentRefs = null;} return (A) this;
  }
  public A withParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.ParentReference... parentRefs) {
    if (this.parentRefs != null) {this.parentRefs.clear();}
    if (parentRefs != null) {for (ParentReference item :parentRefs){ this.addToParentRefs(item);}} return (A) this;
  }
  public Boolean hasParentRefs() {
    return parentRefs != null && !parentRefs.isEmpty();
  }
  public String getServiceType() {
    return this.serviceType;
  }
  public A withServiceType(String serviceType) {
    this.serviceType=serviceType; return (A) this;
  }
  public Boolean hasServiceType() {
    return this.serviceType != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEChallengeSolverHTTP01GatewayHTTPRouteFluentImpl that = (ACMEChallengeSolverHTTP01GatewayHTTPRouteFluentImpl) o;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (parentRefs != null ? !parentRefs.equals(that.parentRefs) :that.parentRefs != null) return false;
    if (serviceType != null ? !serviceType.equals(that.serviceType) :that.serviceType != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(labels,  parentRefs,  serviceType,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (parentRefs != null && !parentRefs.isEmpty()) { sb.append("parentRefs:"); sb.append(parentRefs + ","); }
    if (serviceType != null) { sb.append("serviceType:"); sb.append(serviceType); }
    sb.append("}");
    return sb.toString();
  }
  
}