package io.fabric8.certmanager.api.model.acme.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerDNS01ProviderRFC2136FluentImpl<A extends ACMEIssuerDNS01ProviderRFC2136Fluent<A>> extends BaseFluent<A> implements ACMEIssuerDNS01ProviderRFC2136Fluent<A>{
  public ACMEIssuerDNS01ProviderRFC2136FluentImpl() {
  }
  public ACMEIssuerDNS01ProviderRFC2136FluentImpl(ACMEIssuerDNS01ProviderRFC2136 instance) {
    this.withNameserver(instance.getNameserver()); 
    this.withTsigAlgorithm(instance.getTsigAlgorithm()); 
    this.withTsigKeyName(instance.getTsigKeyName()); 
    this.withTsigSecretSecretRef(instance.getTsigSecretSecretRef()); 
  }
  private String nameserver;
  private String tsigAlgorithm;
  private String tsigKeyName;
  private SecretKeySelectorBuilder tsigSecretSecretRef;
  public String getNameserver() {
    return this.nameserver;
  }
  public A withNameserver(String nameserver) {
    this.nameserver=nameserver; return (A) this;
  }
  public Boolean hasNameserver() {
    return this.nameserver != null;
  }
  public String getTsigAlgorithm() {
    return this.tsigAlgorithm;
  }
  public A withTsigAlgorithm(String tsigAlgorithm) {
    this.tsigAlgorithm=tsigAlgorithm; return (A) this;
  }
  public Boolean hasTsigAlgorithm() {
    return this.tsigAlgorithm != null;
  }
  public String getTsigKeyName() {
    return this.tsigKeyName;
  }
  public A withTsigKeyName(String tsigKeyName) {
    this.tsigKeyName=tsigKeyName; return (A) this;
  }
  public Boolean hasTsigKeyName() {
    return this.tsigKeyName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTsigSecretSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getTsigSecretSecretRef() {
    return this.tsigSecretSecretRef!=null ?this.tsigSecretSecretRef.build():null;
  }
  public SecretKeySelector buildTsigSecretSecretRef() {
    return this.tsigSecretSecretRef!=null ?this.tsigSecretSecretRef.build():null;
  }
  public A withTsigSecretSecretRef(SecretKeySelector tsigSecretSecretRef) {
    _visitables.get("tsigSecretSecretRef").remove(this.tsigSecretSecretRef);
    if (tsigSecretSecretRef!=null){ this.tsigSecretSecretRef= new SecretKeySelectorBuilder(tsigSecretSecretRef); _visitables.get("tsigSecretSecretRef").add(this.tsigSecretSecretRef);} else { this.tsigSecretSecretRef = null; _visitables.get("tsigSecretSecretRef").remove(this.tsigSecretSecretRef); } return (A) this;
  }
  public Boolean hasTsigSecretSecretRef() {
    return this.tsigSecretSecretRef != null;
  }
  public A withNewTsigSecretSecretRef(String key,String name) {
    return (A)withTsigSecretSecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<A> withNewTsigSecretSecretRef() {
    return new ACMEIssuerDNS01ProviderRFC2136FluentImpl.TsigSecretSecretRefNestedImpl();
  }
  public ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<A> withNewTsigSecretSecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerDNS01ProviderRFC2136FluentImpl.TsigSecretSecretRefNestedImpl(item);
  }
  public ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<A> editTsigSecretSecretRef() {
    return withNewTsigSecretSecretRefLike(getTsigSecretSecretRef());
  }
  public ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<A> editOrNewTsigSecretSecretRef() {
    return withNewTsigSecretSecretRefLike(getTsigSecretSecretRef() != null ? getTsigSecretSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<A> editOrNewTsigSecretSecretRefLike(SecretKeySelector item) {
    return withNewTsigSecretSecretRefLike(getTsigSecretSecretRef() != null ? getTsigSecretSecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerDNS01ProviderRFC2136FluentImpl that = (ACMEIssuerDNS01ProviderRFC2136FluentImpl) o;
    if (nameserver != null ? !nameserver.equals(that.nameserver) :that.nameserver != null) return false;
    if (tsigAlgorithm != null ? !tsigAlgorithm.equals(that.tsigAlgorithm) :that.tsigAlgorithm != null) return false;
    if (tsigKeyName != null ? !tsigKeyName.equals(that.tsigKeyName) :that.tsigKeyName != null) return false;
    if (tsigSecretSecretRef != null ? !tsigSecretSecretRef.equals(that.tsigSecretSecretRef) :that.tsigSecretSecretRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nameserver,  tsigAlgorithm,  tsigKeyName,  tsigSecretSecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nameserver != null) { sb.append("nameserver:"); sb.append(nameserver + ","); }
    if (tsigAlgorithm != null) { sb.append("tsigAlgorithm:"); sb.append(tsigAlgorithm + ","); }
    if (tsigKeyName != null) { sb.append("tsigKeyName:"); sb.append(tsigKeyName + ","); }
    if (tsigSecretSecretRef != null) { sb.append("tsigSecretSecretRef:"); sb.append(tsigSecretSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  class TsigSecretSecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<N>> implements ACMEIssuerDNS01ProviderRFC2136Fluent.TsigSecretSecretRefNested<N>,Nested<N>{
    TsigSecretSecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    TsigSecretSecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRFC2136FluentImpl.this.withTsigSecretSecretRef(builder.build());
    }
    public N endTsigSecretSecretRef() {
      return and();
    }
    
  }
  
}