package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ACMEIssuerFluent<A extends ACMEIssuerFluent<A>> extends Fluent<A>{
  public Boolean getDisableAccountKeyGeneration();
  public A withDisableAccountKeyGeneration(Boolean disableAccountKeyGeneration);
  public Boolean hasDisableAccountKeyGeneration();
  public String getEmail();
  public A withEmail(String email);
  public Boolean hasEmail();
  public Boolean getEnableDurationFeature();
  public A withEnableDurationFeature(Boolean enableDurationFeature);
  public Boolean hasEnableDurationFeature();
  
  /**
   * This method has been deprecated, please use method buildExternalAccountBinding instead.
   * @return The buildable object.
   */
  @Deprecated
  public ACMEExternalAccountBinding getExternalAccountBinding();
  public ACMEExternalAccountBinding buildExternalAccountBinding();
  public A withExternalAccountBinding(ACMEExternalAccountBinding externalAccountBinding);
  public Boolean hasExternalAccountBinding();
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBinding();
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBindingLike(ACMEExternalAccountBinding item);
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> editExternalAccountBinding();
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBinding();
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBindingLike(ACMEExternalAccountBinding item);
  public String getPreferredChain();
  public A withPreferredChain(String preferredChain);
  public Boolean hasPreferredChain();
  
  /**
   * This method has been deprecated, please use method buildPrivateKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getPrivateKeySecretRef();
  public SecretKeySelector buildPrivateKeySecretRef();
  public A withPrivateKeySecretRef(SecretKeySelector privateKeySecretRef);
  public Boolean hasPrivateKeySecretRef();
  public A withNewPrivateKeySecretRef(String key,String name);
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRef();
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRefLike(SecretKeySelector item);
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editPrivateKeySecretRef();
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRef();
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRefLike(SecretKeySelector item);
  public String getServer();
  public A withServer(String server);
  public Boolean hasServer();
  public Boolean getSkipTLSVerify();
  public A withSkipTLSVerify(Boolean skipTLSVerify);
  public Boolean hasSkipTLSVerify();
  public A addToSolvers(Integer index,ACMEChallengeSolver item);
  public A setToSolvers(Integer index,ACMEChallengeSolver item);
  public A addToSolvers(io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolver... items);
  public A addAllToSolvers(Collection<ACMEChallengeSolver> items);
  public A removeFromSolvers(io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolver... items);
  public A removeAllFromSolvers(Collection<ACMEChallengeSolver> items);
  public A removeMatchingFromSolvers(Predicate<ACMEChallengeSolverBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSolvers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ACMEChallengeSolver> getSolvers();
  public List<ACMEChallengeSolver> buildSolvers();
  public ACMEChallengeSolver buildSolver(Integer index);
  public ACMEChallengeSolver buildFirstSolver();
  public ACMEChallengeSolver buildLastSolver();
  public ACMEChallengeSolver buildMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate);
  public Boolean hasMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate);
  public A withSolvers(List<ACMEChallengeSolver> solvers);
  public A withSolvers(io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolver... solvers);
  public Boolean hasSolvers();
  public ACMEIssuerFluent.SolversNested<A> addNewSolver();
  public ACMEIssuerFluent.SolversNested<A> addNewSolverLike(ACMEChallengeSolver item);
  public ACMEIssuerFluent.SolversNested<A> setNewSolverLike(Integer index,ACMEChallengeSolver item);
  public ACMEIssuerFluent.SolversNested<A> editSolver(Integer index);
  public ACMEIssuerFluent.SolversNested<A> editFirstSolver();
  public ACMEIssuerFluent.SolversNested<A> editLastSolver();
  public ACMEIssuerFluent.SolversNested<A> editMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate);
  public A withDisableAccountKeyGeneration();
  public A withEnableDurationFeature();
  public A withSkipTLSVerify();
  public interface ExternalAccountBindingNested<N> extends Nested<N>,ACMEExternalAccountBindingFluent<ACMEIssuerFluent.ExternalAccountBindingNested<N>>{
    public N and();
    public N endExternalAccountBinding();
    
  }
  public interface PrivateKeySecretRefNested<N> extends Nested<N>,SecretKeySelectorFluent<ACMEIssuerFluent.PrivateKeySecretRefNested<N>>{
    public N and();
    public N endPrivateKeySecretRef();
    
  }
  public interface SolversNested<N> extends Nested<N>,ACMEChallengeSolverFluent<ACMEIssuerFluent.SolversNested<N>>{
    public N and();
    public N endSolver();
    
  }
  
}