package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OrderSpecBuilder extends OrderSpecFluentImpl<OrderSpecBuilder> implements VisitableBuilder<OrderSpec,OrderSpecBuilder>{
  public OrderSpecBuilder() {
    this(false);
  }
  public OrderSpecBuilder(Boolean validationEnabled) {
    this(new OrderSpec(), validationEnabled);
  }
  public OrderSpecBuilder(OrderSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OrderSpecBuilder(OrderSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OrderSpec(), validationEnabled);
  }
  public OrderSpecBuilder(OrderSpecFluent<?> fluent,OrderSpec instance) {
    this(fluent, instance, false);
  }
  public OrderSpecBuilder(OrderSpecFluent<?> fluent,OrderSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommonName(instance.getCommonName()); 
    fluent.withDnsNames(instance.getDnsNames()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withIpAddresses(instance.getIpAddresses()); 
    fluent.withIssuerRef(instance.getIssuerRef()); 
    fluent.withRequest(instance.getRequest()); 
    this.validationEnabled = validationEnabled; 
  }
  public OrderSpecBuilder(OrderSpec instance) {
    this(instance,false);
  }
  public OrderSpecBuilder(OrderSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommonName(instance.getCommonName()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withRequest(instance.getRequest()); 
    this.validationEnabled = validationEnabled; 
  }
  OrderSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OrderSpec build() {
    OrderSpec buildable = new OrderSpec(fluent.getCommonName(),fluent.getDnsNames(),fluent.getDuration(),fluent.getIpAddresses(),fluent.getIssuerRef(),fluent.getRequest());
    return buildable;
  }
  
}