package io.fabric8.certmanager.api.model.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CAIssuerFluentImpl<A extends CAIssuerFluent<A>> extends BaseFluent<A> implements CAIssuerFluent<A>{
  public CAIssuerFluentImpl() {
  }
  public CAIssuerFluentImpl(CAIssuer instance) {
    this.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    this.withOcspServers(instance.getOcspServers()); 
    this.withSecretName(instance.getSecretName()); 
  }
  private List<String> crlDistributionPoints = new ArrayList<String>();
  private List<String> ocspServers = new ArrayList<String>();
  private String secretName;
  public A addToCrlDistributionPoints(Integer index,String item) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    this.crlDistributionPoints.add(index, item);
    return (A)this;
  }
  public A setToCrlDistributionPoints(Integer index,String item) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    this.crlDistributionPoints.set(index, item); return (A)this;
  }
  public A addToCrlDistributionPoints(java.lang.String... items) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    for (String item : items) {this.crlDistributionPoints.add(item);} return (A)this;
  }
  public A addAllToCrlDistributionPoints(Collection<String> items) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    for (String item : items) {this.crlDistributionPoints.add(item);} return (A)this;
  }
  public A removeFromCrlDistributionPoints(java.lang.String... items) {
    for (String item : items) {if (this.crlDistributionPoints!= null){ this.crlDistributionPoints.remove(item);}} return (A)this;
  }
  public A removeAllFromCrlDistributionPoints(Collection<String> items) {
    for (String item : items) {if (this.crlDistributionPoints!= null){ this.crlDistributionPoints.remove(item);}} return (A)this;
  }
  public List<String> getCrlDistributionPoints() {
    return this.crlDistributionPoints;
  }
  public String getCrlDistributionPoint(Integer index) {
    return this.crlDistributionPoints.get(index);
  }
  public String getFirstCrlDistributionPoint() {
    return this.crlDistributionPoints.get(0);
  }
  public String getLastCrlDistributionPoint() {
    return this.crlDistributionPoints.get(crlDistributionPoints.size() - 1);
  }
  public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
    for (String item: crlDistributionPoints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
    for (String item: crlDistributionPoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
    if (crlDistributionPoints != null) {this.crlDistributionPoints = new ArrayList(); for (String item : crlDistributionPoints){this.addToCrlDistributionPoints(item);}} else { this.crlDistributionPoints = null;} return (A) this;
  }
  public A withCrlDistributionPoints(java.lang.String... crlDistributionPoints) {
    if (this.crlDistributionPoints != null) {this.crlDistributionPoints.clear();}
    if (crlDistributionPoints != null) {for (String item :crlDistributionPoints){ this.addToCrlDistributionPoints(item);}} return (A) this;
  }
  public Boolean hasCrlDistributionPoints() {
    return crlDistributionPoints != null && !crlDistributionPoints.isEmpty();
  }
  public A addToOcspServers(Integer index,String item) {
    if (this.ocspServers == null) {this.ocspServers = new ArrayList<String>();}
    this.ocspServers.add(index, item);
    return (A)this;
  }
  public A setToOcspServers(Integer index,String item) {
    if (this.ocspServers == null) {this.ocspServers = new ArrayList<String>();}
    this.ocspServers.set(index, item); return (A)this;
  }
  public A addToOcspServers(java.lang.String... items) {
    if (this.ocspServers == null) {this.ocspServers = new ArrayList<String>();}
    for (String item : items) {this.ocspServers.add(item);} return (A)this;
  }
  public A addAllToOcspServers(Collection<String> items) {
    if (this.ocspServers == null) {this.ocspServers = new ArrayList<String>();}
    for (String item : items) {this.ocspServers.add(item);} return (A)this;
  }
  public A removeFromOcspServers(java.lang.String... items) {
    for (String item : items) {if (this.ocspServers!= null){ this.ocspServers.remove(item);}} return (A)this;
  }
  public A removeAllFromOcspServers(Collection<String> items) {
    for (String item : items) {if (this.ocspServers!= null){ this.ocspServers.remove(item);}} return (A)this;
  }
  public List<String> getOcspServers() {
    return this.ocspServers;
  }
  public String getOcspServer(Integer index) {
    return this.ocspServers.get(index);
  }
  public String getFirstOcspServer() {
    return this.ocspServers.get(0);
  }
  public String getLastOcspServer() {
    return this.ocspServers.get(ocspServers.size() - 1);
  }
  public String getMatchingOcspServer(Predicate<String> predicate) {
    for (String item: ocspServers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOcspServer(Predicate<String> predicate) {
    for (String item: ocspServers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOcspServers(List<String> ocspServers) {
    if (ocspServers != null) {this.ocspServers = new ArrayList(); for (String item : ocspServers){this.addToOcspServers(item);}} else { this.ocspServers = null;} return (A) this;
  }
  public A withOcspServers(java.lang.String... ocspServers) {
    if (this.ocspServers != null) {this.ocspServers.clear();}
    if (ocspServers != null) {for (String item :ocspServers){ this.addToOcspServers(item);}} return (A) this;
  }
  public Boolean hasOcspServers() {
    return ocspServers != null && !ocspServers.isEmpty();
  }
  public String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public Boolean hasSecretName() {
    return this.secretName != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CAIssuerFluentImpl that = (CAIssuerFluentImpl) o;
    if (crlDistributionPoints != null ? !crlDistributionPoints.equals(that.crlDistributionPoints) :that.crlDistributionPoints != null) return false;
    if (ocspServers != null ? !ocspServers.equals(that.ocspServers) :that.ocspServers != null) return false;
    if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(crlDistributionPoints,  ocspServers,  secretName,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (crlDistributionPoints != null && !crlDistributionPoints.isEmpty()) { sb.append("crlDistributionPoints:"); sb.append(crlDistributionPoints + ","); }
    if (ocspServers != null && !ocspServers.isEmpty()) { sb.append("ocspServers:"); sb.append(ocspServers + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName); }
    sb.append("}");
    return sb.toString();
  }
  
}