package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificatePrivateKeyBuilder extends CertificatePrivateKeyFluentImpl<CertificatePrivateKeyBuilder> implements VisitableBuilder<CertificatePrivateKey,CertificatePrivateKeyBuilder>{
  public CertificatePrivateKeyBuilder() {
    this(false);
  }
  public CertificatePrivateKeyBuilder(Boolean validationEnabled) {
    this(new CertificatePrivateKey(), validationEnabled);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificatePrivateKey(), validationEnabled);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent,CertificatePrivateKey instance) {
    this(fluent, instance, false);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent,CertificatePrivateKey instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlgorithm(instance.getAlgorithm()); 
    fluent.withEncoding(instance.getEncoding()); 
    fluent.withRotationPolicy(instance.getRotationPolicy()); 
    fluent.withSize(instance.getSize()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKey instance) {
    this(instance,false);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKey instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlgorithm(instance.getAlgorithm()); 
    this.withEncoding(instance.getEncoding()); 
    this.withRotationPolicy(instance.getRotationPolicy()); 
    this.withSize(instance.getSize()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificatePrivateKeyFluent<?> fluent;
  Boolean validationEnabled;
  public CertificatePrivateKey build() {
    CertificatePrivateKey buildable = new CertificatePrivateKey(fluent.getAlgorithm(),fluent.getEncoding(),fluent.getRotationPolicy(),fluent.getSize());
    return buildable;
  }
  
}