package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSpecBuilder extends CertificateSpecFluentImpl<CertificateSpecBuilder> implements VisitableBuilder<CertificateSpec,CertificateSpecBuilder>{
  public CertificateSpecBuilder() {
    this(false);
  }
  public CertificateSpecBuilder(Boolean validationEnabled) {
    this(new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalOutputFormats(instance.getAdditionalOutputFormats()); 
    fluent.withCommonName(instance.getCommonName()); 
    fluent.withDnsNames(instance.getDnsNames()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withEmailAddresses(instance.getEmailAddresses()); 
    fluent.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    fluent.withIpAddresses(instance.getIpAddresses()); 
    fluent.withIsCA(instance.getIsCA()); 
    fluent.withIssuerRef(instance.getIssuerRef()); 
    fluent.withKeystores(instance.getKeystores()); 
    fluent.withLiteralSubject(instance.getLiteralSubject()); 
    fluent.withPrivateKey(instance.getPrivateKey()); 
    fluent.withRenewBefore(instance.getRenewBefore()); 
    fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withSecretTemplate(instance.getSecretTemplate()); 
    fluent.withSubject(instance.getSubject()); 
    fluent.withUris(instance.getUris()); 
    fluent.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSpecBuilder(CertificateSpec instance) {
    this(instance,false);
  }
  public CertificateSpecBuilder(CertificateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalOutputFormats(instance.getAdditionalOutputFormats()); 
    this.withCommonName(instance.getCommonName()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withEmailAddresses(instance.getEmailAddresses()); 
    this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withKeystores(instance.getKeystores()); 
    this.withLiteralSubject(instance.getLiteralSubject()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withRenewBefore(instance.getRenewBefore()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSecretName(instance.getSecretName()); 
    this.withSecretTemplate(instance.getSecretTemplate()); 
    this.withSubject(instance.getSubject()); 
    this.withUris(instance.getUris()); 
    this.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSpec build() {
    CertificateSpec buildable = new CertificateSpec(fluent.getAdditionalOutputFormats(),fluent.getCommonName(),fluent.getDnsNames(),fluent.getDuration(),fluent.getEmailAddresses(),fluent.getEncodeUsagesInRequest(),fluent.getIpAddresses(),fluent.getIsCA(),fluent.getIssuerRef(),fluent.getKeystores(),fluent.getLiteralSubject(),fluent.getPrivateKey(),fluent.getRenewBefore(),fluent.getRevisionHistoryLimit(),fluent.getSecretName(),fluent.getSecretTemplate(),fluent.getSubject(),fluent.getUris(),fluent.getUsages());
    return buildable;
  }
  
}