package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSpecFluentImpl<A extends CertificateSpecFluent<A>> extends BaseFluent<A> implements CertificateSpecFluent<A>{
  public CertificateSpecFluentImpl() {
  }
  public CertificateSpecFluentImpl(CertificateSpec instance) {
    this.withAdditionalOutputFormats(instance.getAdditionalOutputFormats()); 
    this.withCommonName(instance.getCommonName()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withEmailAddresses(instance.getEmailAddresses()); 
    this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withKeystores(instance.getKeystores()); 
    this.withLiteralSubject(instance.getLiteralSubject()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withRenewBefore(instance.getRenewBefore()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSecretName(instance.getSecretName()); 
    this.withSecretTemplate(instance.getSecretTemplate()); 
    this.withSubject(instance.getSubject()); 
    this.withUris(instance.getUris()); 
    this.withUsages(instance.getUsages()); 
  }
  private ArrayList<CertificateAdditionalOutputFormatBuilder> additionalOutputFormats = new ArrayList<CertificateAdditionalOutputFormatBuilder>();
  private String commonName;
  private List<String> dnsNames = new ArrayList<String>();
  private Duration duration;
  private List<String> emailAddresses = new ArrayList<String>();
  private Boolean encodeUsagesInRequest;
  private List<String> ipAddresses = new ArrayList<String>();
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private CertificateKeystoresBuilder keystores;
  private String literalSubject;
  private CertificatePrivateKeyBuilder privateKey;
  private Duration renewBefore;
  private Integer revisionHistoryLimit;
  private String secretName;
  private CertificateSecretTemplateBuilder secretTemplate;
  private X509SubjectBuilder subject;
  private List<String> uris = new ArrayList<String>();
  private List<String> usages = new ArrayList<String>();
  public A addToAdditionalOutputFormats(Integer index,CertificateAdditionalOutputFormat item) {
    if (this.additionalOutputFormats == null) {this.additionalOutputFormats = new ArrayList<CertificateAdditionalOutputFormatBuilder>();}
    CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);_visitables.get("additionalOutputFormats").add(index >= 0 ? index : _visitables.get("additionalOutputFormats").size(), builder);this.additionalOutputFormats.add(index >= 0 ? index : additionalOutputFormats.size(), builder); return (A)this;
  }
  public A setToAdditionalOutputFormats(Integer index,CertificateAdditionalOutputFormat item) {
    if (this.additionalOutputFormats == null) {this.additionalOutputFormats = new ArrayList<CertificateAdditionalOutputFormatBuilder>();}
    CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalOutputFormats").size()) { _visitables.get("additionalOutputFormats").add(builder); } else { _visitables.get("additionalOutputFormats").set(index, builder);}
    if (index < 0 || index >= additionalOutputFormats.size()) { additionalOutputFormats.add(builder); } else { additionalOutputFormats.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalOutputFormats(io.fabric8.certmanager.api.model.v1.CertificateAdditionalOutputFormat... items) {
    if (this.additionalOutputFormats == null) {this.additionalOutputFormats = new ArrayList<CertificateAdditionalOutputFormatBuilder>();}
    for (CertificateAdditionalOutputFormat item : items) {CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);_visitables.get("additionalOutputFormats").add(builder);this.additionalOutputFormats.add(builder);} return (A)this;
  }
  public A addAllToAdditionalOutputFormats(Collection<CertificateAdditionalOutputFormat> items) {
    if (this.additionalOutputFormats == null) {this.additionalOutputFormats = new ArrayList<CertificateAdditionalOutputFormatBuilder>();}
    for (CertificateAdditionalOutputFormat item : items) {CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);_visitables.get("additionalOutputFormats").add(builder);this.additionalOutputFormats.add(builder);} return (A)this;
  }
  public A removeFromAdditionalOutputFormats(io.fabric8.certmanager.api.model.v1.CertificateAdditionalOutputFormat... items) {
    for (CertificateAdditionalOutputFormat item : items) {CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);_visitables.get("additionalOutputFormats").remove(builder);if (this.additionalOutputFormats != null) {this.additionalOutputFormats.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalOutputFormats(Collection<CertificateAdditionalOutputFormat> items) {
    for (CertificateAdditionalOutputFormat item : items) {CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);_visitables.get("additionalOutputFormats").remove(builder);if (this.additionalOutputFormats != null) {this.additionalOutputFormats.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalOutputFormats(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
    if (additionalOutputFormats == null) return (A) this;
    final Iterator<CertificateAdditionalOutputFormatBuilder> each = additionalOutputFormats.iterator();
    final List visitables = _visitables.get("additionalOutputFormats");
    while (each.hasNext()) {
      CertificateAdditionalOutputFormatBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalOutputFormats instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateAdditionalOutputFormat> getAdditionalOutputFormats() {
    return additionalOutputFormats != null ? build(additionalOutputFormats) : null;
  }
  public List<CertificateAdditionalOutputFormat> buildAdditionalOutputFormats() {
    return additionalOutputFormats != null ? build(additionalOutputFormats) : null;
  }
  public CertificateAdditionalOutputFormat buildAdditionalOutputFormat(Integer index) {
    return this.additionalOutputFormats.get(index).build();
  }
  public CertificateAdditionalOutputFormat buildFirstAdditionalOutputFormat() {
    return this.additionalOutputFormats.get(0).build();
  }
  public CertificateAdditionalOutputFormat buildLastAdditionalOutputFormat() {
    return this.additionalOutputFormats.get(additionalOutputFormats.size() - 1).build();
  }
  public CertificateAdditionalOutputFormat buildMatchingAdditionalOutputFormat(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
    for (CertificateAdditionalOutputFormatBuilder item: additionalOutputFormats) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalOutputFormat(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
    for (CertificateAdditionalOutputFormatBuilder item: additionalOutputFormats) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalOutputFormats(List<CertificateAdditionalOutputFormat> additionalOutputFormats) {
    if (this.additionalOutputFormats != null) { _visitables.get("additionalOutputFormats").removeAll(this.additionalOutputFormats);}
    if (additionalOutputFormats != null) {this.additionalOutputFormats = new ArrayList(); for (CertificateAdditionalOutputFormat item : additionalOutputFormats){this.addToAdditionalOutputFormats(item);}} else { this.additionalOutputFormats = null;} return (A) this;
  }
  public A withAdditionalOutputFormats(io.fabric8.certmanager.api.model.v1.CertificateAdditionalOutputFormat... additionalOutputFormats) {
    if (this.additionalOutputFormats != null) {this.additionalOutputFormats.clear();}
    if (additionalOutputFormats != null) {for (CertificateAdditionalOutputFormat item :additionalOutputFormats){ this.addToAdditionalOutputFormats(item);}} return (A) this;
  }
  public Boolean hasAdditionalOutputFormats() {
    return additionalOutputFormats != null && !additionalOutputFormats.isEmpty();
  }
  public A addNewAdditionalOutputFormat(String type) {
    return (A)addToAdditionalOutputFormats(new CertificateAdditionalOutputFormat(type));
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> addNewAdditionalOutputFormat() {
    return new CertificateSpecFluentImpl.AdditionalOutputFormatsNestedImpl();
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> addNewAdditionalOutputFormatLike(CertificateAdditionalOutputFormat item) {
    return new CertificateSpecFluentImpl.AdditionalOutputFormatsNestedImpl(-1, item);
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> setNewAdditionalOutputFormatLike(Integer index,CertificateAdditionalOutputFormat item) {
    return new CertificateSpecFluentImpl.AdditionalOutputFormatsNestedImpl(index, item);
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> editAdditionalOutputFormat(Integer index) {
    if (additionalOutputFormats.size() <= index) throw new RuntimeException("Can't edit additionalOutputFormats. Index exceeds size.");
    return setNewAdditionalOutputFormatLike(index, buildAdditionalOutputFormat(index));
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> editFirstAdditionalOutputFormat() {
    if (additionalOutputFormats.size() == 0) throw new RuntimeException("Can't edit first additionalOutputFormats. The list is empty.");
    return setNewAdditionalOutputFormatLike(0, buildAdditionalOutputFormat(0));
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> editLastAdditionalOutputFormat() {
    int index = additionalOutputFormats.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalOutputFormats. The list is empty.");
    return setNewAdditionalOutputFormatLike(index, buildAdditionalOutputFormat(index));
  }
  public CertificateSpecFluent.AdditionalOutputFormatsNested<A> editMatchingAdditionalOutputFormat(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalOutputFormats.size();i++) { 
    if (predicate.test(additionalOutputFormats.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalOutputFormats. No match found.");
    return setNewAdditionalOutputFormatLike(index, buildAdditionalOutputFormat(index));
  }
  public String getCommonName() {
    return this.commonName;
  }
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  public Boolean hasCommonName() {
    return this.commonName != null;
  }
  public A addToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(Integer index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear();}
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public Boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToEmailAddresses(Integer index,String item) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    this.emailAddresses.add(index, item);
    return (A)this;
  }
  public A setToEmailAddresses(Integer index,String item) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    this.emailAddresses.set(index, item); return (A)this;
  }
  public A addToEmailAddresses(java.lang.String... items) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    for (String item : items) {this.emailAddresses.add(item);} return (A)this;
  }
  public A addAllToEmailAddresses(Collection<String> items) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    for (String item : items) {this.emailAddresses.add(item);} return (A)this;
  }
  public A removeFromEmailAddresses(java.lang.String... items) {
    for (String item : items) {if (this.emailAddresses!= null){ this.emailAddresses.remove(item);}} return (A)this;
  }
  public A removeAllFromEmailAddresses(Collection<String> items) {
    for (String item : items) {if (this.emailAddresses!= null){ this.emailAddresses.remove(item);}} return (A)this;
  }
  public List<String> getEmailAddresses() {
    return this.emailAddresses;
  }
  public String getEmailAddress(Integer index) {
    return this.emailAddresses.get(index);
  }
  public String getFirstEmailAddress() {
    return this.emailAddresses.get(0);
  }
  public String getLastEmailAddress() {
    return this.emailAddresses.get(emailAddresses.size() - 1);
  }
  public String getMatchingEmailAddress(Predicate<String> predicate) {
    for (String item: emailAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEmailAddress(Predicate<String> predicate) {
    for (String item: emailAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEmailAddresses(List<String> emailAddresses) {
    if (emailAddresses != null) {this.emailAddresses = new ArrayList(); for (String item : emailAddresses){this.addToEmailAddresses(item);}} else { this.emailAddresses = null;} return (A) this;
  }
  public A withEmailAddresses(java.lang.String... emailAddresses) {
    if (this.emailAddresses != null) {this.emailAddresses.clear();}
    if (emailAddresses != null) {for (String item :emailAddresses){ this.addToEmailAddresses(item);}} return (A) this;
  }
  public Boolean hasEmailAddresses() {
    return emailAddresses != null && !emailAddresses.isEmpty();
  }
  public Boolean getEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest;
  }
  public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
    this.encodeUsagesInRequest=encodeUsagesInRequest; return (A) this;
  }
  public Boolean hasEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest != null;
  }
  public A addToIpAddresses(Integer index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.add(index, item);
    return (A)this;
  }
  public A setToIpAddresses(Integer index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.set(index, item); return (A)this;
  }
  public A addToIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A addAllToIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A removeFromIpAddresses(java.lang.String... items) {
    for (String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public A removeAllFromIpAddresses(Collection<String> items) {
    for (String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public List<String> getIpAddresses() {
    return this.ipAddresses;
  }
  public String getIpAddress(Integer index) {
    return this.ipAddresses.get(index);
  }
  public String getFirstIpAddress() {
    return this.ipAddresses.get(0);
  }
  public String getLastIpAddress() {
    return this.ipAddresses.get(ipAddresses.size() - 1);
  }
  public String getMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpAddresses(List<String> ipAddresses) {
    if (ipAddresses != null) {this.ipAddresses = new ArrayList(); for (String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
  }
  public A withIpAddresses(java.lang.String... ipAddresses) {
    if (this.ipAddresses != null) {this.ipAddresses.clear();}
    if (ipAddresses != null) {for (String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
  }
  public Boolean hasIpAddresses() {
    return ipAddresses != null && !ipAddresses.isEmpty();
  }
  public Boolean getIsCA() {
    return this.isCA;
  }
  public A withIsCA(Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  public Boolean hasIsCA() {
    return this.isCA != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
    return new CertificateSpecFluentImpl.IssuerRefNestedImpl();
  }
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new CertificateSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public CertificateSpecFluent.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new ObjectReferenceBuilder().build());
  }
  public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKeystores instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateKeystores getKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public CertificateKeystores buildKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public A withKeystores(CertificateKeystores keystores) {
    _visitables.get("keystores").remove(this.keystores);
    if (keystores!=null){ this.keystores= new CertificateKeystoresBuilder(keystores); _visitables.get("keystores").add(this.keystores);} else { this.keystores = null; _visitables.get("keystores").remove(this.keystores); } return (A) this;
  }
  public Boolean hasKeystores() {
    return this.keystores != null;
  }
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystores() {
    return new CertificateSpecFluentImpl.KeystoresNestedImpl();
  }
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
    return new CertificateSpecFluentImpl.KeystoresNestedImpl(item);
  }
  public CertificateSpecFluent.KeystoresNested<A> editKeystores() {
    return withNewKeystoresLike(getKeystores());
  }
  public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystores() {
    return withNewKeystoresLike(getKeystores() != null ? getKeystores(): new CertificateKeystoresBuilder().build());
  }
  public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
    return withNewKeystoresLike(getKeystores() != null ? getKeystores(): item);
  }
  public String getLiteralSubject() {
    return this.literalSubject;
  }
  public A withLiteralSubject(String literalSubject) {
    this.literalSubject=literalSubject; return (A) this;
  }
  public Boolean hasLiteralSubject() {
    return this.literalSubject != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateKey instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificatePrivateKey getPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public CertificatePrivateKey buildPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public A withPrivateKey(CertificatePrivateKey privateKey) {
    _visitables.get("privateKey").remove(this.privateKey);
    if (privateKey!=null){ this.privateKey= new CertificatePrivateKeyBuilder(privateKey); _visitables.get("privateKey").add(this.privateKey);} else { this.privateKey = null; _visitables.get("privateKey").remove(this.privateKey); } return (A) this;
  }
  public Boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public A withNewPrivateKey(String algorithm,String encoding,String rotationPolicy,Integer size) {
    return (A)withPrivateKey(new CertificatePrivateKey(algorithm, encoding, rotationPolicy, size));
  }
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKey() {
    return new CertificateSpecFluentImpl.PrivateKeyNestedImpl();
  }
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
    return new CertificateSpecFluentImpl.PrivateKeyNestedImpl(item);
  }
  public CertificateSpecFluent.PrivateKeyNested<A> editPrivateKey() {
    return withNewPrivateKeyLike(getPrivateKey());
  }
  public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKey() {
    return withNewPrivateKeyLike(getPrivateKey() != null ? getPrivateKey(): new CertificatePrivateKeyBuilder().build());
  }
  public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
    return withNewPrivateKeyLike(getPrivateKey() != null ? getPrivateKey(): item);
  }
  public Duration getRenewBefore() {
    return this.renewBefore;
  }
  public A withRenewBefore(Duration renewBefore) {
    this.renewBefore=renewBefore; return (A) this;
  }
  public Boolean hasRenewBefore() {
    return this.renewBefore != null;
  }
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public Boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  public String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public Boolean hasSecretName() {
    return this.secretName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateSecretTemplate getSecretTemplate() {
    return this.secretTemplate!=null ?this.secretTemplate.build():null;
  }
  public CertificateSecretTemplate buildSecretTemplate() {
    return this.secretTemplate!=null ?this.secretTemplate.build():null;
  }
  public A withSecretTemplate(CertificateSecretTemplate secretTemplate) {
    _visitables.get("secretTemplate").remove(this.secretTemplate);
    if (secretTemplate!=null){ this.secretTemplate= new CertificateSecretTemplateBuilder(secretTemplate); _visitables.get("secretTemplate").add(this.secretTemplate);} else { this.secretTemplate = null; _visitables.get("secretTemplate").remove(this.secretTemplate); } return (A) this;
  }
  public Boolean hasSecretTemplate() {
    return this.secretTemplate != null;
  }
  public CertificateSpecFluent.SecretTemplateNested<A> withNewSecretTemplate() {
    return new CertificateSpecFluentImpl.SecretTemplateNestedImpl();
  }
  public CertificateSpecFluent.SecretTemplateNested<A> withNewSecretTemplateLike(CertificateSecretTemplate item) {
    return new CertificateSpecFluentImpl.SecretTemplateNestedImpl(item);
  }
  public CertificateSpecFluent.SecretTemplateNested<A> editSecretTemplate() {
    return withNewSecretTemplateLike(getSecretTemplate());
  }
  public CertificateSpecFluent.SecretTemplateNested<A> editOrNewSecretTemplate() {
    return withNewSecretTemplateLike(getSecretTemplate() != null ? getSecretTemplate(): new CertificateSecretTemplateBuilder().build());
  }
  public CertificateSpecFluent.SecretTemplateNested<A> editOrNewSecretTemplateLike(CertificateSecretTemplate item) {
    return withNewSecretTemplateLike(getSecretTemplate() != null ? getSecretTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSubject instead.
   * @return The buildable object.
   */
  @Deprecated
  public X509Subject getSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public X509Subject buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public A withSubject(X509Subject subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new X509SubjectBuilder(subject); _visitables.get("subject").add(this.subject);} else { this.subject = null; _visitables.get("subject").remove(this.subject); } return (A) this;
  }
  public Boolean hasSubject() {
    return this.subject != null;
  }
  public CertificateSpecFluent.SubjectNested<A> withNewSubject() {
    return new CertificateSpecFluentImpl.SubjectNestedImpl();
  }
  public CertificateSpecFluent.SubjectNested<A> withNewSubjectLike(X509Subject item) {
    return new CertificateSpecFluentImpl.SubjectNestedImpl(item);
  }
  public CertificateSpecFluent.SubjectNested<A> editSubject() {
    return withNewSubjectLike(getSubject());
  }
  public CertificateSpecFluent.SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(getSubject() != null ? getSubject(): new X509SubjectBuilder().build());
  }
  public CertificateSpecFluent.SubjectNested<A> editOrNewSubjectLike(X509Subject item) {
    return withNewSubjectLike(getSubject() != null ? getSubject(): item);
  }
  public A addToUris(Integer index,String item) {
    if (this.uris == null) {this.uris = new ArrayList<String>();}
    this.uris.add(index, item);
    return (A)this;
  }
  public A setToUris(Integer index,String item) {
    if (this.uris == null) {this.uris = new ArrayList<String>();}
    this.uris.set(index, item); return (A)this;
  }
  public A addToUris(java.lang.String... items) {
    if (this.uris == null) {this.uris = new ArrayList<String>();}
    for (String item : items) {this.uris.add(item);} return (A)this;
  }
  public A addAllToUris(Collection<String> items) {
    if (this.uris == null) {this.uris = new ArrayList<String>();}
    for (String item : items) {this.uris.add(item);} return (A)this;
  }
  public A removeFromUris(java.lang.String... items) {
    for (String item : items) {if (this.uris!= null){ this.uris.remove(item);}} return (A)this;
  }
  public A removeAllFromUris(Collection<String> items) {
    for (String item : items) {if (this.uris!= null){ this.uris.remove(item);}} return (A)this;
  }
  public List<String> getUris() {
    return this.uris;
  }
  public String getUri(Integer index) {
    return this.uris.get(index);
  }
  public String getFirstUri() {
    return this.uris.get(0);
  }
  public String getLastUri() {
    return this.uris.get(uris.size() - 1);
  }
  public String getMatchingUri(Predicate<String> predicate) {
    for (String item: uris) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUri(Predicate<String> predicate) {
    for (String item: uris) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUris(List<String> uris) {
    if (uris != null) {this.uris = new ArrayList(); for (String item : uris){this.addToUris(item);}} else { this.uris = null;} return (A) this;
  }
  public A withUris(java.lang.String... uris) {
    if (this.uris != null) {this.uris.clear();}
    if (uris != null) {for (String item :uris){ this.addToUris(item);}} return (A) this;
  }
  public Boolean hasUris() {
    return uris != null && !uris.isEmpty();
  }
  public A addToUsages(Integer index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(Integer index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public A removeAllFromUsages(Collection<String> items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public List<String> getUsages() {
    return this.usages;
  }
  public String getUsage(Integer index) {
    return this.usages.get(index);
  }
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear();}
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public Boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateSpecFluentImpl that = (CertificateSpecFluentImpl) o;
    if (additionalOutputFormats != null ? !additionalOutputFormats.equals(that.additionalOutputFormats) :that.additionalOutputFormats != null) return false;
    if (commonName != null ? !commonName.equals(that.commonName) :that.commonName != null) return false;
    if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (emailAddresses != null ? !emailAddresses.equals(that.emailAddresses) :that.emailAddresses != null) return false;
    if (encodeUsagesInRequest != null ? !encodeUsagesInRequest.equals(that.encodeUsagesInRequest) :that.encodeUsagesInRequest != null) return false;
    if (ipAddresses != null ? !ipAddresses.equals(that.ipAddresses) :that.ipAddresses != null) return false;
    if (isCA != null ? !isCA.equals(that.isCA) :that.isCA != null) return false;
    if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
    if (keystores != null ? !keystores.equals(that.keystores) :that.keystores != null) return false;
    if (literalSubject != null ? !literalSubject.equals(that.literalSubject) :that.literalSubject != null) return false;
    if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
    if (renewBefore != null ? !renewBefore.equals(that.renewBefore) :that.renewBefore != null) return false;
    if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
    if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
    if (secretTemplate != null ? !secretTemplate.equals(that.secretTemplate) :that.secretTemplate != null) return false;
    if (subject != null ? !subject.equals(that.subject) :that.subject != null) return false;
    if (uris != null ? !uris.equals(that.uris) :that.uris != null) return false;
    if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalOutputFormats,  commonName,  dnsNames,  duration,  emailAddresses,  encodeUsagesInRequest,  ipAddresses,  isCA,  issuerRef,  keystores,  literalSubject,  privateKey,  renewBefore,  revisionHistoryLimit,  secretName,  secretTemplate,  subject,  uris,  usages,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalOutputFormats != null && !additionalOutputFormats.isEmpty()) { sb.append("additionalOutputFormats:"); sb.append(additionalOutputFormats + ","); }
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (emailAddresses != null && !emailAddresses.isEmpty()) { sb.append("emailAddresses:"); sb.append(emailAddresses + ","); }
    if (encodeUsagesInRequest != null) { sb.append("encodeUsagesInRequest:"); sb.append(encodeUsagesInRequest + ","); }
    if (ipAddresses != null && !ipAddresses.isEmpty()) { sb.append("ipAddresses:"); sb.append(ipAddresses + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (keystores != null) { sb.append("keystores:"); sb.append(keystores + ","); }
    if (literalSubject != null) { sb.append("literalSubject:"); sb.append(literalSubject + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (renewBefore != null) { sb.append("renewBefore:"); sb.append(renewBefore + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (secretTemplate != null) { sb.append("secretTemplate:"); sb.append(secretTemplate + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject + ","); }
    if (uris != null && !uris.isEmpty()) { sb.append("uris:"); sb.append(uris + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages); }
    sb.append("}");
    return sb.toString();
  }
  public A withEncodeUsagesInRequest() {
    return withEncodeUsagesInRequest(true);
  }
  public A withIsCA() {
    return withIsCA(true);
  }
  class AdditionalOutputFormatsNestedImpl<N> extends CertificateAdditionalOutputFormatFluentImpl<CertificateSpecFluent.AdditionalOutputFormatsNested<N>> implements CertificateSpecFluent.AdditionalOutputFormatsNested<N>,Nested<N>{
    AdditionalOutputFormatsNestedImpl(Integer index,CertificateAdditionalOutputFormat item) {
      this.index = index;
      this.builder = new CertificateAdditionalOutputFormatBuilder(this, item);
    }
    AdditionalOutputFormatsNestedImpl() {
      this.index = -1;
      this.builder = new CertificateAdditionalOutputFormatBuilder(this);
    }
    CertificateAdditionalOutputFormatBuilder builder;
    Integer index;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.setToAdditionalOutputFormats(index,builder.build());
    }
    public N endAdditionalOutputFormat() {
      return and();
    }
    
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<CertificateSpecFluent.IssuerRefNested<N>> implements CertificateSpecFluent.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  class KeystoresNestedImpl<N> extends CertificateKeystoresFluentImpl<CertificateSpecFluent.KeystoresNested<N>> implements CertificateSpecFluent.KeystoresNested<N>,Nested<N>{
    KeystoresNestedImpl(CertificateKeystores item) {
      this.builder = new CertificateKeystoresBuilder(this, item);
    }
    KeystoresNestedImpl() {
      this.builder = new CertificateKeystoresBuilder(this);
    }
    CertificateKeystoresBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withKeystores(builder.build());
    }
    public N endKeystores() {
      return and();
    }
    
  }
  class PrivateKeyNestedImpl<N> extends CertificatePrivateKeyFluentImpl<CertificateSpecFluent.PrivateKeyNested<N>> implements CertificateSpecFluent.PrivateKeyNested<N>,Nested<N>{
    PrivateKeyNestedImpl(CertificatePrivateKey item) {
      this.builder = new CertificatePrivateKeyBuilder(this, item);
    }
    PrivateKeyNestedImpl() {
      this.builder = new CertificatePrivateKeyBuilder(this);
    }
    CertificatePrivateKeyBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withPrivateKey(builder.build());
    }
    public N endPrivateKey() {
      return and();
    }
    
  }
  class SecretTemplateNestedImpl<N> extends CertificateSecretTemplateFluentImpl<CertificateSpecFluent.SecretTemplateNested<N>> implements CertificateSpecFluent.SecretTemplateNested<N>,Nested<N>{
    SecretTemplateNestedImpl(CertificateSecretTemplate item) {
      this.builder = new CertificateSecretTemplateBuilder(this, item);
    }
    SecretTemplateNestedImpl() {
      this.builder = new CertificateSecretTemplateBuilder(this);
    }
    CertificateSecretTemplateBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withSecretTemplate(builder.build());
    }
    public N endSecretTemplate() {
      return and();
    }
    
  }
  class SubjectNestedImpl<N> extends X509SubjectFluentImpl<CertificateSpecFluent.SubjectNested<N>> implements CertificateSpecFluent.SubjectNested<N>,Nested<N>{
    SubjectNestedImpl(X509Subject item) {
      this.builder = new X509SubjectBuilder(this, item);
    }
    SubjectNestedImpl() {
      this.builder = new X509SubjectBuilder(this);
    }
    X509SubjectBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withSubject(builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}