package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuer;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerFluentImpl;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IssuerSpecFluentImpl<A extends IssuerSpecFluent<A>> extends BaseFluent<A> implements IssuerSpecFluent<A>{
  public IssuerSpecFluentImpl() {
  }
  public IssuerSpecFluentImpl(IssuerSpec instance) {
    this.withAcme(instance.getAcme()); 
    this.withCa(instance.getCa()); 
    this.withSelfSigned(instance.getSelfSigned()); 
    this.withVault(instance.getVault()); 
    this.withVenafi(instance.getVenafi()); 
  }
  private ACMEIssuerBuilder acme;
  private CAIssuerBuilder ca;
  private SelfSignedIssuerBuilder selfSigned;
  private VaultIssuerBuilder vault;
  private VenafiIssuerBuilder venafi;
  
  /**
   * This method has been deprecated, please use method buildAcme instead.
   * @return The buildable object.
   */
  @Deprecated
  public ACMEIssuer getAcme() {
    return this.acme!=null ?this.acme.build():null;
  }
  public ACMEIssuer buildAcme() {
    return this.acme!=null ?this.acme.build():null;
  }
  public A withAcme(ACMEIssuer acme) {
    _visitables.get("acme").remove(this.acme);
    if (acme!=null){ this.acme= new ACMEIssuerBuilder(acme); _visitables.get("acme").add(this.acme);} else { this.acme = null; _visitables.get("acme").remove(this.acme); } return (A) this;
  }
  public Boolean hasAcme() {
    return this.acme != null;
  }
  public IssuerSpecFluent.AcmeNested<A> withNewAcme() {
    return new IssuerSpecFluentImpl.AcmeNestedImpl();
  }
  public IssuerSpecFluent.AcmeNested<A> withNewAcmeLike(ACMEIssuer item) {
    return new IssuerSpecFluentImpl.AcmeNestedImpl(item);
  }
  public IssuerSpecFluent.AcmeNested<A> editAcme() {
    return withNewAcmeLike(getAcme());
  }
  public IssuerSpecFluent.AcmeNested<A> editOrNewAcme() {
    return withNewAcmeLike(getAcme() != null ? getAcme(): new ACMEIssuerBuilder().build());
  }
  public IssuerSpecFluent.AcmeNested<A> editOrNewAcmeLike(ACMEIssuer item) {
    return withNewAcmeLike(getAcme() != null ? getAcme(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public CAIssuer getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public CAIssuer buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(CAIssuer ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new CAIssuerBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public IssuerSpecFluent.CaNested<A> withNewCa() {
    return new IssuerSpecFluentImpl.CaNestedImpl();
  }
  public IssuerSpecFluent.CaNested<A> withNewCaLike(CAIssuer item) {
    return new IssuerSpecFluentImpl.CaNestedImpl(item);
  }
  public IssuerSpecFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public IssuerSpecFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new CAIssuerBuilder().build());
  }
  public IssuerSpecFluent.CaNested<A> editOrNewCaLike(CAIssuer item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelfSigned instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelfSignedIssuer getSelfSigned() {
    return this.selfSigned!=null ?this.selfSigned.build():null;
  }
  public SelfSignedIssuer buildSelfSigned() {
    return this.selfSigned!=null ?this.selfSigned.build():null;
  }
  public A withSelfSigned(SelfSignedIssuer selfSigned) {
    _visitables.get("selfSigned").remove(this.selfSigned);
    if (selfSigned!=null){ this.selfSigned= new SelfSignedIssuerBuilder(selfSigned); _visitables.get("selfSigned").add(this.selfSigned);} else { this.selfSigned = null; _visitables.get("selfSigned").remove(this.selfSigned); } return (A) this;
  }
  public Boolean hasSelfSigned() {
    return this.selfSigned != null;
  }
  public IssuerSpecFluent.SelfSignedNested<A> withNewSelfSigned() {
    return new IssuerSpecFluentImpl.SelfSignedNestedImpl();
  }
  public IssuerSpecFluent.SelfSignedNested<A> withNewSelfSignedLike(SelfSignedIssuer item) {
    return new IssuerSpecFluentImpl.SelfSignedNestedImpl(item);
  }
  public IssuerSpecFluent.SelfSignedNested<A> editSelfSigned() {
    return withNewSelfSignedLike(getSelfSigned());
  }
  public IssuerSpecFluent.SelfSignedNested<A> editOrNewSelfSigned() {
    return withNewSelfSignedLike(getSelfSigned() != null ? getSelfSigned(): new SelfSignedIssuerBuilder().build());
  }
  public IssuerSpecFluent.SelfSignedNested<A> editOrNewSelfSignedLike(SelfSignedIssuer item) {
    return withNewSelfSignedLike(getSelfSigned() != null ? getSelfSigned(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildVault instead.
   * @return The buildable object.
   */
  @Deprecated
  public VaultIssuer getVault() {
    return this.vault!=null ?this.vault.build():null;
  }
  public VaultIssuer buildVault() {
    return this.vault!=null ?this.vault.build():null;
  }
  public A withVault(VaultIssuer vault) {
    _visitables.get("vault").remove(this.vault);
    if (vault!=null){ this.vault= new VaultIssuerBuilder(vault); _visitables.get("vault").add(this.vault);} else { this.vault = null; _visitables.get("vault").remove(this.vault); } return (A) this;
  }
  public Boolean hasVault() {
    return this.vault != null;
  }
  public IssuerSpecFluent.VaultNested<A> withNewVault() {
    return new IssuerSpecFluentImpl.VaultNestedImpl();
  }
  public IssuerSpecFluent.VaultNested<A> withNewVaultLike(VaultIssuer item) {
    return new IssuerSpecFluentImpl.VaultNestedImpl(item);
  }
  public IssuerSpecFluent.VaultNested<A> editVault() {
    return withNewVaultLike(getVault());
  }
  public IssuerSpecFluent.VaultNested<A> editOrNewVault() {
    return withNewVaultLike(getVault() != null ? getVault(): new VaultIssuerBuilder().build());
  }
  public IssuerSpecFluent.VaultNested<A> editOrNewVaultLike(VaultIssuer item) {
    return withNewVaultLike(getVault() != null ? getVault(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildVenafi instead.
   * @return The buildable object.
   */
  @Deprecated
  public VenafiIssuer getVenafi() {
    return this.venafi!=null ?this.venafi.build():null;
  }
  public VenafiIssuer buildVenafi() {
    return this.venafi!=null ?this.venafi.build():null;
  }
  public A withVenafi(VenafiIssuer venafi) {
    _visitables.get("venafi").remove(this.venafi);
    if (venafi!=null){ this.venafi= new VenafiIssuerBuilder(venafi); _visitables.get("venafi").add(this.venafi);} else { this.venafi = null; _visitables.get("venafi").remove(this.venafi); } return (A) this;
  }
  public Boolean hasVenafi() {
    return this.venafi != null;
  }
  public IssuerSpecFluent.VenafiNested<A> withNewVenafi() {
    return new IssuerSpecFluentImpl.VenafiNestedImpl();
  }
  public IssuerSpecFluent.VenafiNested<A> withNewVenafiLike(VenafiIssuer item) {
    return new IssuerSpecFluentImpl.VenafiNestedImpl(item);
  }
  public IssuerSpecFluent.VenafiNested<A> editVenafi() {
    return withNewVenafiLike(getVenafi());
  }
  public IssuerSpecFluent.VenafiNested<A> editOrNewVenafi() {
    return withNewVenafiLike(getVenafi() != null ? getVenafi(): new VenafiIssuerBuilder().build());
  }
  public IssuerSpecFluent.VenafiNested<A> editOrNewVenafiLike(VenafiIssuer item) {
    return withNewVenafiLike(getVenafi() != null ? getVenafi(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IssuerSpecFluentImpl that = (IssuerSpecFluentImpl) o;
    if (acme != null ? !acme.equals(that.acme) :that.acme != null) return false;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (selfSigned != null ? !selfSigned.equals(that.selfSigned) :that.selfSigned != null) return false;
    if (vault != null ? !vault.equals(that.vault) :that.vault != null) return false;
    if (venafi != null ? !venafi.equals(that.venafi) :that.venafi != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(acme,  ca,  selfSigned,  vault,  venafi,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (acme != null) { sb.append("acme:"); sb.append(acme + ","); }
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (selfSigned != null) { sb.append("selfSigned:"); sb.append(selfSigned + ","); }
    if (vault != null) { sb.append("vault:"); sb.append(vault + ","); }
    if (venafi != null) { sb.append("venafi:"); sb.append(venafi); }
    sb.append("}");
    return sb.toString();
  }
  class AcmeNestedImpl<N> extends ACMEIssuerFluentImpl<IssuerSpecFluent.AcmeNested<N>> implements IssuerSpecFluent.AcmeNested<N>,Nested<N>{
    AcmeNestedImpl(ACMEIssuer item) {
      this.builder = new ACMEIssuerBuilder(this, item);
    }
    AcmeNestedImpl() {
      this.builder = new ACMEIssuerBuilder(this);
    }
    ACMEIssuerBuilder builder;
    public N and() {
      return (N) IssuerSpecFluentImpl.this.withAcme(builder.build());
    }
    public N endAcme() {
      return and();
    }
    
  }
  class CaNestedImpl<N> extends CAIssuerFluentImpl<IssuerSpecFluent.CaNested<N>> implements IssuerSpecFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(CAIssuer item) {
      this.builder = new CAIssuerBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new CAIssuerBuilder(this);
    }
    CAIssuerBuilder builder;
    public N and() {
      return (N) IssuerSpecFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class SelfSignedNestedImpl<N> extends SelfSignedIssuerFluentImpl<IssuerSpecFluent.SelfSignedNested<N>> implements IssuerSpecFluent.SelfSignedNested<N>,Nested<N>{
    SelfSignedNestedImpl(SelfSignedIssuer item) {
      this.builder = new SelfSignedIssuerBuilder(this, item);
    }
    SelfSignedNestedImpl() {
      this.builder = new SelfSignedIssuerBuilder(this);
    }
    SelfSignedIssuerBuilder builder;
    public N and() {
      return (N) IssuerSpecFluentImpl.this.withSelfSigned(builder.build());
    }
    public N endSelfSigned() {
      return and();
    }
    
  }
  class VaultNestedImpl<N> extends VaultIssuerFluentImpl<IssuerSpecFluent.VaultNested<N>> implements IssuerSpecFluent.VaultNested<N>,Nested<N>{
    VaultNestedImpl(VaultIssuer item) {
      this.builder = new VaultIssuerBuilder(this, item);
    }
    VaultNestedImpl() {
      this.builder = new VaultIssuerBuilder(this);
    }
    VaultIssuerBuilder builder;
    public N and() {
      return (N) IssuerSpecFluentImpl.this.withVault(builder.build());
    }
    public N endVault() {
      return and();
    }
    
  }
  class VenafiNestedImpl<N> extends VenafiIssuerFluentImpl<IssuerSpecFluent.VenafiNested<N>> implements IssuerSpecFluent.VenafiNested<N>,Nested<N>{
    VenafiNestedImpl(VenafiIssuer item) {
      this.builder = new VenafiIssuerBuilder(this, item);
    }
    VenafiNestedImpl() {
      this.builder = new VenafiIssuerBuilder(this);
    }
    VenafiIssuerBuilder builder;
    public N and() {
      return (N) IssuerSpecFluentImpl.this.withVenafi(builder.build());
    }
    public N endVenafi() {
      return and();
    }
    
  }
  
}