package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatusFluent;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerStatus;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface IssuerStatusFluent<A extends IssuerStatusFluent<A>> extends Fluent<A>{
  
  /**
   * This method has been deprecated, please use method buildAcme instead.
   * @return The buildable object.
   */
  @Deprecated
  public ACMEIssuerStatus getAcme();
  public ACMEIssuerStatus buildAcme();
  public A withAcme(ACMEIssuerStatus acme);
  public Boolean hasAcme();
  public A withNewAcme(String lastRegisteredEmail,String uri);
  public IssuerStatusFluent.AcmeNested<A> withNewAcme();
  public IssuerStatusFluent.AcmeNested<A> withNewAcmeLike(ACMEIssuerStatus item);
  public IssuerStatusFluent.AcmeNested<A> editAcme();
  public IssuerStatusFluent.AcmeNested<A> editOrNewAcme();
  public IssuerStatusFluent.AcmeNested<A> editOrNewAcmeLike(ACMEIssuerStatus item);
  public A addToConditions(Integer index,IssuerCondition item);
  public A setToConditions(Integer index,IssuerCondition item);
  public A addToConditions(io.fabric8.certmanager.api.model.v1.IssuerCondition... items);
  public A addAllToConditions(Collection<IssuerCondition> items);
  public A removeFromConditions(io.fabric8.certmanager.api.model.v1.IssuerCondition... items);
  public A removeAllFromConditions(Collection<IssuerCondition> items);
  public A removeMatchingFromConditions(Predicate<IssuerConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IssuerCondition> getConditions();
  public List<IssuerCondition> buildConditions();
  public IssuerCondition buildCondition(Integer index);
  public IssuerCondition buildFirstCondition();
  public IssuerCondition buildLastCondition();
  public IssuerCondition buildMatchingCondition(Predicate<IssuerConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<IssuerConditionBuilder> predicate);
  public A withConditions(List<IssuerCondition> conditions);
  public A withConditions(io.fabric8.certmanager.api.model.v1.IssuerCondition... conditions);
  public Boolean hasConditions();
  public IssuerStatusFluent.ConditionsNested<A> addNewCondition();
  public IssuerStatusFluent.ConditionsNested<A> addNewConditionLike(IssuerCondition item);
  public IssuerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,IssuerCondition item);
  public IssuerStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public IssuerStatusFluent.ConditionsNested<A> editFirstCondition();
  public IssuerStatusFluent.ConditionsNested<A> editLastCondition();
  public IssuerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IssuerConditionBuilder> predicate);
  public interface AcmeNested<N> extends Nested<N>,ACMEIssuerStatusFluent<IssuerStatusFluent.AcmeNested<N>>{
    public N and();
    public N endAcme();
    
  }
  public interface ConditionsNested<N> extends Nested<N>,IssuerConditionFluent<IssuerStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  
}