package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultAppRoleBuilder extends VaultAppRoleFluentImpl<VaultAppRoleBuilder> implements VisitableBuilder<VaultAppRole,VaultAppRoleBuilder>{
  public VaultAppRoleBuilder() {
    this(false);
  }
  public VaultAppRoleBuilder(Boolean validationEnabled) {
    this(new VaultAppRole(), validationEnabled);
  }
  public VaultAppRoleBuilder(VaultAppRoleFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultAppRoleBuilder(VaultAppRoleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VaultAppRole(), validationEnabled);
  }
  public VaultAppRoleBuilder(VaultAppRoleFluent<?> fluent,VaultAppRole instance) {
    this(fluent, instance, false);
  }
  public VaultAppRoleBuilder(VaultAppRoleFluent<?> fluent,VaultAppRole instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPath(instance.getPath()); 
    fluent.withRoleId(instance.getRoleId()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultAppRoleBuilder(VaultAppRole instance) {
    this(instance,false);
  }
  public VaultAppRoleBuilder(VaultAppRole instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPath(instance.getPath()); 
    this.withRoleId(instance.getRoleId()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  VaultAppRoleFluent<?> fluent;
  Boolean validationEnabled;
  public VaultAppRole build() {
    VaultAppRole buildable = new VaultAppRole(fluent.getPath(),fluent.getRoleId(),fluent.getSecretRef());
    return buildable;
  }
  
}