package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultKubernetesAuthBuilder extends VaultKubernetesAuthFluentImpl<VaultKubernetesAuthBuilder> implements VisitableBuilder<VaultKubernetesAuth,VaultKubernetesAuthBuilder>{
  public VaultKubernetesAuthBuilder() {
    this(false);
  }
  public VaultKubernetesAuthBuilder(Boolean validationEnabled) {
    this(new VaultKubernetesAuth(), validationEnabled);
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VaultKubernetesAuth(), validationEnabled);
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent,VaultKubernetesAuth instance) {
    this(fluent, instance, false);
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent,VaultKubernetesAuth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMountPath(instance.getMountPath()); 
    fluent.withRole(instance.getRole()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuth instance) {
    this(instance,false);
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuth instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMountPath(instance.getMountPath()); 
    this.withRole(instance.getRole()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  VaultKubernetesAuthFluent<?> fluent;
  Boolean validationEnabled;
  public VaultKubernetesAuth build() {
    VaultKubernetesAuth buildable = new VaultKubernetesAuth(fluent.getMountPath(),fluent.getRole(),fluent.getSecretRef());
    return buildable;
  }
  
}