package io.fabric8.certmanager.api.model.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class X509SubjectFluentImpl<A extends X509SubjectFluent<A>> extends BaseFluent<A> implements X509SubjectFluent<A>{
  public X509SubjectFluentImpl() {
  }
  public X509SubjectFluentImpl(X509Subject instance) {
    this.withCountries(instance.getCountries()); 
    this.withLocalities(instance.getLocalities()); 
    this.withOrganizationalUnits(instance.getOrganizationalUnits()); 
    this.withOrganizations(instance.getOrganizations()); 
    this.withPostalCodes(instance.getPostalCodes()); 
    this.withProvinces(instance.getProvinces()); 
    this.withSerialNumber(instance.getSerialNumber()); 
    this.withStreetAddresses(instance.getStreetAddresses()); 
  }
  private List<String> countries = new ArrayList<String>();
  private List<String> localities = new ArrayList<String>();
  private List<String> organizationalUnits = new ArrayList<String>();
  private List<String> organizations = new ArrayList<String>();
  private List<String> postalCodes = new ArrayList<String>();
  private List<String> provinces = new ArrayList<String>();
  private String serialNumber;
  private List<String> streetAddresses = new ArrayList<String>();
  public A addToCountries(Integer index,String item) {
    if (this.countries == null) {this.countries = new ArrayList<String>();}
    this.countries.add(index, item);
    return (A)this;
  }
  public A setToCountries(Integer index,String item) {
    if (this.countries == null) {this.countries = new ArrayList<String>();}
    this.countries.set(index, item); return (A)this;
  }
  public A addToCountries(java.lang.String... items) {
    if (this.countries == null) {this.countries = new ArrayList<String>();}
    for (String item : items) {this.countries.add(item);} return (A)this;
  }
  public A addAllToCountries(Collection<String> items) {
    if (this.countries == null) {this.countries = new ArrayList<String>();}
    for (String item : items) {this.countries.add(item);} return (A)this;
  }
  public A removeFromCountries(java.lang.String... items) {
    for (String item : items) {if (this.countries!= null){ this.countries.remove(item);}} return (A)this;
  }
  public A removeAllFromCountries(Collection<String> items) {
    for (String item : items) {if (this.countries!= null){ this.countries.remove(item);}} return (A)this;
  }
  public List<String> getCountries() {
    return this.countries;
  }
  public String getCountry(Integer index) {
    return this.countries.get(index);
  }
  public String getFirstCountry() {
    return this.countries.get(0);
  }
  public String getLastCountry() {
    return this.countries.get(countries.size() - 1);
  }
  public String getMatchingCountry(Predicate<String> predicate) {
    for (String item: countries) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCountry(Predicate<String> predicate) {
    for (String item: countries) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCountries(List<String> countries) {
    if (countries != null) {this.countries = new ArrayList(); for (String item : countries){this.addToCountries(item);}} else { this.countries = null;} return (A) this;
  }
  public A withCountries(java.lang.String... countries) {
    if (this.countries != null) {this.countries.clear();}
    if (countries != null) {for (String item :countries){ this.addToCountries(item);}} return (A) this;
  }
  public Boolean hasCountries() {
    return countries != null && !countries.isEmpty();
  }
  public A addToLocalities(Integer index,String item) {
    if (this.localities == null) {this.localities = new ArrayList<String>();}
    this.localities.add(index, item);
    return (A)this;
  }
  public A setToLocalities(Integer index,String item) {
    if (this.localities == null) {this.localities = new ArrayList<String>();}
    this.localities.set(index, item); return (A)this;
  }
  public A addToLocalities(java.lang.String... items) {
    if (this.localities == null) {this.localities = new ArrayList<String>();}
    for (String item : items) {this.localities.add(item);} return (A)this;
  }
  public A addAllToLocalities(Collection<String> items) {
    if (this.localities == null) {this.localities = new ArrayList<String>();}
    for (String item : items) {this.localities.add(item);} return (A)this;
  }
  public A removeFromLocalities(java.lang.String... items) {
    for (String item : items) {if (this.localities!= null){ this.localities.remove(item);}} return (A)this;
  }
  public A removeAllFromLocalities(Collection<String> items) {
    for (String item : items) {if (this.localities!= null){ this.localities.remove(item);}} return (A)this;
  }
  public List<String> getLocalities() {
    return this.localities;
  }
  public String getLocality(Integer index) {
    return this.localities.get(index);
  }
  public String getFirstLocality() {
    return this.localities.get(0);
  }
  public String getLastLocality() {
    return this.localities.get(localities.size() - 1);
  }
  public String getMatchingLocality(Predicate<String> predicate) {
    for (String item: localities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingLocality(Predicate<String> predicate) {
    for (String item: localities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLocalities(List<String> localities) {
    if (localities != null) {this.localities = new ArrayList(); for (String item : localities){this.addToLocalities(item);}} else { this.localities = null;} return (A) this;
  }
  public A withLocalities(java.lang.String... localities) {
    if (this.localities != null) {this.localities.clear();}
    if (localities != null) {for (String item :localities){ this.addToLocalities(item);}} return (A) this;
  }
  public Boolean hasLocalities() {
    return localities != null && !localities.isEmpty();
  }
  public A addToOrganizationalUnits(Integer index,String item) {
    if (this.organizationalUnits == null) {this.organizationalUnits = new ArrayList<String>();}
    this.organizationalUnits.add(index, item);
    return (A)this;
  }
  public A setToOrganizationalUnits(Integer index,String item) {
    if (this.organizationalUnits == null) {this.organizationalUnits = new ArrayList<String>();}
    this.organizationalUnits.set(index, item); return (A)this;
  }
  public A addToOrganizationalUnits(java.lang.String... items) {
    if (this.organizationalUnits == null) {this.organizationalUnits = new ArrayList<String>();}
    for (String item : items) {this.organizationalUnits.add(item);} return (A)this;
  }
  public A addAllToOrganizationalUnits(Collection<String> items) {
    if (this.organizationalUnits == null) {this.organizationalUnits = new ArrayList<String>();}
    for (String item : items) {this.organizationalUnits.add(item);} return (A)this;
  }
  public A removeFromOrganizationalUnits(java.lang.String... items) {
    for (String item : items) {if (this.organizationalUnits!= null){ this.organizationalUnits.remove(item);}} return (A)this;
  }
  public A removeAllFromOrganizationalUnits(Collection<String> items) {
    for (String item : items) {if (this.organizationalUnits!= null){ this.organizationalUnits.remove(item);}} return (A)this;
  }
  public List<String> getOrganizationalUnits() {
    return this.organizationalUnits;
  }
  public String getOrganizationalUnit(Integer index) {
    return this.organizationalUnits.get(index);
  }
  public String getFirstOrganizationalUnit() {
    return this.organizationalUnits.get(0);
  }
  public String getLastOrganizationalUnit() {
    return this.organizationalUnits.get(organizationalUnits.size() - 1);
  }
  public String getMatchingOrganizationalUnit(Predicate<String> predicate) {
    for (String item: organizationalUnits) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOrganizationalUnit(Predicate<String> predicate) {
    for (String item: organizationalUnits) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOrganizationalUnits(List<String> organizationalUnits) {
    if (organizationalUnits != null) {this.organizationalUnits = new ArrayList(); for (String item : organizationalUnits){this.addToOrganizationalUnits(item);}} else { this.organizationalUnits = null;} return (A) this;
  }
  public A withOrganizationalUnits(java.lang.String... organizationalUnits) {
    if (this.organizationalUnits != null) {this.organizationalUnits.clear();}
    if (organizationalUnits != null) {for (String item :organizationalUnits){ this.addToOrganizationalUnits(item);}} return (A) this;
  }
  public Boolean hasOrganizationalUnits() {
    return organizationalUnits != null && !organizationalUnits.isEmpty();
  }
  public A addToOrganizations(Integer index,String item) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    this.organizations.add(index, item);
    return (A)this;
  }
  public A setToOrganizations(Integer index,String item) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    this.organizations.set(index, item); return (A)this;
  }
  public A addToOrganizations(java.lang.String... items) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    for (String item : items) {this.organizations.add(item);} return (A)this;
  }
  public A addAllToOrganizations(Collection<String> items) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    for (String item : items) {this.organizations.add(item);} return (A)this;
  }
  public A removeFromOrganizations(java.lang.String... items) {
    for (String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
  }
  public A removeAllFromOrganizations(Collection<String> items) {
    for (String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
  }
  public List<String> getOrganizations() {
    return this.organizations;
  }
  public String getOrganization(Integer index) {
    return this.organizations.get(index);
  }
  public String getFirstOrganization() {
    return this.organizations.get(0);
  }
  public String getLastOrganization() {
    return this.organizations.get(organizations.size() - 1);
  }
  public String getMatchingOrganization(Predicate<String> predicate) {
    for (String item: organizations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOrganization(Predicate<String> predicate) {
    for (String item: organizations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOrganizations(List<String> organizations) {
    if (organizations != null) {this.organizations = new ArrayList(); for (String item : organizations){this.addToOrganizations(item);}} else { this.organizations = null;} return (A) this;
  }
  public A withOrganizations(java.lang.String... organizations) {
    if (this.organizations != null) {this.organizations.clear();}
    if (organizations != null) {for (String item :organizations){ this.addToOrganizations(item);}} return (A) this;
  }
  public Boolean hasOrganizations() {
    return organizations != null && !organizations.isEmpty();
  }
  public A addToPostalCodes(Integer index,String item) {
    if (this.postalCodes == null) {this.postalCodes = new ArrayList<String>();}
    this.postalCodes.add(index, item);
    return (A)this;
  }
  public A setToPostalCodes(Integer index,String item) {
    if (this.postalCodes == null) {this.postalCodes = new ArrayList<String>();}
    this.postalCodes.set(index, item); return (A)this;
  }
  public A addToPostalCodes(java.lang.String... items) {
    if (this.postalCodes == null) {this.postalCodes = new ArrayList<String>();}
    for (String item : items) {this.postalCodes.add(item);} return (A)this;
  }
  public A addAllToPostalCodes(Collection<String> items) {
    if (this.postalCodes == null) {this.postalCodes = new ArrayList<String>();}
    for (String item : items) {this.postalCodes.add(item);} return (A)this;
  }
  public A removeFromPostalCodes(java.lang.String... items) {
    for (String item : items) {if (this.postalCodes!= null){ this.postalCodes.remove(item);}} return (A)this;
  }
  public A removeAllFromPostalCodes(Collection<String> items) {
    for (String item : items) {if (this.postalCodes!= null){ this.postalCodes.remove(item);}} return (A)this;
  }
  public List<String> getPostalCodes() {
    return this.postalCodes;
  }
  public String getPostalCode(Integer index) {
    return this.postalCodes.get(index);
  }
  public String getFirstPostalCode() {
    return this.postalCodes.get(0);
  }
  public String getLastPostalCode() {
    return this.postalCodes.get(postalCodes.size() - 1);
  }
  public String getMatchingPostalCode(Predicate<String> predicate) {
    for (String item: postalCodes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPostalCode(Predicate<String> predicate) {
    for (String item: postalCodes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPostalCodes(List<String> postalCodes) {
    if (postalCodes != null) {this.postalCodes = new ArrayList(); for (String item : postalCodes){this.addToPostalCodes(item);}} else { this.postalCodes = null;} return (A) this;
  }
  public A withPostalCodes(java.lang.String... postalCodes) {
    if (this.postalCodes != null) {this.postalCodes.clear();}
    if (postalCodes != null) {for (String item :postalCodes){ this.addToPostalCodes(item);}} return (A) this;
  }
  public Boolean hasPostalCodes() {
    return postalCodes != null && !postalCodes.isEmpty();
  }
  public A addToProvinces(Integer index,String item) {
    if (this.provinces == null) {this.provinces = new ArrayList<String>();}
    this.provinces.add(index, item);
    return (A)this;
  }
  public A setToProvinces(Integer index,String item) {
    if (this.provinces == null) {this.provinces = new ArrayList<String>();}
    this.provinces.set(index, item); return (A)this;
  }
  public A addToProvinces(java.lang.String... items) {
    if (this.provinces == null) {this.provinces = new ArrayList<String>();}
    for (String item : items) {this.provinces.add(item);} return (A)this;
  }
  public A addAllToProvinces(Collection<String> items) {
    if (this.provinces == null) {this.provinces = new ArrayList<String>();}
    for (String item : items) {this.provinces.add(item);} return (A)this;
  }
  public A removeFromProvinces(java.lang.String... items) {
    for (String item : items) {if (this.provinces!= null){ this.provinces.remove(item);}} return (A)this;
  }
  public A removeAllFromProvinces(Collection<String> items) {
    for (String item : items) {if (this.provinces!= null){ this.provinces.remove(item);}} return (A)this;
  }
  public List<String> getProvinces() {
    return this.provinces;
  }
  public String getProvince(Integer index) {
    return this.provinces.get(index);
  }
  public String getFirstProvince() {
    return this.provinces.get(0);
  }
  public String getLastProvince() {
    return this.provinces.get(provinces.size() - 1);
  }
  public String getMatchingProvince(Predicate<String> predicate) {
    for (String item: provinces) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingProvince(Predicate<String> predicate) {
    for (String item: provinces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withProvinces(List<String> provinces) {
    if (provinces != null) {this.provinces = new ArrayList(); for (String item : provinces){this.addToProvinces(item);}} else { this.provinces = null;} return (A) this;
  }
  public A withProvinces(java.lang.String... provinces) {
    if (this.provinces != null) {this.provinces.clear();}
    if (provinces != null) {for (String item :provinces){ this.addToProvinces(item);}} return (A) this;
  }
  public Boolean hasProvinces() {
    return provinces != null && !provinces.isEmpty();
  }
  public String getSerialNumber() {
    return this.serialNumber;
  }
  public A withSerialNumber(String serialNumber) {
    this.serialNumber=serialNumber; return (A) this;
  }
  public Boolean hasSerialNumber() {
    return this.serialNumber != null;
  }
  public A addToStreetAddresses(Integer index,String item) {
    if (this.streetAddresses == null) {this.streetAddresses = new ArrayList<String>();}
    this.streetAddresses.add(index, item);
    return (A)this;
  }
  public A setToStreetAddresses(Integer index,String item) {
    if (this.streetAddresses == null) {this.streetAddresses = new ArrayList<String>();}
    this.streetAddresses.set(index, item); return (A)this;
  }
  public A addToStreetAddresses(java.lang.String... items) {
    if (this.streetAddresses == null) {this.streetAddresses = new ArrayList<String>();}
    for (String item : items) {this.streetAddresses.add(item);} return (A)this;
  }
  public A addAllToStreetAddresses(Collection<String> items) {
    if (this.streetAddresses == null) {this.streetAddresses = new ArrayList<String>();}
    for (String item : items) {this.streetAddresses.add(item);} return (A)this;
  }
  public A removeFromStreetAddresses(java.lang.String... items) {
    for (String item : items) {if (this.streetAddresses!= null){ this.streetAddresses.remove(item);}} return (A)this;
  }
  public A removeAllFromStreetAddresses(Collection<String> items) {
    for (String item : items) {if (this.streetAddresses!= null){ this.streetAddresses.remove(item);}} return (A)this;
  }
  public List<String> getStreetAddresses() {
    return this.streetAddresses;
  }
  public String getStreetAddress(Integer index) {
    return this.streetAddresses.get(index);
  }
  public String getFirstStreetAddress() {
    return this.streetAddresses.get(0);
  }
  public String getLastStreetAddress() {
    return this.streetAddresses.get(streetAddresses.size() - 1);
  }
  public String getMatchingStreetAddress(Predicate<String> predicate) {
    for (String item: streetAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingStreetAddress(Predicate<String> predicate) {
    for (String item: streetAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStreetAddresses(List<String> streetAddresses) {
    if (streetAddresses != null) {this.streetAddresses = new ArrayList(); for (String item : streetAddresses){this.addToStreetAddresses(item);}} else { this.streetAddresses = null;} return (A) this;
  }
  public A withStreetAddresses(java.lang.String... streetAddresses) {
    if (this.streetAddresses != null) {this.streetAddresses.clear();}
    if (streetAddresses != null) {for (String item :streetAddresses){ this.addToStreetAddresses(item);}} return (A) this;
  }
  public Boolean hasStreetAddresses() {
    return streetAddresses != null && !streetAddresses.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    X509SubjectFluentImpl that = (X509SubjectFluentImpl) o;
    if (countries != null ? !countries.equals(that.countries) :that.countries != null) return false;
    if (localities != null ? !localities.equals(that.localities) :that.localities != null) return false;
    if (organizationalUnits != null ? !organizationalUnits.equals(that.organizationalUnits) :that.organizationalUnits != null) return false;
    if (organizations != null ? !organizations.equals(that.organizations) :that.organizations != null) return false;
    if (postalCodes != null ? !postalCodes.equals(that.postalCodes) :that.postalCodes != null) return false;
    if (provinces != null ? !provinces.equals(that.provinces) :that.provinces != null) return false;
    if (serialNumber != null ? !serialNumber.equals(that.serialNumber) :that.serialNumber != null) return false;
    if (streetAddresses != null ? !streetAddresses.equals(that.streetAddresses) :that.streetAddresses != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(countries,  localities,  organizationalUnits,  organizations,  postalCodes,  provinces,  serialNumber,  streetAddresses,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (countries != null && !countries.isEmpty()) { sb.append("countries:"); sb.append(countries + ","); }
    if (localities != null && !localities.isEmpty()) { sb.append("localities:"); sb.append(localities + ","); }
    if (organizationalUnits != null && !organizationalUnits.isEmpty()) { sb.append("organizationalUnits:"); sb.append(organizationalUnits + ","); }
    if (organizations != null && !organizations.isEmpty()) { sb.append("organizations:"); sb.append(organizations + ","); }
    if (postalCodes != null && !postalCodes.isEmpty()) { sb.append("postalCodes:"); sb.append(postalCodes + ","); }
    if (provinces != null && !provinces.isEmpty()) { sb.append("provinces:"); sb.append(provinces + ","); }
    if (serialNumber != null) { sb.append("serialNumber:"); sb.append(serialNumber + ","); }
    if (streetAddresses != null && !streetAddresses.isEmpty()) { sb.append("streetAddresses:"); sb.append(streetAddresses); }
    sb.append("}");
    return sb.toString();
  }
  
}