/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolver;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolverBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolverFluentImpl;
import io.fabric8.certmanager.api.model.acme.v1.ACMEExternalAccountBinding;
import io.fabric8.certmanager.api.model.acme.v1.ACMEExternalAccountBindingBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEExternalAccountBindingFluentImpl;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuer;
import io.fabric8.certmanager.api.model.acme.v1.ACMEIssuerFluent;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ACMEIssuerFluentImpl<A extends ACMEIssuerFluent<A>>
extends BaseFluent<A>
implements ACMEIssuerFluent<A> {
    private Boolean disableAccountKeyGeneration;
    private String email;
    private Boolean enableDurationFeature;
    private ACMEExternalAccountBindingBuilder externalAccountBinding;
    private String preferredChain;
    private SecretKeySelectorBuilder privateKeySecretRef;
    private String server;
    private Boolean skipTLSVerify;
    private ArrayList<ACMEChallengeSolverBuilder> solvers = new ArrayList();

    public ACMEIssuerFluentImpl() {
    }

    public ACMEIssuerFluentImpl(ACMEIssuer instance) {
        this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration());
        this.withEmail(instance.getEmail());
        this.withEnableDurationFeature(instance.getEnableDurationFeature());
        this.withExternalAccountBinding(instance.getExternalAccountBinding());
        this.withPreferredChain(instance.getPreferredChain());
        this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef());
        this.withServer(instance.getServer());
        this.withSkipTLSVerify(instance.getSkipTLSVerify());
        this.withSolvers(instance.getSolvers());
    }

    @Override
    public Boolean getDisableAccountKeyGeneration() {
        return this.disableAccountKeyGeneration;
    }

    @Override
    public A withDisableAccountKeyGeneration(Boolean disableAccountKeyGeneration) {
        this.disableAccountKeyGeneration = disableAccountKeyGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasDisableAccountKeyGeneration() {
        return this.disableAccountKeyGeneration != null;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public A withEmail(String email) {
        this.email = email;
        return (A)this;
    }

    @Override
    public Boolean hasEmail() {
        return this.email != null;
    }

    @Override
    public Boolean getEnableDurationFeature() {
        return this.enableDurationFeature;
    }

    @Override
    public A withEnableDurationFeature(Boolean enableDurationFeature) {
        this.enableDurationFeature = enableDurationFeature;
        return (A)this;
    }

    @Override
    public Boolean hasEnableDurationFeature() {
        return this.enableDurationFeature != null;
    }

    @Override
    @Deprecated
    public ACMEExternalAccountBinding getExternalAccountBinding() {
        return this.externalAccountBinding != null ? this.externalAccountBinding.build() : null;
    }

    @Override
    public ACMEExternalAccountBinding buildExternalAccountBinding() {
        return this.externalAccountBinding != null ? this.externalAccountBinding.build() : null;
    }

    @Override
    public A withExternalAccountBinding(ACMEExternalAccountBinding externalAccountBinding) {
        this._visitables.get((Object)"externalAccountBinding").remove(this.externalAccountBinding);
        if (externalAccountBinding != null) {
            this.externalAccountBinding = new ACMEExternalAccountBindingBuilder(externalAccountBinding);
            this._visitables.get((Object)"externalAccountBinding").add(this.externalAccountBinding);
        } else {
            this.externalAccountBinding = null;
            this._visitables.get((Object)"externalAccountBinding").remove(this.externalAccountBinding);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalAccountBinding() {
        return this.externalAccountBinding != null;
    }

    @Override
    public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBinding() {
        return new ExternalAccountBindingNestedImpl();
    }

    @Override
    public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
        return new ExternalAccountBindingNestedImpl(item);
    }

    @Override
    public ACMEIssuerFluent.ExternalAccountBindingNested<A> editExternalAccountBinding() {
        return this.withNewExternalAccountBindingLike(this.getExternalAccountBinding());
    }

    @Override
    public ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBinding() {
        return this.withNewExternalAccountBindingLike(this.getExternalAccountBinding() != null ? this.getExternalAccountBinding() : new ACMEExternalAccountBindingBuilder().build());
    }

    @Override
    public ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
        return this.withNewExternalAccountBindingLike(this.getExternalAccountBinding() != null ? this.getExternalAccountBinding() : item);
    }

    @Override
    public String getPreferredChain() {
        return this.preferredChain;
    }

    @Override
    public A withPreferredChain(String preferredChain) {
        this.preferredChain = preferredChain;
        return (A)this;
    }

    @Override
    public Boolean hasPreferredChain() {
        return this.preferredChain != null;
    }

    @Override
    @Deprecated
    public SecretKeySelector getPrivateKeySecretRef() {
        return this.privateKeySecretRef != null ? this.privateKeySecretRef.build() : null;
    }

    @Override
    public SecretKeySelector buildPrivateKeySecretRef() {
        return this.privateKeySecretRef != null ? this.privateKeySecretRef.build() : null;
    }

    @Override
    public A withPrivateKeySecretRef(SecretKeySelector privateKeySecretRef) {
        this._visitables.get((Object)"privateKeySecretRef").remove(this.privateKeySecretRef);
        if (privateKeySecretRef != null) {
            this.privateKeySecretRef = new SecretKeySelectorBuilder(privateKeySecretRef);
            this._visitables.get((Object)"privateKeySecretRef").add(this.privateKeySecretRef);
        } else {
            this.privateKeySecretRef = null;
            this._visitables.get((Object)"privateKeySecretRef").remove(this.privateKeySecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrivateKeySecretRef() {
        return this.privateKeySecretRef != null;
    }

    @Override
    public A withNewPrivateKeySecretRef(String key, String name) {
        return this.withPrivateKeySecretRef(new SecretKeySelector(key, name));
    }

    @Override
    public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRef() {
        return new PrivateKeySecretRefNestedImpl();
    }

    @Override
    public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRefLike(SecretKeySelector item) {
        return new PrivateKeySecretRefNestedImpl(item);
    }

    @Override
    public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editPrivateKeySecretRef() {
        return this.withNewPrivateKeySecretRefLike(this.getPrivateKeySecretRef());
    }

    @Override
    public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRef() {
        return this.withNewPrivateKeySecretRefLike(this.getPrivateKeySecretRef() != null ? this.getPrivateKeySecretRef() : new SecretKeySelectorBuilder().build());
    }

    @Override
    public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRefLike(SecretKeySelector item) {
        return this.withNewPrivateKeySecretRefLike(this.getPrivateKeySecretRef() != null ? this.getPrivateKeySecretRef() : item);
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    @Override
    public Boolean hasServer() {
        return this.server != null;
    }

    @Override
    public Boolean getSkipTLSVerify() {
        return this.skipTLSVerify;
    }

    @Override
    public A withSkipTLSVerify(Boolean skipTLSVerify) {
        this.skipTLSVerify = skipTLSVerify;
        return (A)this;
    }

    @Override
    public Boolean hasSkipTLSVerify() {
        return this.skipTLSVerify != null;
    }

    @Override
    public A addToSolvers(Integer index, ACMEChallengeSolver item) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
        this._visitables.get((Object)"solvers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"solvers").size(), builder);
        this.solvers.add(index >= 0 ? index.intValue() : this.solvers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSolvers(Integer index, ACMEChallengeSolver item) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"solvers").size()) {
            this._visitables.get((Object)"solvers").add(builder);
        } else {
            this._visitables.get((Object)"solvers").set(index, builder);
        }
        if (index < 0 || index >= this.solvers.size()) {
            this.solvers.add(builder);
        } else {
            this.solvers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSolvers(ACMEChallengeSolver ... items) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").add(builder);
            this.solvers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSolvers(Collection<ACMEChallengeSolver> items) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").add(builder);
            this.solvers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSolvers(ACMEChallengeSolver ... items) {
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").remove(builder);
            if (this.solvers == null) continue;
            this.solvers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSolvers(Collection<ACMEChallengeSolver> items) {
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").remove(builder);
            if (this.solvers == null) continue;
            this.solvers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSolvers(Predicate<ACMEChallengeSolverBuilder> predicate) {
        if (this.solvers == null) {
            return (A)this;
        }
        Iterator<ACMEChallengeSolverBuilder> each = this.solvers.iterator();
        List visitables = this._visitables.get((Object)"solvers");
        while (each.hasNext()) {
            ACMEChallengeSolverBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ACMEChallengeSolver> getSolvers() {
        return this.solvers != null ? ACMEIssuerFluentImpl.build(this.solvers) : null;
    }

    @Override
    public List<ACMEChallengeSolver> buildSolvers() {
        return this.solvers != null ? ACMEIssuerFluentImpl.build(this.solvers) : null;
    }

    @Override
    public ACMEChallengeSolver buildSolver(Integer index) {
        return this.solvers.get(index).build();
    }

    @Override
    public ACMEChallengeSolver buildFirstSolver() {
        return this.solvers.get(0).build();
    }

    @Override
    public ACMEChallengeSolver buildLastSolver() {
        return this.solvers.get(this.solvers.size() - 1).build();
    }

    @Override
    public ACMEChallengeSolver buildMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
        for (ACMEChallengeSolverBuilder item : this.solvers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
        for (ACMEChallengeSolverBuilder item : this.solvers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSolvers(List<ACMEChallengeSolver> solvers) {
        if (this.solvers != null) {
            this._visitables.get((Object)"solvers").removeAll(this.solvers);
        }
        if (solvers != null) {
            this.solvers = new ArrayList();
            for (ACMEChallengeSolver item : solvers) {
                this.addToSolvers(item);
            }
        } else {
            this.solvers = null;
        }
        return (A)this;
    }

    @Override
    public A withSolvers(ACMEChallengeSolver ... solvers) {
        if (this.solvers != null) {
            this.solvers.clear();
        }
        if (solvers != null) {
            for (ACMEChallengeSolver item : solvers) {
                this.addToSolvers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSolvers() {
        return this.solvers != null && !this.solvers.isEmpty();
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> addNewSolver() {
        return new SolversNestedImpl();
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> addNewSolverLike(ACMEChallengeSolver item) {
        return new SolversNestedImpl(-1, item);
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> setNewSolverLike(Integer index, ACMEChallengeSolver item) {
        return new SolversNestedImpl(index, item);
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> editSolver(Integer index) {
        if (this.solvers.size() <= index) {
            throw new RuntimeException("Can't edit solvers. Index exceeds size.");
        }
        return this.setNewSolverLike(index, this.buildSolver(index));
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> editFirstSolver() {
        if (this.solvers.size() == 0) {
            throw new RuntimeException("Can't edit first solvers. The list is empty.");
        }
        return this.setNewSolverLike(0, this.buildSolver(0));
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> editLastSolver() {
        int index = this.solvers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last solvers. The list is empty.");
        }
        return this.setNewSolverLike(index, this.buildSolver(index));
    }

    @Override
    public ACMEIssuerFluent.SolversNested<A> editMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.solvers.size(); ++i) {
            if (!predicate.test(this.solvers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching solvers. No match found.");
        }
        return this.setNewSolverLike(index, this.buildSolver(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACMEIssuerFluentImpl that = (ACMEIssuerFluentImpl)o;
        if (this.disableAccountKeyGeneration != null ? !this.disableAccountKeyGeneration.equals(that.disableAccountKeyGeneration) : that.disableAccountKeyGeneration != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.enableDurationFeature != null ? !this.enableDurationFeature.equals(that.enableDurationFeature) : that.enableDurationFeature != null) {
            return false;
        }
        if (this.externalAccountBinding != null ? !this.externalAccountBinding.equals(that.externalAccountBinding) : that.externalAccountBinding != null) {
            return false;
        }
        if (this.preferredChain != null ? !this.preferredChain.equals(that.preferredChain) : that.preferredChain != null) {
            return false;
        }
        if (this.privateKeySecretRef != null ? !this.privateKeySecretRef.equals(that.privateKeySecretRef) : that.privateKeySecretRef != null) {
            return false;
        }
        if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
            return false;
        }
        if (this.skipTLSVerify != null ? !this.skipTLSVerify.equals(that.skipTLSVerify) : that.skipTLSVerify != null) {
            return false;
        }
        return !(this.solvers != null ? !this.solvers.equals(that.solvers) : that.solvers != null);
    }

    public int hashCode() {
        return Objects.hash(this.disableAccountKeyGeneration, this.email, this.enableDurationFeature, this.externalAccountBinding, this.preferredChain, this.privateKeySecretRef, this.server, this.skipTLSVerify, this.solvers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disableAccountKeyGeneration != null) {
            sb.append("disableAccountKeyGeneration:");
            sb.append(this.disableAccountKeyGeneration + ",");
        }
        if (this.email != null) {
            sb.append("email:");
            sb.append(this.email + ",");
        }
        if (this.enableDurationFeature != null) {
            sb.append("enableDurationFeature:");
            sb.append(this.enableDurationFeature + ",");
        }
        if (this.externalAccountBinding != null) {
            sb.append("externalAccountBinding:");
            sb.append(this.externalAccountBinding + ",");
        }
        if (this.preferredChain != null) {
            sb.append("preferredChain:");
            sb.append(this.preferredChain + ",");
        }
        if (this.privateKeySecretRef != null) {
            sb.append("privateKeySecretRef:");
            sb.append(this.privateKeySecretRef + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.skipTLSVerify != null) {
            sb.append("skipTLSVerify:");
            sb.append(this.skipTLSVerify + ",");
        }
        if (this.solvers != null && !this.solvers.isEmpty()) {
            sb.append("solvers:");
            sb.append(this.solvers);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDisableAccountKeyGeneration() {
        return this.withDisableAccountKeyGeneration(true);
    }

    @Override
    public A withEnableDurationFeature() {
        return this.withEnableDurationFeature(true);
    }

    @Override
    public A withSkipTLSVerify() {
        return this.withSkipTLSVerify(true);
    }

    class SolversNestedImpl<N>
    extends ACMEChallengeSolverFluentImpl<ACMEIssuerFluent.SolversNested<N>>
    implements ACMEIssuerFluent.SolversNested<N>,
    Nested<N> {
        ACMEChallengeSolverBuilder builder;
        Integer index;

        SolversNestedImpl(Integer index, ACMEChallengeSolver item) {
            this.index = index;
            this.builder = new ACMEChallengeSolverBuilder(this, item);
        }

        SolversNestedImpl() {
            this.index = -1;
            this.builder = new ACMEChallengeSolverBuilder(this);
        }

        @Override
        public N and() {
            return (N)ACMEIssuerFluentImpl.this.setToSolvers(this.index, this.builder.build());
        }

        @Override
        public N endSolver() {
            return this.and();
        }
    }

    class PrivateKeySecretRefNestedImpl<N>
    extends SecretKeySelectorFluentImpl<ACMEIssuerFluent.PrivateKeySecretRefNested<N>>
    implements ACMEIssuerFluent.PrivateKeySecretRefNested<N>,
    Nested<N> {
        SecretKeySelectorBuilder builder;

        PrivateKeySecretRefNestedImpl(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        PrivateKeySecretRefNestedImpl() {
            this.builder = new SecretKeySelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ACMEIssuerFluentImpl.this.withPrivateKeySecretRef(this.builder.build());
        }

        @Override
        public N endPrivateKeySecretRef() {
            return this.and();
        }
    }

    class ExternalAccountBindingNestedImpl<N>
    extends ACMEExternalAccountBindingFluentImpl<ACMEIssuerFluent.ExternalAccountBindingNested<N>>
    implements ACMEIssuerFluent.ExternalAccountBindingNested<N>,
    Nested<N> {
        ACMEExternalAccountBindingBuilder builder;

        ExternalAccountBindingNestedImpl(ACMEExternalAccountBinding item) {
            this.builder = new ACMEExternalAccountBindingBuilder(this, item);
        }

        ExternalAccountBindingNestedImpl() {
            this.builder = new ACMEExternalAccountBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ACMEIssuerFluentImpl.this.withExternalAccountBinding(this.builder.build());
        }

        @Override
        public N endExternalAccountBinding() {
            return this.and();
        }
    }
}

