/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.certmanager.api.model.v1.CertificateRequestSpec;
import io.fabric8.certmanager.api.model.v1.CertificateRequestSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateRequestSpecFluentImpl<A extends CertificateRequestSpecFluent<A>>
extends BaseFluent<A>
implements CertificateRequestSpecFluent<A> {
    private Duration duration;
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private String request;
    private List<String> usages;

    public CertificateRequestSpecFluentImpl() {
    }

    public CertificateRequestSpecFluentImpl(CertificateRequestSpec instance) {
        this.withDuration(instance.getDuration());
        this.withIsCA(instance.getIsCA());
        this.withIssuerRef(instance.getIssuerRef());
        this.withRequest(instance.getRequest());
        this.withUsages(instance.getUsages());
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public Boolean getIsCA() {
        return this.isCA;
    }

    @Override
    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)this;
    }

    @Override
    public Boolean hasIsCA() {
        return this.isCA != null;
    }

    @Override
    @Deprecated
    public ObjectReference getIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    @Override
    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNestedImpl();
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNestedImpl(item);
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef());
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : item);
    }

    @Override
    public String getRequest() {
        return this.request;
    }

    @Override
    public A withRequest(String request) {
        this.request = request;
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null;
    }

    @Override
    public A addToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsages(String ... items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsages() {
        return this.usages;
    }

    @Override
    public String getUsage(Integer index) {
        return this.usages.get(index);
    }

    @Override
    public String getFirstUsage() {
        return this.usages.get(0);
    }

    @Override
    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    @Override
    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)this;
    }

    @Override
    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateRequestSpecFluentImpl that = (CertificateRequestSpecFluentImpl)o;
        if (this.duration != null ? !this.duration.equals((Object)that.duration) : that.duration != null) {
            return false;
        }
        if (this.isCA != null ? !this.isCA.equals(that.isCA) : that.isCA != null) {
            return false;
        }
        if (this.issuerRef != null ? !this.issuerRef.equals(that.issuerRef) : that.issuerRef != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        return !(this.usages != null ? !this.usages.equals(that.usages) : that.usages != null);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.isCA, this.issuerRef, this.request, this.usages, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append(this.issuerRef + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withIsCA() {
        return this.withIsCA(true);
    }

    class IssuerRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<CertificateRequestSpecFluent.IssuerRefNested<N>>
    implements CertificateRequestSpecFluent.IssuerRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        IssuerRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateRequestSpecFluentImpl.this.withIssuerRef(this.builder.build());
        }

        @Override
        public N endIssuerRef() {
            return this.and();
        }
    }
}

