/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.v1.CAIssuer;
import io.fabric8.certmanager.api.model.v1.CAIssuerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CAIssuerFluentImpl<A extends CAIssuerFluent<A>>
extends BaseFluent<A>
implements CAIssuerFluent<A> {
    private List<String> crlDistributionPoints = new ArrayList<String>();
    private List<String> ocspServers = new ArrayList<String>();
    private String secretName;

    public CAIssuerFluentImpl() {
    }

    public CAIssuerFluentImpl(CAIssuer instance) {
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        this.withOcspServers(instance.getOcspServers());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public A addToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCrlDistributionPoints(String ... items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    @Override
    public String getCrlDistributionPoint(Integer index) {
        return this.crlDistributionPoints.get(index);
    }

    @Override
    public String getFirstCrlDistributionPoint() {
        return this.crlDistributionPoints.get(0);
    }

    @Override
    public String getLastCrlDistributionPoint() {
        return this.crlDistributionPoints.get(this.crlDistributionPoints.size() - 1);
    }

    @Override
    public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
        if (crlDistributionPoints != null) {
            this.crlDistributionPoints = new ArrayList<String>();
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        } else {
            this.crlDistributionPoints = null;
        }
        return (A)this;
    }

    @Override
    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    @Override
    public A addToOcspServers(Integer index, String item) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        this.ocspServers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOcspServers(Integer index, String item) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        this.ocspServers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOcspServers(String ... items) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ocspServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOcspServers(Collection<String> items) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ocspServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOcspServers(String ... items) {
        for (String item : items) {
            if (this.ocspServers == null) continue;
            this.ocspServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOcspServers(Collection<String> items) {
        for (String item : items) {
            if (this.ocspServers == null) continue;
            this.ocspServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOcspServers() {
        return this.ocspServers;
    }

    @Override
    public String getOcspServer(Integer index) {
        return this.ocspServers.get(index);
    }

    @Override
    public String getFirstOcspServer() {
        return this.ocspServers.get(0);
    }

    @Override
    public String getLastOcspServer() {
        return this.ocspServers.get(this.ocspServers.size() - 1);
    }

    @Override
    public String getMatchingOcspServer(Predicate<String> predicate) {
        for (String item : this.ocspServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOcspServer(Predicate<String> predicate) {
        for (String item : this.ocspServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOcspServers(List<String> ocspServers) {
        if (ocspServers != null) {
            this.ocspServers = new ArrayList<String>();
            for (String item : ocspServers) {
                this.addToOcspServers(item);
            }
        } else {
            this.ocspServers = null;
        }
        return (A)this;
    }

    @Override
    public A withOcspServers(String ... ocspServers) {
        if (this.ocspServers != null) {
            this.ocspServers.clear();
        }
        if (ocspServers != null) {
            for (String item : ocspServers) {
                this.addToOcspServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOcspServers() {
        return this.ocspServers != null && !this.ocspServers.isEmpty();
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAIssuerFluentImpl that = (CAIssuerFluentImpl)o;
        if (this.crlDistributionPoints != null ? !this.crlDistributionPoints.equals(that.crlDistributionPoints) : that.crlDistributionPoints != null) {
            return false;
        }
        if (this.ocspServers != null ? !this.ocspServers.equals(that.ocspServers) : that.ocspServers != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints, this.ocspServers, this.secretName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints + ",");
        }
        if (this.ocspServers != null && !this.ocspServers.isEmpty()) {
            sb.append("ocspServers:");
            sb.append(this.ocspServers + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName);
        }
        sb.append("}");
        return sb.toString();
    }
}

