/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VaultKubernetesAuthFluent<A extends VaultKubernetesAuthFluent<A>>
extends BaseFluent<A> {
    private String mountPath;
    private String role;
    private SecretKeySelectorBuilder secretRef;
    private Map<String, Object> additionalProperties;

    public VaultKubernetesAuthFluent() {
    }

    public VaultKubernetesAuthFluent(VaultKubernetesAuth instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VaultKubernetesAuth instance) {
        VaultKubernetesAuth vaultKubernetesAuth = instance = instance != null ? instance : new VaultKubernetesAuth();
        if (instance != null) {
            this.withMountPath(instance.getMountPath());
            this.withRole(instance.getRole());
            this.withSecretRef(instance.getSecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)((Object)this);
    }

    public boolean hasMountPath() {
        return this.mountPath != null;
    }

    public String getRole() {
        return this.role;
    }

    public A withRole(String role) {
        this.role = role;
        return (A)((Object)this);
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public SecretKeySelector buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretKeySelector secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretKeySelectorBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String key, String name) {
        return this.withSecretRef(new SecretKeySelector(key, name));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretKeySelector item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretKeySelector item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultKubernetesAuthFluent that = (VaultKubernetesAuthFluent)((Object)o);
        if (!Objects.equals(this.mountPath, that.mountPath)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mountPath, this.role, this.secretRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append((Object)((Object)this.secretRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretRefNested<N>
    extends SecretKeySelectorFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        SecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)VaultKubernetesAuthFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

