package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CertificateRequestSpecFluent<A extends CertificateRequestSpecFluent<A>> extends Fluent<A>{
  public String getCsr();
  public A withCsr(String csr);
  public Boolean hasCsr();
  public Duration getDuration();
  public A withDuration(Duration duration);
  public Boolean hasDuration();
  public A addToExtra(String key,List<String> value);
  public A addToExtra(Map<String,List<String>> map);
  public A removeFromExtra(String key);
  public A removeFromExtra(Map<String,List<String>> map);
  public Map<String,List<String>> getExtra();
  public <K,V>A withExtra(Map<String,List<String>> extra);
  public Boolean hasExtra();
  public A addToGroups(Integer index,String item);
  public A setToGroups(Integer index,String item);
  public A addToGroups(java.lang.String... items);
  public A addAllToGroups(Collection<String> items);
  public A removeFromGroups(java.lang.String... items);
  public A removeAllFromGroups(Collection<String> items);
  public List<String> getGroups();
  public String getGroup(Integer index);
  public String getFirstGroup();
  public String getLastGroup();
  public String getMatchingGroup(Predicate<String> predicate);
  public Boolean hasMatchingGroup(Predicate<String> predicate);
  public A withGroups(List<String> groups);
  public A withGroups(java.lang.String... groups);
  public Boolean hasGroups();
  public Boolean getIsCA();
  public A withIsCA(Boolean isCA);
  public Boolean hasIsCA();
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef();
  public ObjectReference buildIssuerRef();
  public A withIssuerRef(ObjectReference issuerRef);
  public Boolean hasIssuerRef();
  public A withNewIssuerRef(String group,String kind,String name);
  public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRef();
  public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item);
  public CertificateRequestSpecFluent.IssuerRefNested<A> editIssuerRef();
  public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRef();
  public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item);
  public String getUid();
  public A withUid(String uid);
  public Boolean hasUid();
  public A addToUsages(Integer index,String item);
  public A setToUsages(Integer index,String item);
  public A addToUsages(java.lang.String... items);
  public A addAllToUsages(Collection<String> items);
  public A removeFromUsages(java.lang.String... items);
  public A removeAllFromUsages(Collection<String> items);
  public List<String> getUsages();
  public String getUsage(Integer index);
  public String getFirstUsage();
  public String getLastUsage();
  public String getMatchingUsage(Predicate<String> predicate);
  public Boolean hasMatchingUsage(Predicate<String> predicate);
  public A withUsages(List<String> usages);
  public A withUsages(java.lang.String... usages);
  public Boolean hasUsages();
  public String getUsername();
  public A withUsername(String username);
  public Boolean hasUsername();
  public A withIsCA();
  public interface IssuerRefNested<N> extends Nested<N>,ObjectReferenceFluent<CertificateRequestSpecFluent.IssuerRefNested<N>>{
    public N and();
    public N endIssuerRef();
    
  }
  
}