package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VenafiIssuerBuilder extends VenafiIssuerFluentImpl<VenafiIssuerBuilder> implements VisitableBuilder<VenafiIssuer,VenafiIssuerBuilder>{
  public VenafiIssuerBuilder() {
    this(false);
  }
  public VenafiIssuerBuilder(Boolean validationEnabled) {
    this(new VenafiIssuer(), validationEnabled);
  }
  public VenafiIssuerBuilder(VenafiIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public VenafiIssuerBuilder(VenafiIssuerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VenafiIssuer(), validationEnabled);
  }
  public VenafiIssuerBuilder(VenafiIssuerFluent<?> fluent,VenafiIssuer instance) {
    this(fluent, instance, false);
  }
  public VenafiIssuerBuilder(VenafiIssuerFluent<?> fluent,VenafiIssuer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCloud(instance.getCloud()); 
    fluent.withTpp(instance.getTpp()); 
    fluent.withZone(instance.getZone()); 
    this.validationEnabled = validationEnabled; 
  }
  public VenafiIssuerBuilder(VenafiIssuer instance) {
    this(instance,false);
  }
  public VenafiIssuerBuilder(VenafiIssuer instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCloud(instance.getCloud()); 
    this.withTpp(instance.getTpp()); 
    this.withZone(instance.getZone()); 
    this.validationEnabled = validationEnabled; 
  }
  VenafiIssuerFluent<?> fluent;
  Boolean validationEnabled;
  public VenafiIssuer build() {
    VenafiIssuer buildable = new VenafiIssuer(fluent.getCloud(),fluent.getTpp(),fluent.getZone());
    return buildable;
  }
  
}