package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ChallengeSpecFluent<A extends ChallengeSpecFluent<A>> extends BaseFluent<A>{
  public ChallengeSpecFluent() {
  }
  
  public ChallengeSpecFluent(ChallengeSpec instance) {
    this.copyInstance(instance);
  }
  private String authzURL;
  private String dnsName;
  private ObjectReferenceBuilder issuerRef;
  private String key;
  private ACMEChallengeSolverBuilder solver;
  private String token;
  private String type;
  private String url;
  private Boolean wildcard;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ChallengeSpec instance) {
    instance = (instance != null ? instance : new ChallengeSpec());
    if (instance != null) {
          this.withAuthzURL(instance.getAuthzURL());
          this.withDnsName(instance.getDnsName());
          this.withIssuerRef(instance.getIssuerRef());
          this.withKey(instance.getKey());
          this.withSolver(instance.getSolver());
          this.withToken(instance.getToken());
          this.withType(instance.getType());
          this.withUrl(instance.getUrl());
          this.withWildcard(instance.getWildcard());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAuthzURL() {
    return this.authzURL;
  }
  
  public A withAuthzURL(String authzURL) {
    this.authzURL = authzURL;
    return (A) this;
  }
  
  public boolean hasAuthzURL() {
    return this.authzURL != null;
  }
  
  public String getDnsName() {
    return this.dnsName;
  }
  
  public A withDnsName(String dnsName) {
    this.dnsName = dnsName;
    return (A) this;
  }
  
  public boolean hasDnsName() {
    return this.dnsName != null;
  }
  
  public ObjectReference buildIssuerRef() {
    return this.issuerRef != null ? this.issuerRef.build() : null;
  }
  
  public A withIssuerRef(ObjectReference issuerRef) {
    this._visitables.remove("issuerRef");
    if (issuerRef != null) {
        this.issuerRef = new ObjectReferenceBuilder(issuerRef);
        this._visitables.get("issuerRef").add(this.issuerRef);
    } else {
        this.issuerRef = null;
        this._visitables.get("issuerRef").remove(this.issuerRef);
    }
    return (A) this;
  }
  
  public boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  
  public IssuerRefNested<A> withNewIssuerRef() {
    return new IssuerRefNested(null);
  }
  
  public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new IssuerRefNested(item);
  }
  
  public IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(null));
  }
  
  public IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(item));
  }
  
  public String getKey() {
    return this.key;
  }
  
  public A withKey(String key) {
    this.key = key;
    return (A) this;
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public ACMEChallengeSolver buildSolver() {
    return this.solver != null ? this.solver.build() : null;
  }
  
  public A withSolver(ACMEChallengeSolver solver) {
    this._visitables.remove("solver");
    if (solver != null) {
        this.solver = new ACMEChallengeSolverBuilder(solver);
        this._visitables.get("solver").add(this.solver);
    } else {
        this.solver = null;
        this._visitables.get("solver").remove(this.solver);
    }
    return (A) this;
  }
  
  public boolean hasSolver() {
    return this.solver != null;
  }
  
  public SolverNested<A> withNewSolver() {
    return new SolverNested(null);
  }
  
  public SolverNested<A> withNewSolverLike(ACMEChallengeSolver item) {
    return new SolverNested(item);
  }
  
  public SolverNested<A> editSolver() {
    return withNewSolverLike(java.util.Optional.ofNullable(buildSolver()).orElse(null));
  }
  
  public SolverNested<A> editOrNewSolver() {
    return withNewSolverLike(java.util.Optional.ofNullable(buildSolver()).orElse(new ACMEChallengeSolverBuilder().build()));
  }
  
  public SolverNested<A> editOrNewSolverLike(ACMEChallengeSolver item) {
    return withNewSolverLike(java.util.Optional.ofNullable(buildSolver()).orElse(item));
  }
  
  public String getToken() {
    return this.token;
  }
  
  public A withToken(String token) {
    this.token = token;
    return (A) this;
  }
  
  public boolean hasToken() {
    return this.token != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public Boolean getWildcard() {
    return this.wildcard;
  }
  
  public A withWildcard(Boolean wildcard) {
    this.wildcard = wildcard;
    return (A) this;
  }
  
  public boolean hasWildcard() {
    return this.wildcard != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ChallengeSpecFluent that = (ChallengeSpecFluent) o;
    if (!java.util.Objects.equals(authzURL, that.authzURL)) return false;
    if (!java.util.Objects.equals(dnsName, that.dnsName)) return false;
    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;
    if (!java.util.Objects.equals(key, that.key)) return false;
    if (!java.util.Objects.equals(solver, that.solver)) return false;
    if (!java.util.Objects.equals(token, that.token)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(wildcard, that.wildcard)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authzURL,  dnsName,  issuerRef,  key,  solver,  token,  type,  url,  wildcard,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authzURL != null) { sb.append("authzURL:"); sb.append(authzURL + ","); }
    if (dnsName != null) { sb.append("dnsName:"); sb.append(dnsName + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (solver != null) { sb.append("solver:"); sb.append(solver + ","); }
    if (token != null) { sb.append("token:"); sb.append(token + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (wildcard != null) { sb.append("wildcard:"); sb.append(wildcard + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withWildcard() {
    return withWildcard(true);
  }
  public class IssuerRefNested<N> extends ObjectReferenceFluent<IssuerRefNested<N>> implements Nested<N>{
    IssuerRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ChallengeSpecFluent.this.withIssuerRef(builder.build());
    }
    
    public N endIssuerRef() {
      return and();
    }
    
  
  }
  public class SolverNested<N> extends ACMEChallengeSolverFluent<SolverNested<N>> implements Nested<N>{
    SolverNested(ACMEChallengeSolver item) {
      this.builder = new ACMEChallengeSolverBuilder(this, item);
    }
    ACMEChallengeSolverBuilder builder;
    
    public N and() {
      return (N) ChallengeSpecFluent.this.withSolver(builder.build());
    }
    
    public N endSolver() {
      return and();
    }
    
  
  }

}