package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IssuerConditionBuilder extends IssuerConditionFluent<IssuerConditionBuilder> implements VisitableBuilder<IssuerCondition,IssuerConditionBuilder>{
  public IssuerConditionBuilder() {
    this(new IssuerCondition());
  }
  
  public IssuerConditionBuilder(IssuerConditionFluent<?> fluent) {
    this(fluent, new IssuerCondition());
  }
  
  public IssuerConditionBuilder(IssuerConditionFluent<?> fluent,IssuerCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IssuerConditionBuilder(IssuerCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IssuerConditionFluent<?> fluent;
  
  public IssuerCondition build() {
    IssuerCondition buildable = new IssuerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}